/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final PathFilter SNAPSHOT_DIR_PATH_FILTER;
    private static final Logger LOG;
    public static final PathFilter HIDDEN_FILES_PATH_FILTER;
    private static final PathFilter hiddenFileFilter;
    private static BitSet charToEscape;

    public static boolean moveToTrash(FileSystem fs, Path f, Configuration conf, boolean purge) throws IOException {
        boolean result;
        LOG.debug("deleting  " + f);
        try {
            if (!fs.exists(f)) {
                LOG.warn("The path to moveToTrash does not exist: " + f);
                return true;
            }
            if (purge) {
                LOG.debug("purge is set to true. Not moving to Trash " + f);
            } else {
                result = Trash.moveToAppropriateTrash(fs, f, conf);
                if (result) {
                    LOG.trace("Moved to trash: " + f);
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage() + "; Force to delete it.");
        }
        try {
            result = fs.delete(f, true);
        }
        catch (SnapshotException | RemoteException se) {
            if (se instanceof SnapshotException || se.getCause() instanceof SnapshotException || se.getMessage().contains("Snapshot")) {
                FileUtils.deleteReplRelatedSnapshots(fs, f);
            }
            result = fs.delete(f, true);
        }
        if (!result) {
            LOG.error("Failed to delete " + f);
        }
        return result;
    }

    private static void deleteReplRelatedSnapshots(FileSystem fs, Path path) {
        try {
            FileStatus[] listing;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            for (FileStatus elem : listing = fs.listStatus(new Path(path, ".snapshot"))) {
                if (!elem.getPath().getName().endsWith("replOld") && !elem.getPath().getName().endsWith("replNew")) continue;
                dfs.deleteSnapshot(path, elem.getPath().getName());
            }
        }
        catch (Exception ioe) {
            LOG.warn("Couldn't clean up replication related snapshots", ioe);
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        ContentSummary srcContentSummary;
        boolean copied = false;
        boolean triedDistcp = false;
        if (srcFS.getUri().getScheme().equals("hdfs") && (srcContentSummary = srcFS.getContentSummary(src)).getFileCount() > MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.REPL_COPYFILE_MAXNUMFILES) && srcContentSummary.getLength() > MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.REPL_COPYFILE_MAXSIZE)) {
            LOG.info("Source is " + srcContentSummary.getLength() + " bytes. (MAX: " + MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.REPL_COPYFILE_MAXSIZE) + ")");
            LOG.info("Source is " + srcContentSummary.getFileCount() + " files. (MAX: " + MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.REPL_COPYFILE_MAXNUMFILES) + ")");
            LOG.info("Launch distributed copy (distcp) job.");
            triedDistcp = true;
            copied = FileUtils.distCp(srcFS, Collections.singletonList(src), dst, deleteSource, null, conf);
        }
        if (!triedDistcp) {
            copied = FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf);
        }
        return copied;
    }

    private static boolean distCp(FileSystem srcFS, List<Path> srcPaths, Path dst, boolean deleteSource, String doAsUser, Configuration conf) throws IOException {
        boolean copied = doAsUser == null ? HdfsUtils.runDistCp(srcPaths, dst, conf) : HdfsUtils.runDistCpAs(srcPaths, dst, conf, doAsUser);
        if (copied && deleteSource) {
            for (Path path : srcPaths) {
                srcFS.delete(path, true);
            }
        }
        return copied;
    }

    public static boolean mkdir(FileSystem fs, Path f) throws IOException {
        LOG.info("Creating directory if it doesn't exist: " + f);
        return fs.mkdirs(f);
    }

    public static boolean rename(FileSystem srcFs, FileSystem destFs, Path srcPath, Path destPath) throws IOException {
        LOG.info("Renaming " + srcPath + " to " + destPath);
        if (destFs.exists(destPath)) {
            throw new IOException("Cannot rename the source path. The destination path already exists.");
        }
        if (FileUtils.equalsFileSystem(srcFs, destFs)) {
            return srcFs.rename(srcPath, destPath);
        }
        Configuration conf = new Configuration();
        return FileUtils.copy(srcFs, srcPath, destFs, destPath, true, false, conf);
    }

    private static boolean needsEscaping(char c) {
        return c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<FileStatus> getFileStatusRecurse(Path base, FileSystem fs) {
        try {
            ArrayList<FileStatus> results = new ArrayList<FileStatus>();
            if (FileUtils.isS3a(fs)) {
                FileUtils.listS3FilesRecursive(base, fs, results);
            } else {
                FileUtils.listStatusRecursively(fs, fs.getFileStatus(base), results);
            }
            return results;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), HIDDEN_FILES_PATH_FILTER)) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    private static void listS3FilesRecursive(Path base, FileSystem fs, List<FileStatus> results) throws IOException {
        RemoteIterator<LocatedFileStatus> remoteIterator = fs.listFiles(base, true);
        while (remoteIterator.hasNext()) {
            LocatedFileStatus each = remoteIterator.next();
            Path relativePath = FileUtils.makeRelative(base, each.getPath());
            if (!RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER.accept(relativePath)) continue;
            results.add(each);
        }
    }

    public static Path makeRelative(Path parentPath, Path childPath) {
        Object parentString = parentPath.toString().endsWith("/") ? parentPath.toString() : parentPath.toString() + "/";
        Object childString = childPath.toString().endsWith("/") ? childPath.toString() : childPath.toString() + "/";
        return new Path(((String)childString).replaceFirst((String)parentString, ""));
    }

    public static boolean isS3a(FileSystem fs) {
        try {
            return "s3a".equalsIgnoreCase(fs.getScheme());
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static boolean equalsFileSystem(FileSystem fs1, FileSystem fs2) {
        return fs1.getUri().equals(fs2.getUri());
    }

    public static boolean pathHasSnapshotSubDir(Path p, FileSystem fs) throws IOException {
        FileStatus[] statuses = fs.listStatus(p, SNAPSHOT_DIR_PATH_FILTER);
        return statuses != null && statuses.length != 0;
    }

    public static void makeDir(Path path, Configuration conf) throws MetaException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new MetaException("Unable to : " + path);
        }
    }

    public static boolean isDirEmpty(FileSystem fs, Path path) throws IOException {
        FileStatus[] status;
        return !fs.exists(path) || (status = fs.globStatus(new Path(path, "*"), hiddenFileFilter)).length <= 0;
    }

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            FileSystem fs = FileSystem.get(conf);
            return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        URI fsUri = FileSystem.getDefaultUri(conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    public static boolean isSubdirectory(String parent, String other) {
        return other.startsWith((String)(parent.endsWith("/") ? parent : parent + "/"));
    }

    public static Path getTransformedPath(String name, String subDir, String root) {
        if (root != null) {
            Path newPath = new Path(root);
            if (subDir != null) {
                newPath = new Path(newPath, subDir);
            }
            return new Path(newPath, name);
        }
        return null;
    }

    static {
        char[] clist;
        SNAPSHOT_DIR_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                return ".snapshot".equalsIgnoreCase(p.getName());
            }
        };
        LOG = LoggerFactory.getLogger(FileUtils.class);
        HIDDEN_FILES_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        hiddenFileFilter = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
    }

    public static class RemoteIteratorWithFilter
    implements RemoteIterator<LocatedFileStatus> {
        public static final PathFilter HIDDEN_FILES_FULL_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                do {
                    String name;
                    if (!(name = p.getName()).startsWith("_") && !name.startsWith(".")) continue;
                    return false;
                } while ((p = p.getParent()) != null);
                return true;
            }
        };
        private final RemoteIterator<LocatedFileStatus> iter;
        private final PathFilter filter;
        private LocatedFileStatus nextFile;

        public RemoteIteratorWithFilter(RemoteIterator<LocatedFileStatus> iter, PathFilter filter) throws IOException {
            this.iter = iter;
            this.filter = filter;
            this.findNext();
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.nextFile != null;
        }

        @Override
        public LocatedFileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LocatedFileStatus result = this.nextFile;
            this.findNext();
            return result;
        }

        void findNext() throws IOException {
            while (this.iter.hasNext()) {
                LocatedFileStatus status = this.iter.next();
                if (!this.filter.accept(status.getPath())) continue;
                this.nextFile = status;
                return;
            }
            this.nextFile = null;
        }
    }
}

