/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PartitionSpecWithSharedSD
implements TBase<PartitionSpecWithSharedSD, _Fields>,
Serializable,
Cloneable,
Comparable<PartitionSpecWithSharedSD> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionSpecWithSharedSD");
    private static final TField PARTITIONS_FIELD_DESC = new TField("partitions", 15, 1);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PartitionSpecWithSharedSDStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PartitionSpecWithSharedSDTupleSchemeFactory();
    @Nullable
    private List<PartitionWithoutSD> partitions;
    @Nullable
    private StorageDescriptor sd;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionSpecWithSharedSD() {
    }

    public PartitionSpecWithSharedSD(List<PartitionWithoutSD> partitions, StorageDescriptor sd) {
        this();
        this.partitions = partitions;
        this.sd = sd;
    }

    public PartitionSpecWithSharedSD(PartitionSpecWithSharedSD other) {
        if (other.isSetPartitions()) {
            ArrayList<PartitionWithoutSD> __this__partitions = new ArrayList<PartitionWithoutSD>(other.partitions.size());
            for (PartitionWithoutSD other_element : other.partitions) {
                __this__partitions.add(new PartitionWithoutSD(other_element));
            }
            this.partitions = __this__partitions;
        }
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
    }

    @Override
    public PartitionSpecWithSharedSD deepCopy() {
        return new PartitionSpecWithSharedSD(this);
    }

    @Override
    public void clear() {
        this.partitions = null;
        this.sd = null;
    }

    public int getPartitionsSize() {
        return this.partitions == null ? 0 : this.partitions.size();
    }

    @Nullable
    public Iterator<PartitionWithoutSD> getPartitionsIterator() {
        return this.partitions == null ? null : this.partitions.iterator();
    }

    public void addToPartitions(PartitionWithoutSD elem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<PartitionWithoutSD>();
        }
        this.partitions.add(elem);
    }

    @Nullable
    public List<PartitionWithoutSD> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(@Nullable List<PartitionWithoutSD> partitions) {
        this.partitions = partitions;
    }

    public void unsetPartitions() {
        this.partitions = null;
    }

    public boolean isSetPartitions() {
        return this.partitions != null;
    }

    public void setPartitionsIsSet(boolean value) {
        if (!value) {
            this.partitions = null;
        }
    }

    @Nullable
    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(@Nullable StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PARTITIONS: {
                if (value == null) {
                    this.unsetPartitions();
                    break;
                }
                this.setPartitions((List)value);
                break;
            }
            case SD: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PARTITIONS: {
                return this.getPartitions();
            }
            case SD: {
                return this.getSd();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PARTITIONS: {
                return this.isSetPartitions();
            }
            case SD: {
                return this.isSetSd();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof PartitionSpecWithSharedSD) {
            return this.equals((PartitionSpecWithSharedSD)that);
        }
        return false;
    }

    public boolean equals(PartitionSpecWithSharedSD that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_partitions = this.isSetPartitions();
        boolean that_present_partitions = that.isSetPartitions();
        if (this_present_partitions || that_present_partitions) {
            if (!this_present_partitions || !that_present_partitions) {
                return false;
            }
            if (!this.partitions.equals(that.partitions)) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPartitions() ? 131071 : 524287);
        if (this.isSetPartitions()) {
            hashCode = hashCode * 8191 + this.partitions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSd() ? 131071 : 524287);
        if (this.isSetSd()) {
            hashCode = hashCode * 8191 + this.sd.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PartitionSpecWithSharedSD other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPartitions(), other.isSetPartitions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitions() && (lastComparison = TBaseHelper.compareTo(this.partitions, other.partitions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSd(), other.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo(this.sd, other.sd)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        PartitionSpecWithSharedSD.scheme(iprot).read(iprot, (PartitionSpecWithSharedSD)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        PartitionSpecWithSharedSD.scheme(oprot).write(oprot, (PartitionSpecWithSharedSD)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionSpecWithSharedSD(");
        boolean first = true;
        sb.append("partitions:");
        if (this.partitions == null) {
            sb.append("null");
        } else {
            sb.append(this.partitions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sd != null) {
            this.sd.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PARTITIONS, new FieldMetaData("partitions", 3, new ListMetaData(15, new StructMetaData(12, PartitionWithoutSD.class))));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, new StructMetaData(12, StorageDescriptor.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionSpecWithSharedSD.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PARTITIONS(1, "partitions"),
        SD(2, "sd");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PARTITIONS;
                }
                case 2: {
                    return SD;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class PartitionSpecWithSharedSDStandardSchemeFactory
    implements SchemeFactory {
        private PartitionSpecWithSharedSDStandardSchemeFactory() {
        }

        public PartitionSpecWithSharedSDStandardScheme getScheme() {
            return new PartitionSpecWithSharedSDStandardScheme();
        }
    }

    private static class PartitionSpecWithSharedSDTupleSchemeFactory
    implements SchemeFactory {
        private PartitionSpecWithSharedSDTupleSchemeFactory() {
        }

        public PartitionSpecWithSharedSDTupleScheme getScheme() {
            return new PartitionSpecWithSharedSDTupleScheme();
        }
    }

    private static class PartitionSpecWithSharedSDTupleScheme
    extends TupleScheme<PartitionSpecWithSharedSD> {
        private PartitionSpecWithSharedSDTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, PartitionSpecWithSharedSD struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPartitions()) {
                optionals.set(0);
            }
            if (struct.isSetSd()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetPartitions()) {
                oprot.writeI32(struct.partitions.size());
                for (PartitionWithoutSD _iter434 : struct.partitions) {
                    _iter434.write(oprot);
                }
            }
            if (struct.isSetSd()) {
                struct.sd.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, PartitionSpecWithSharedSD struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                TList _list435 = iprot.readListBegin((byte)12);
                struct.partitions = new ArrayList<PartitionWithoutSD>(_list435.size);
                for (int _i437 = 0; _i437 < _list435.size; ++_i437) {
                    PartitionWithoutSD _elem436 = new PartitionWithoutSD();
                    _elem436.read(iprot);
                    struct.partitions.add(_elem436);
                }
                struct.setPartitionsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.sd = new StorageDescriptor();
                struct.sd.read(iprot);
                struct.setSdIsSet(true);
            }
        }
    }

    private static class PartitionSpecWithSharedSDStandardScheme
    extends StandardScheme<PartitionSpecWithSharedSD> {
        private PartitionSpecWithSharedSDStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, PartitionSpecWithSharedSD struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list430 = iprot.readListBegin();
                            struct.partitions = new ArrayList<PartitionWithoutSD>(_list430.size);
                            for (int _i432 = 0; _i432 < _list430.size; ++_i432) {
                                PartitionWithoutSD _elem431 = new PartitionWithoutSD();
                                _elem431.read(iprot);
                                struct.partitions.add(_elem431);
                            }
                            iprot.readListEnd();
                            struct.setPartitionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.sd = new StorageDescriptor();
                            struct.sd.read(iprot);
                            struct.setSdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, PartitionSpecWithSharedSD struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.partitions != null) {
                oprot.writeFieldBegin(PARTITIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitions.size()));
                for (PartitionWithoutSD _iter433 : struct.partitions) {
                    _iter433.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.sd != null) {
                oprot.writeFieldBegin(SD_FIELD_DESC);
                struct.sd.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

