/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.auth;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hive.com.google.common.base.Splitter;
import org.apache.hive.com.google.common.collect.Sets;
import org.apache.hive.org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.hive.org.apache.thrift.transport.TServerSocket;
import org.apache.hive.org.apache.thrift.transport.TSocket;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthUtils.class);

    public static <T extends TTransport> T configureThriftMaxMessageSize(T transport, int maxMessageSize) {
        if (maxMessageSize > 0) {
            if (transport.getConfiguration() == null) {
                LOG.warn("TTransport {} is returning a null Configuration, Thrift max message size is not getting configured", (Object)transport.getClass().getName());
                return transport;
            }
            transport.getConfiguration().setMaxMessageSize(maxMessageSize);
        }
        return transport;
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) throws TTransportException {
        return HiveAuthUtils.getSocketTransport(host, port, loginTimeout, -1);
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout, int maxMessageSize) throws TTransportException {
        TSocket tSocket = new TSocket(host, port, loginTimeout);
        return HiveAuthUtils.configureThriftMaxMessageSize(tSocket, maxMessageSize);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, TSSLTransportFactory.TSSLTransportParameters params, int maxMessageSize) throws TTransportException {
        TSocket tSSLSocket = null;
        tSSLSocket = params != null ? TSSLTransportFactory.getClientSocket(host, port, loginTimeout, params) : TSSLTransportFactory.getClientSocket(host, port, loginTimeout);
        return HiveAuthUtils.getSSLSocketWithHttps(tSSLSocket, maxMessageSize);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord, String trustStoreType, String trustStoreAlgorithm) throws TTransportException {
        return HiveAuthUtils.getSSLSocket(host, port, loginTimeout, trustStorePath, trustStorePassWord, trustStoreType, trustStoreAlgorithm, -1);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        return HiveAuthUtils.getSSLSocket(host, port, loginTimeout, -1);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, int maxMessageSize) throws TTransportException {
        return HiveAuthUtils.getSSLSocket(host, port, loginTimeout, null, maxMessageSize);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord, String trustStoreType, String trustStoreAlgorithm, int maxMessageSize) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        String tStoreType = trustStoreType.isEmpty() ? KeyStore.getDefaultType() : trustStoreType;
        String tStoreAlgorithm = trustStoreAlgorithm.isEmpty() ? TrustManagerFactory.getDefaultAlgorithm() : trustStoreAlgorithm;
        params.setTrustStore(trustStorePath, trustStorePassWord, tStoreAlgorithm, tStoreType);
        params.requireClientAuth(true);
        return HiveAuthUtils.getSSLSocket(host, port, loginTimeout, params, maxMessageSize);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket, int maxMessageSize) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        if (IPStackUtils.isActiveStackLoopbackIP(sslSocket.getLocalAddress().getHostAddress())) {
            sslParams.setEndpointIdentificationAlgorithm(null);
        } else {
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        }
        sslSocket.setSSLParameters(sslParams);
        TSocket tSocket = new TSocket(sslSocket);
        return HiveAuthUtils.configureThriftMaxMessageSize(tSocket, maxMessageSize);
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        return new TServerSocket(serverAddress);
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, String keyStoreType, String keyStoreAlgorithm, List<String> sslVersionBlacklist, String includeCipherSuites) throws TTransportException, UnknownHostException {
        HashSet<String> includeCS;
        int eSize;
        TSSLTransportFactory.TSSLTransportParameters params = null;
        if (!includeCipherSuites.trim().isEmpty() && (eSize = (includeCS = Sets.newHashSet(Splitter.on(":").trimResults().omitEmptyStrings().split(includeCipherSuites.trim()))).size()) > 0) {
            params = new TSSLTransportFactory.TSSLTransportParameters("TLS", includeCS.toArray(new String[eSize]));
        }
        if (params == null) {
            params = new TSSLTransportFactory.TSSLTransportParameters();
        }
        String kStoreType = keyStoreType.isEmpty() ? KeyStore.getDefaultType() : keyStoreType;
        String kStoreAlgorithm = keyStoreAlgorithm.isEmpty() ? KeyManagerFactory.getDefaultAlgorithm() : keyStoreAlgorithm;
        params.setKeyStore(keyStorePath, keyStorePassWord, kStoreAlgorithm, kStoreType);
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket(portNum, 0, serverAddress.getAddress(), params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase());
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase())) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        return thriftServerSocket;
    }
}

