/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.jdbc.saml.HiveJdbcBrowserClient;
import org.apache.hive.jdbc.saml.IJdbcBrowserClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBrowserClientServlet
extends HttpServlet {
    private final HiveJdbcBrowserClient browserClient;
    private static final Logger LOG = LoggerFactory.getLogger(HttpBrowserClientServlet.class);

    HttpBrowserClientServlet(HiveJdbcBrowserClient browserClient) {
        this.browserClient = browserClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.info("Received request from {}:{} for browserClient at port {}", new Object[]{req.getRemoteAddr(), req.getRemotePort(), this.browserClient.toString()});
        resp.setContentType("text/html");
        resp.setStatus(200);
        String token = req.getParameter("token");
        String msg = req.getParameter("message");
        boolean status = Boolean.parseBoolean(req.getParameter("status"));
        IJdbcBrowserClient.HiveJdbcBrowserServerResponse response = new IJdbcBrowserClient.HiveJdbcBrowserServerResponse(status, msg, token);
        if (response.isSuccessful()) {
            resp.getWriter().write("<body onload=\"waitAndClose()\"> Successfully authenticated. Auto-closing this browser. You may close this window if not automatically closed. </body><script>  function waitAndClose() {    setTimeout(function() {      window.close()    }, 100);  }</script></html>");
        } else {
            resp.getWriter().write("Authentication failed. Please check server logs for details. You may close this window.");
        }
        resp.getWriter().flush();
        this.browserClient.addServerResponse(response);
    }
}

