/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.BaseFileWriterFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;

class HiveFileWriterFactory
extends BaseFileWriterFactory<Record> {
    HiveFileWriterFactory(Table table, FileFormat dataFileFormat, Schema dataSchema, SortOrder dataSortOrder, FileFormat deleteFileFormat, int[] equalityFieldIds, Schema equalityDeleteRowSchema, SortOrder equalityDeleteSortOrder, Schema positionDeleteRowSchema) {
        super(table, dataFileFormat, dataSchema, dataSortOrder, deleteFileFormat, equalityFieldIds, equalityDeleteRowSchema, equalityDeleteSortOrder, positionDeleteRowSchema);
    }

    static Builder builderFor(Table table) {
        return new Builder(table);
    }

    @Override
    protected void configureDataWrite(Avro.DataWriteBuilder builder) {
        builder.createWriterFunc(DataWriter::create);
    }

    @Override
    protected void configureEqualityDelete(Avro.DeleteWriteBuilder builder) {
    }

    @Override
    protected void configurePositionDelete(Avro.DeleteWriteBuilder builder) {
        builder.createWriterFunc(DataWriter::create);
    }

    @Override
    protected void configureDataWrite(Parquet.DataWriteBuilder builder) {
        builder.createWriterFunc(GenericParquetWriter::buildWriter);
    }

    @Override
    protected void configureEqualityDelete(Parquet.DeleteWriteBuilder builder) {
    }

    @Override
    protected void configurePositionDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(GenericParquetWriter::buildWriter);
    }

    @Override
    protected void configureDataWrite(ORC.DataWriteBuilder builder) {
        builder.createWriterFunc(GenericOrcWriter::buildWriter);
    }

    @Override
    protected void configureEqualityDelete(ORC.DeleteWriteBuilder deleteWriteBuilder) {
    }

    @Override
    protected void configurePositionDelete(ORC.DeleteWriteBuilder deleteWriteBuilder) {
        deleteWriteBuilder.createWriterFunc(GenericOrcWriter::buildWriter);
    }

    static class Builder {
        private final Table table;
        private FileFormat dataFileFormat;
        private Schema dataSchema;
        private FileFormat deleteFileFormat;
        private Schema positionDeleteRowSchema;

        Builder(Table table) {
            this.table = table;
        }

        Builder dataFileFormat(FileFormat newDataFileFormat) {
            this.dataFileFormat = newDataFileFormat;
            return this;
        }

        Builder dataSchema(Schema newDataSchema) {
            this.dataSchema = newDataSchema;
            return this;
        }

        Builder deleteFileFormat(FileFormat newDeleteFileFormat) {
            this.deleteFileFormat = newDeleteFileFormat;
            return this;
        }

        Builder positionDeleteRowSchema(Schema newPositionDeleteRowSchema) {
            this.positionDeleteRowSchema = newPositionDeleteRowSchema;
            return this;
        }

        HiveFileWriterFactory build() {
            return new HiveFileWriterFactory(this.table, this.dataFileFormat, this.dataSchema, null, this.deleteFileFormat, null, null, null, this.positionDeleteRowSchema);
        }
    }
}

