/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metasummary;

import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummaryHandler;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummarySchema;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.metasummary.IcebergSummaryRetriever;
import org.apache.iceberg.metasummary.MetadataSummary;
import org.apache.iceberg.metasummary.PuffinStatisticsSummary;
import org.apache.iceberg.metasummary.TablePropertySummary;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergSummaryHandler
implements MetaSummaryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSummaryHandler.class);
    private HiveCatalog catalog;
    private Configuration configuration;
    private List<IcebergSummaryRetriever> summaryRetrievers;
    private UserGroupInformation ugi;

    public void initialize(String catalogName, boolean jsonFormat, MetaSummarySchema schema) throws MetaSummaryHandler.SummaryInitializationException {
        Objects.requireNonNull(schema, "schema is null");
        String mgdWarehouse = MetastoreConf.getAsString((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE);
        String extWarehouse = MetastoreConf.getAsString((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL);
        String uris = MetastoreConf.getAsString((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS);
        HashMap<String, String> propertiesMap = Maps.newHashMap();
        LOG.info("Initializing iceberg summary handler with warehouse:{}\uff0cexternal warehouse:{}\uff0curis:{}", new Object[]{mgdWarehouse, extWarehouse, uris});
        propertiesMap.put("warehouse", mgdWarehouse);
        propertiesMap.put("externalwarehouse", extWarehouse);
        propertiesMap.put("uri", uris);
        PrivilegedAction<HiveCatalog> action = () -> {
            HiveCatalog hiveCatalog = new HiveCatalog();
            hiveCatalog.setConf(this.configuration);
            hiveCatalog.initialize(catalogName, propertiesMap);
            return hiveCatalog;
        };
        String hadoopAuth = this.configuration.get("hadoop.security.authentication", "simple");
        if ("kerberos".equalsIgnoreCase(hadoopAuth)) {
            this.ugi = this.loginKerberosUser();
            this.catalog = (HiveCatalog)this.ugi.doAs(action);
        } else {
            this.catalog = action.run();
        }
        this.summaryRetrievers = Lists.newArrayList();
        this.summaryRetrievers.addAll(Arrays.asList(new PuffinStatisticsSummary(), new MetadataSummary(), new TablePropertySummary()));
        this.summaryRetrievers.forEach(retriever -> {
            retriever.initialize(this.configuration, jsonFormat);
            schema.addFields(retriever.getFieldNames());
        });
    }

    private UserGroupInformation loginKerberosUser() throws MetaSummaryHandler.SummaryInitializationException {
        String principal = MetastoreConf.getAsString((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
        String keytabFile = MetastoreConf.getAsString((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE);
        if (StringUtils.isEmpty((CharSequence)principal)) {
            throw new MetaSummaryHandler.SummaryInitializationException("No principal specified from property: " + MetastoreConf.ConfVars.KERBEROS_PRINCIPAL.getHiveName());
        }
        if (StringUtils.isEmpty((CharSequence)keytabFile)) {
            throw new MetaSummaryHandler.SummaryInitializationException("No keytab specified from property: " + MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE.getHiveName());
        }
        try {
            UserGroupInformation.setConfiguration((Configuration)this.configuration);
            String kerberosName = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
            UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
            return UserGroupInformation.getLoginUser();
        }
        catch (Exception e) {
            LOG.error("Failed to log the user: {} with keytab: {}", (Object)principal, (Object)keytabFile);
            throw new MetaSummaryHandler.SummaryInitializationException("Error while logging the user: " + principal, (Throwable)e);
        }
    }

    public void appendSummary(TableName tableName, MetadataTableSummary tableSummary) {
        Objects.requireNonNull(tableName);
        if (this.summaryRetrievers == null || this.catalog == null) {
            throw new IllegalStateException("The Iceberg summary handler hasn't been initialized yet!");
        }
        LOG.debug("Starting to collect the summary for the table: {}", (Object)tableName);
        TableIdentifier tblId = TableIdentifier.of(tableName.getDb(), tableName.getTable());
        PrivilegedAction<Long> action = () -> {
            long start = System.currentTimeMillis();
            try {
                Table table = this.catalog.loadTable(tblId);
                this.summaryRetrievers.forEach(retriever -> retriever.getMetaSummary(table, tableSummary));
            }
            catch (Exception e) {
                LOG.warn("Error while loading the table: " + tableName, (Throwable)e);
                tableSummary.setDropped(true);
            }
            return System.currentTimeMillis() - start;
        };
        long timeSpent = this.ugi != null ? ((Long)this.ugi.doAs(action)).longValue() : action.run().longValue();
        LOG.debug("Finished the summary collection in {} ms for table: {}", (Object)timeSpent, (Object)tableName);
    }

    public void close() throws Exception {
        if (this.catalog != null) {
            this.catalog.close();
        }
    }

    public void setConf(Configuration conf) {
        this.configuration = new Configuration(Objects.requireNonNull(conf, "conf is null"));
    }

    public Configuration getConf() {
        return this.configuration;
    }
}

