/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class RandomUtil {
    private static final long FIFTY_YEARS_IN_MICROS = 1577880000000000L;
    private static final int ABOUT_380_YEARS_IN_DAYS = 138700;
    private static final long ONE_DAY_IN_MICROS = 86400000000L;
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.!?";
    private static final String DIGITS = "0123456789";

    private RandomUtil() {
    }

    private static boolean negate(int num) {
        return num % 2 == 1;
    }

    public static Object generatePrimitive(Type.PrimitiveType primitive, Random random) {
        int choice = random.nextInt(20);
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return choice < 10;
            }
            case INTEGER: {
                switch (choice) {
                    case 1: {
                        return Integer.MIN_VALUE;
                    }
                    case 2: {
                        return Integer.MAX_VALUE;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return RandomUtil.negate(choice) ? -1 * random.nextInt() : random.nextInt();
            }
            case LONG: {
                switch (choice) {
                    case 1: {
                        return Long.MIN_VALUE;
                    }
                    case 2: {
                        return Long.MAX_VALUE;
                    }
                    case 3: {
                        return 0L;
                    }
                }
                return RandomUtil.negate(choice) ? -1L * random.nextLong() : random.nextLong();
            }
            case FLOAT: {
                switch (choice) {
                    case 1: {
                        return Float.valueOf(Float.MIN_VALUE);
                    }
                    case 2: {
                        return Float.valueOf(-1.4E-45f);
                    }
                    case 3: {
                        return Float.valueOf(Float.MAX_VALUE);
                    }
                    case 4: {
                        return Float.valueOf(-3.4028235E38f);
                    }
                    case 5: {
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                    case 6: {
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    case 7: {
                        return Float.valueOf(0.0f);
                    }
                    case 8: {
                        return Float.valueOf(Float.NaN);
                    }
                }
                return Float.valueOf(RandomUtil.negate(choice) ? -1.0f * random.nextFloat() : random.nextFloat());
            }
            case DOUBLE: {
                switch (choice) {
                    case 1: {
                        return Double.MIN_VALUE;
                    }
                    case 2: {
                        return -4.9E-324;
                    }
                    case 3: {
                        return Double.MAX_VALUE;
                    }
                    case 4: {
                        return -1.7976931348623157E308;
                    }
                    case 5: {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case 6: {
                        return Double.POSITIVE_INFINITY;
                    }
                    case 7: {
                        return 0.0;
                    }
                    case 8: {
                        return Double.NaN;
                    }
                }
                return RandomUtil.negate(choice) ? -1.0 * random.nextDouble() : random.nextDouble();
            }
            case DATE: {
                return random.nextInt() % 138700;
            }
            case TIME: {
                return (random.nextLong() & Integer.MAX_VALUE) % 86400000000L;
            }
            case TIMESTAMP: {
                return random.nextLong() % 1577880000000000L;
            }
            case STRING: {
                return RandomUtil.randomString(random);
            }
            case UUID: {
                byte[] uuidBytes = new byte[16];
                random.nextBytes(uuidBytes);
                return uuidBytes;
            }
            case FIXED: {
                byte[] fixed = new byte[((Types.FixedType)primitive).length()];
                random.nextBytes(fixed);
                return fixed;
            }
            case BINARY: {
                byte[] binary = new byte[random.nextInt(50)];
                random.nextBytes(binary);
                return binary;
            }
            case DECIMAL: {
                Types.DecimalType type = (Types.DecimalType)primitive;
                BigInteger unscaled = RandomUtil.randomUnscaled(type.precision(), random);
                BigDecimal bigDecimal = new BigDecimal(unscaled, type.scale());
                return RandomUtil.negate(choice) ? bigDecimal.negate() : bigDecimal;
            }
        }
        throw new IllegalArgumentException("Cannot generate random value for unknown type: " + primitive);
    }

    public static Object generateDictionaryEncodablePrimitive(Type.PrimitiveType primitive, Random random) {
        int value = random.nextInt(3);
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return true;
            }
            case INTEGER: 
            case DATE: {
                return RandomUtil.negate(value) ? -1 * value : value;
            }
            case FLOAT: {
                return Float.valueOf(RandomUtil.negate(value) ? -1.0f * (float)value : (float)value);
            }
            case DOUBLE: {
                return RandomUtil.negate(value) ? -1.0 * (double)value : (double)value;
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                return (long)value;
            }
            case STRING: {
                return String.valueOf(value);
            }
            case FIXED: {
                byte[] fixed = new byte[((Types.FixedType)primitive).length()];
                Arrays.fill(fixed, (byte)value);
                return fixed;
            }
            case BINARY: {
                byte[] binary = new byte[value + 1];
                Arrays.fill(binary, (byte)value);
                return binary;
            }
            case DECIMAL: {
                Types.DecimalType type = (Types.DecimalType)primitive;
                BigInteger unscaled = new BigInteger(String.valueOf(value + 1));
                BigDecimal bd = new BigDecimal(unscaled, type.scale());
                return RandomUtil.negate(value) ? bd.negate() : bd;
            }
        }
        throw new IllegalArgumentException("Cannot generate random value for unknown type: " + primitive);
    }

    private static String randomString(Random random) {
        int length = random.nextInt(50);
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)CHARS.charAt(random.nextInt(CHARS.length()));
        }
        return new String(buffer);
    }

    private static BigInteger randomUnscaled(int precision, Random random) {
        int length = random.nextInt(precision);
        if (length == 0) {
            return BigInteger.ZERO;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(DIGITS.charAt(random.nextInt(DIGITS.length())));
        }
        return new BigInteger(sb.toString());
    }
}

