/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterTestBase;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveIcebergDeleteWriter
extends HiveIcebergWriterTestBase {
    private static final Set<Integer> DELETED_IDS = Sets.newHashSet((Object[])new Integer[]{29, 61, 89, 100, 122});

    @Test
    public void testDelete() throws IOException {
        HiveIcebergWriter testWriter = this.deleteWriter();
        List<GenericRecord> deleteRecords = TestHiveIcebergDeleteWriter.deleteRecords(this.table, DELETED_IDS);
        Collections.sort(deleteRecords, Comparator.comparing(a -> a.getField("_partition").toString()));
        CharSequenceSet expectedDataFiles = CharSequenceSet.empty();
        Container container = new Container();
        for (Record record : deleteRecords) {
            container.set((Object)record);
            testWriter.write((Writable)container);
            expectedDataFiles.add((CharSequence)((String)record.getField(MetadataColumns.FILE_PATH.name())));
        }
        testWriter.close(false);
        RowDelta rowDelta = this.table.newRowDelta();
        testWriter.files().deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        Collection collection = testWriter.files().referencedDataFiles();
        rowDelta.commit();
        Assert.assertTrue((String)("Actual :" + collection + " Expected: " + expectedDataFiles), (boolean)collection.containsAll((Collection<?>)expectedDataFiles));
        StructLikeSet expected = this.rowSetWithoutIds(RECORDS, DELETED_IDS);
        StructLikeSet actual = TestHiveIcebergDeleteWriter.actualRowSet(this.table);
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    private static List<GenericRecord> deleteRecords(Table table, Set<Integer> idsToRemove) throws IOException {
        ArrayList deleteRecords = Lists.newArrayListWithExpectedSize((int)idsToRemove.size());
        for (GenericRecord record : TestHiveIcebergDeleteWriter.readRecords(table, TestHiveIcebergDeleteWriter.schemaWithMeta(table))) {
            if (!idsToRemove.contains(record.getField("id"))) continue;
            GenericRecord deleteRecord = GenericRecord.create((Schema)IcebergAcidUtil.createSerdeSchemaForDelete((List)SCHEMA.columns()));
            int specId = (Integer)record.getField(MetadataColumns.SPEC_ID.name());
            deleteRecord.setField(MetadataColumns.SPEC_ID.name(), (Object)specId);
            PartitionKey partitionKey = new PartitionKey((PartitionSpec)table.specs().get(specId), table.schema());
            partitionKey.partition((StructLike)record);
            deleteRecord.setField("_partition", (Object)partitionKey);
            deleteRecord.setField(MetadataColumns.FILE_PATH.name(), record.getField(MetadataColumns.FILE_PATH.name()));
            deleteRecord.setField(MetadataColumns.ROW_POSITION.name(), record.getField(MetadataColumns.ROW_POSITION.name()));
            deleteRecord.setField(IcebergAcidUtil.PARTITION_PROJECTION.name(), (Object)IcebergAcidUtil.getSerializedPartitionKey((StructLike)partitionKey, (PartitionSpec)table.spec()));
            SCHEMA.columns().forEach(field -> deleteRecord.setField(field.name(), record.getField(field.name())));
            deleteRecords.add(deleteRecord);
        }
        return deleteRecords;
    }

    private HiveIcebergWriter deleteWriter() {
        return this.writerBuilder.operation(Context.Operation.DELETE).build();
    }
}

