/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics2;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.writer.WriterBuilder;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class HiveIcebergWriterTestBase {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    public static final List<Record> RECORDS = TestHelper.RecordsBuilder.newInstance(SCHEMA).add(29, "a").add(43, "b").add(61, "c").add(89, "d").add(100, "e").add(121, "f").add(122, "g").build();
    private final HadoopTables tables = new HadoopTables((Configuration)new HiveConf());
    private TestHelper helper;
    protected Table table;
    protected WriterBuilder writerBuilder;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Parameterized.Parameter(value=0)
    public FileFormat fileFormat;
    @Parameterized.Parameter(value=1)
    public boolean partitioned;
    @Parameterized.Parameter(value=2)
    public boolean skipRowData;

    @Parameterized.Parameters(name="fileFormat={0}, partitioned={1}, skipRowData={2}")
    public static Collection<Object[]> parameters() {
        return Lists.newArrayList((Object[])new Object[][]{{FileFormat.PARQUET, true, true}, {FileFormat.ORC, true, true}, {FileFormat.AVRO, true, true}, {FileFormat.PARQUET, false, true}, {FileFormat.PARQUET, true, false}, {FileFormat.ORC, true, false}, {FileFormat.AVRO, true, false}, {FileFormat.PARQUET, false, false}, {FileFormat.AVRO, false, true}, {FileFormat.AVRO, false, false}});
    }

    @Before
    public void init() throws IOException {
        File location = this.temp.newFolder(this.fileFormat.name());
        Assert.assertTrue((boolean)location.delete());
        PartitionSpec spec = !this.partitioned ? PartitionSpec.unpartitioned() : PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 3).build();
        this.helper = new TestHelper((Configuration)new HiveConf(), (Tables)this.tables, location.toString(), SCHEMA, spec, this.fileFormat, Collections.singletonMap("iceberg.delete.skiprowdata", String.valueOf(this.skipRowData)), this.temp);
        this.table = this.helper.createTable();
        this.helper.appendToTable(RECORDS);
        TableOperations ops = ((BaseTable)this.table).operations();
        TableMetadata meta = ops.current();
        ops.commit(meta, meta.upgradeToFormatVersion(2));
        JobID jobId = new JobID("test", 0);
        TaskAttemptID taskAttemptID = new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), TaskType.MAP, 0, 0);
        this.writerBuilder = WriterBuilder.builderFor((Table)this.table).attemptID(taskAttemptID).queryId("Q_ID").tableName("dummy");
    }

    @After
    public void cleanUp() {
        this.tables.dropTable(this.helper.table().location());
    }

    protected StructLikeSet rowSetWithoutIds(List<Record> records, Set<Integer> idToDelete) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        records.stream().filter(row -> !idToDelete.contains(row.getField("id"))).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    protected static List<GenericRecord> readRecords(Table table, Schema schema) throws IOException {
        ArrayList records = Lists.newArrayList();
        try (CloseableIterable<Record> reader = IcebergGenerics2.read(table).project(schema).build();){
            reader.forEach(record -> records.add((GenericRecord)record));
        }
        return records;
    }

    protected static StructLikeSet actualRowSet(Table table) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)table.schema().asStruct());
        HiveIcebergWriterTestBase.readRecords(table, table.schema()).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    protected static Schema schemaWithMeta(Table table) {
        ArrayList cols = Lists.newArrayListWithCapacity((int)(table.schema().columns().size() + 4));
        cols.addAll(table.schema().columns());
        cols.add(MetadataColumns.ROW_POSITION);
        cols.add(MetadataColumns.FILE_PATH);
        cols.add(MetadataColumns.SPEC_ID);
        cols.add(MetadataColumns.metadataColumn((Table)table, (String)"_partition"));
        return new Schema((List)cols);
    }
}

