/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Tables;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.vector.TestHiveIcebergVectorization;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.InputFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestHiveVectorizedReader {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private TestHelper helper;
    private InputFormatConfig.ConfigBuilder builder;
    private final FileFormat fileFormat = FileFormat.PARQUET;

    @Before
    public void before() throws IOException, HiveException {
        File location = this.temp.newFolder(this.fileFormat.name());
        Assert.assertTrue((boolean)location.delete());
        JobConf conf = TestHiveIcebergVectorization.prepareMockJob(SCHEMA, new Path(location.toString()));
        conf.set("type", "location");
        HadoopTables tables = new HadoopTables((Configuration)conf);
        this.helper = new TestHelper((Configuration)conf, (Tables)tables, location.toString(), SCHEMA, null, this.fileFormat, this.temp);
        this.builder = new InputFormatConfig.ConfigBuilder((Configuration)conf).readFrom(location.toString()).useHiveRows();
    }

    @Test
    public void testRecordReaderShouldReuseFooter() throws IOException, InterruptedException {
        this.helper.createUnpartitionedTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        this.helper.appendToTable(null, expectedRecords);
        MapredIcebergInputFormat.CompatibilityTaskAttemptContextImpl context = new MapredIcebergInputFormat.CompatibilityTaskAttemptContextImpl(this.builder.conf(), (TaskAttemptID)new org.apache.hadoop.mapred.TaskAttemptID(), null);
        IcebergInputFormat inputFormat = new IcebergInputFormat();
        List splits = inputFormat.getSplits((JobContext)context);
        try (MockedStatic mockedParquetFileReader = Mockito.mockStatic(ParquetFileReader.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            for (InputSplit split : splits) {
                RecordReader r = inputFormat.createRecordReader(split, (TaskAttemptContext)context);
                try {
                    r.initialize(split, (TaskAttemptContext)context);
                    r.nextKeyValue();
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
            mockedParquetFileReader.verify(() -> ParquetFileReader.readFooter((InputFile)((InputFile)ArgumentMatchers.any(InputFile.class)), (ParquetMetadataConverter.MetadataFilter)((ParquetMetadataConverter.MetadataFilter)ArgumentMatchers.any(ParquetMetadataConverter.MetadataFilter.class))), Mockito.times((int)1));
        }
    }
}

