/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.hive.vector.HiveBatchContext;
import org.apache.iceberg.mr.hive.vector.HiveBatchIterator;
import org.apache.iceberg.mr.hive.vector.HiveRow;
import org.apache.iceberg.mr.hive.vector.HiveValueConverter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergVectorization
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testRowIterator() throws Exception {
        Assume.assumeTrue((String)"Tests a format-independent feature", (this.isVectorized && FileFormat.ORC.equals((Object)this.fileFormat) ? 1 : 0) != 0);
        Schema allSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"binary_col", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)2, (String)"boolean_col", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)3, (String)"date_col", (Type)Types.DateType.get()), Types.NestedField.optional((int)4, (String)"decimal_col", (Type)Types.DecimalType.of((int)6, (int)4)), Types.NestedField.optional((int)5, (String)"double_col", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"fixed_col", (Type)Types.FixedType.ofLength((int)4)), Types.NestedField.optional((int)7, (String)"float_col", (Type)Types.FloatType.get()), Types.NestedField.optional((int)8, (String)"int_col", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)9, (String)"long_col", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"string_col", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"timestamp_col", (Type)Types.TimestampType.withoutZone())});
        List<Record> records = TestHelper.generateRandomRecords(allSchema, 10, 0L);
        Table table = this.testTables.createTable(shell, "temptable", allSchema, this.fileFormat, records);
        Path dataFilePath = new Path(((DataFile)((FileScanTask)Lists.newArrayList(((CombinedScanTask)Lists.newArrayList((Iterator)table.newScan().planTasks().iterator()).get(0)).files().iterator()).get(0)).file()).path().toString());
        JobConf jobConf = TestHiveIcebergVectorization.prepareMockJob(allSchema, dataFilePath);
        VectorizedOrcInputFormat inputFormat = new VectorizedOrcInputFormat();
        RecordReader internalVectorizedRecordReader = inputFormat.getRecordReader((InputSplit)new FileSplit(dataFilePath, 0L, Long.MAX_VALUE, new String[0]), jobConf, (Reporter)new MockReporter());
        HiveBatchIterator hiveBatchIterator = new HiveBatchIterator(internalVectorizedRecordReader, jobConf, null, null, null);
        HiveBatchContext hiveBatchContext = hiveBatchIterator.next();
        CloseableIterator hiveRowIterator = hiveBatchContext.rowIterator();
        Iterator<Record> genericRowIterator = records.iterator();
        while (hiveRowIterator.hasNext() && genericRowIterator.hasNext()) {
            HiveRow hiveRow = (HiveRow)hiveRowIterator.next();
            Record hiveRecord = HiveValueConverter.convert((Schema)allSchema, (HiveRow)hiveRow);
            Record genericRecord = genericRowIterator.next();
            Assert.assertEquals((Object)genericRecord, (Object)hiveRecord);
        }
        Assert.assertEquals((Object)genericRowIterator.hasNext(), (Object)hiveRowIterator.hasNext());
    }

    @Test
    public void testHiveDeleteFilterWithEmptyBatches() {
        HashMap props = Maps.newHashMap();
        props.put("parquet.block.size", "8192");
        props.put("parquet.page.row.count.limit", "20");
        this.testVectorizedReadWithDeleteFilter(props);
    }

    @Test
    public void testHiveDeleteFilter() {
        this.testVectorizedReadWithDeleteFilter(Collections.emptyMap());
    }

    private void testVectorizedReadWithDeleteFilter(Map<String, String> props) {
        Assume.assumeTrue((this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"customer_age", (Type)Types.IntegerType.get())});
        List<Record> records = TestHelper.generateRandomRecords(schema, 106000, 0L);
        for (int i = 0; i < records.size(); ++i) {
            records.get(i).setField("customer_id", (Object)i);
        }
        this.testTables.createTable(shell, "vectordelete", schema, PartitionSpec.unpartitioned(), this.fileFormat, records, 2, props);
        shell.executeStatement("DELETE FROM vectordelete WHERE customer_id % 2 = 1 and customer_id < 6000");
        shell.executeStatement("DELETE FROM vectordelete WHERE 1000 < customer_id and customer_id < 3000");
        Function<Integer, Void> validation = expectedCount -> {
            List<Object[]> result = shell.executeStatement("select * from vectordelete where customer_id < 6000");
            Assert.assertEquals((long)expectedCount.intValue(), (long)result.size());
            for (Object[] row : result) {
                long id = (Long)row[0];
                Assert.assertTrue((String)"Found row with odd customer_id", (id % 2L == 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Found a row with customer_id between 1000 and 3000 (both exclusive)", (id <= 1000L || 3000L <= id ? 1 : 0) != 0);
                Assert.assertTrue((String)"Found a row with customer_id >= 6000, i.e. where clause is not in effect.", (id < 6000L ? 1 : 0) != 0);
            }
            return null;
        };
        validation.apply(2001);
        shell.executeStatement("DELETE FROM vectordelete WHERE customer_id >= 5000");
        validation.apply(1501);
    }

    @Test
    public void testHiveDeleteFilterWithFilteredParquetBlock() {
        Assume.assumeTrue((this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.fileFormat == FileFormat.PARQUET ? 1 : 0) != 0);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"customer_age", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"date_col", (Type)Types.DateType.get())});
        List<Record> records = TestHelper.generateRandomRecords(schema, 10600, 0L);
        for (int i = 0; i < records.size(); ++i) {
            records.get(i).setField("customer_id", (Object)i);
            if (i % 3 == 0) {
                records.get(i).setField("date_col", (Object)Date.valueOf((String)"2022-04-28"));
                continue;
            }
            if (i % 3 == 1) {
                records.get(i).setField("date_col", (Object)Date.valueOf((String)"2022-04-29"));
                continue;
            }
            records.get(i).setField("date_col", (Object)Date.valueOf((String)"2022-04-30"));
        }
        HashMap props = Maps.newHashMap();
        props.put("parquet.block.size", "8192");
        this.testTables.createTable(shell, "vectordelete", schema, PartitionSpec.unpartitioned(), this.fileFormat, records, 2, props);
        List<Object[]> results = shell.executeStatement("select * from vectordelete where date_col=date'2022-04-29'");
        Assert.assertNotEquals((long)0L, (long)results.size());
        List<Object[]> postUpdateResult = shell.executeStatement("select * from vectordelete where date_col=date'2022-04-29' OR date_col=date'2022-04-30'");
        Assert.assertNotEquals((long)0L, (long)postUpdateResult.size());
        shell.executeStatement("update vectordelete set date_col=date'2022-04-30' where date_col=date'2022-04-29'");
        results = shell.executeStatement("select * from vectordelete where date_col=date'2022-04-29'");
        Assert.assertEquals((long)0L, (long)results.size());
        results = shell.executeStatement("select * from vectordelete where date_col=date'2022-04-30'");
        Assert.assertEquals((long)postUpdateResult.size(), (long)results.size());
    }

    static JobConf prepareMockJob(Schema schema, Path dataFilePath) throws HiveException {
        StructObjectInspector oi = (StructObjectInspector)IcebergObjectInspector.create((Schema)schema);
        String hiveColumnNames = String.join((CharSequence)",", oi.getAllStructFieldRefs().stream().map(sf -> sf.getFieldName()).collect(Collectors.toList()));
        String hiveTypeInfoNames = String.join((CharSequence)",", oi.getAllStructFieldRefs().stream().map(sf -> sf.getFieldObjectInspector().getTypeName()).collect(Collectors.toList()));
        hiveTypeInfoNames = hiveTypeInfoNames.replaceAll("decimal\\(\\d+,\\d+\\)", "decimal");
        Configuration conf = new Configuration();
        conf.set("columns", hiveColumnNames);
        conf.set("columns.types", hiveTypeInfoNames);
        conf.setBoolean("hive.io.file.read.all.columns", true);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)true);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        JobConf vectorJob = new JobConf(conf);
        VectorizedOrcInputFormat.setInputPaths((JobConf)vectorJob, (Path[])new Path[]{dataFilePath});
        MapWork mapWork = new MapWork();
        VectorizedRowBatchCtx rbCtx = new VectorizedRowBatchCtx();
        rbCtx.init(oi, new String[0]);
        mapWork.setVectorMode(true);
        mapWork.setVectorizedRowBatchCtx(rbCtx);
        mapWork.deriveLlap(conf, false);
        Utilities.setMapWork((Configuration)vectorJob, (MapWork)mapWork);
        return vectorJob;
    }

    private static class MockReporter
    implements Reporter {
        private MockReporter() {
        }

        public void setStatus(String s) {
        }

        public Counters.Counter getCounter(Enum<?> anEnum) {
            return null;
        }

        public Counters.Counter getCounter(String s, String s1) {
            return null;
        }

        public void incrCounter(Enum<?> anEnum, long l) {
        }

        public void incrCounter(String s, String s1, long l) {
        }

        public InputSplit getInputSplit() throws UnsupportedOperationException {
            return null;
        }

        public float getProgress() {
            return 0.0f;
        }

        public void progress() {
        }
    }
}

