/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.util.UUID;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergUUIDObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergUUIDObjectInspector {
    @Test
    public void testIcebergUUIDObjectInspector() {
        IcebergUUIDObjectInspector oi = IcebergUUIDObjectInspector.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(String.class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(Text.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        Assert.assertNull((Object)oi.convert(null));
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString();
        Text text = new Text(uuidStr);
        Assert.assertEquals((Object)uuidStr, (Object)oi.getPrimitiveJavaObject((Object)text));
        Assert.assertEquals((Object)text, (Object)oi.getPrimitiveWritableObject((Object)uuidStr));
        Assert.assertEquals((Object)uuid, (Object)oi.convert((Object)uuidStr));
        Text copy = (Text)oi.copyObject((Object)text);
        Assert.assertEquals((Object)text, (Object)copy);
        Assert.assertNotSame((Object)text, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
    }
}

