/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampWithZoneObjectInspectorHive3;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergTimestampWithZoneObjectInspectorHive3 {
    @Test
    public void testIcebergTimestampLocalTZObjectInspector() {
        IcebergTimestampWithZoneObjectInspectorHive3 oi = IcebergTimestampWithZoneObjectInspectorHive3.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.timestampLocalTZTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.timestampLocalTZTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(TimestampTZ.class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(TimestampLocalTZWritable.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        Assert.assertNull((Object)oi.convert(null));
        LocalDateTime dateTimeAtUTC = LocalDateTime.of(2020, 12, 10, 15, 55, 20, 30000);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(dateTimeAtUTC.plusHours(4L), ZoneOffset.ofHours(4));
        ZonedDateTime zdt = offsetDateTime.atZoneSameInstant(TypeInfoFactory.timestampLocalTZTypeInfo.getTimeZone());
        TimestampTZ ts = new TimestampTZ(dateTimeAtUTC.atZone(ZoneId.of("UTC")));
        Assert.assertEquals((Object)ts, (Object)oi.getPrimitiveJavaObject((Object)offsetDateTime));
        Assert.assertEquals((Object)zdt, (Object)oi.getPrimitiveJavaObject((Object)offsetDateTime).getZonedDateTime());
        Assert.assertEquals((Object)new TimestampLocalTZWritable(ts), (Object)oi.getPrimitiveWritableObject((Object)offsetDateTime));
        offsetDateTime = OffsetDateTime.of(dateTimeAtUTC.plusHours(11L), ZoneOffset.ofHours(11));
        Assert.assertEquals((Object)ts, (Object)oi.getPrimitiveJavaObject((Object)offsetDateTime));
        Assert.assertEquals((Object)new TimestampLocalTZWritable(ts), (Object)oi.getPrimitiveWritableObject((Object)offsetDateTime));
        TimestampTZ copy = (TimestampTZ)oi.copyObject((Object)ts);
        Assert.assertEquals((Object)ts, (Object)copy);
        Assert.assertNotSame((Object)ts, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
        Assert.assertEquals((Object)OffsetDateTime.of(dateTimeAtUTC, ZoneOffset.UTC), (Object)oi.convert((Object)ts));
    }
}

