/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampObjectInspectorHive3;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergTimestampObjectInspectorHive3 {
    @Test
    public void testIcebergTimestampObjectInspector() {
        IcebergTimestampObjectInspectorHive3 oi = IcebergTimestampObjectInspectorHive3.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(Timestamp.class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(TimestampWritableV2.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        Assert.assertNull((Object)oi.convert(null));
        long epochMilli = 1601471970000L;
        LocalDateTime local = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.of("UTC")).plusNanos(34000L);
        Timestamp ts = Timestamp.ofEpochMilli((long)epochMilli);
        ts.setNanos(34000);
        Assert.assertEquals((Object)ts, (Object)oi.getPrimitiveJavaObject((Object)local));
        Assert.assertEquals((Object)new TimestampWritableV2(ts), (Object)oi.getPrimitiveWritableObject((Object)local));
        Timestamp copy = (Timestamp)oi.copyObject((Object)ts);
        Assert.assertEquals((Object)ts, (Object)copy);
        Assert.assertNotSame((Object)ts, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
        Assert.assertEquals((Object)local, (Object)oi.convert((Object)ts));
    }
}

