/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergRecordObjectInspector {
    @Test
    public void testIcebergRecordObjectInspector() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"integer_field", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"struct_field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"string_field", (Type)Types.StringType.get())}))});
        Record record = RandomGenericData.generate(schema, 1, 0L).get(0);
        Record innerRecord = (Record)record.get(1, Record.class);
        StructObjectInspector soi = (StructObjectInspector)IcebergObjectInspector.create((Schema)schema);
        Assert.assertEquals((Object)ImmutableList.of((Object)record.get(0), (Object)record.get(1)), (Object)soi.getStructFieldsDataAsList((Object)record));
        StructField integerField = soi.getStructFieldRef("integer_field");
        Assert.assertEquals((Object)record.get(0), (Object)soi.getStructFieldData((Object)record, integerField));
        StructField structField = soi.getStructFieldRef("struct_field");
        Object innerData = soi.getStructFieldData((Object)record, structField);
        Assert.assertEquals((Object)innerRecord, (Object)innerData);
        StructObjectInspector innerSoi = (StructObjectInspector)structField.getFieldObjectInspector();
        StructField stringField = innerSoi.getStructFieldRef("string_field");
        Assert.assertEquals((Object)ImmutableList.of((Object)innerRecord.get(0)), (Object)innerSoi.getStructFieldsDataAsList((Object)innerRecord));
        Assert.assertEquals((Object)innerRecord.get(0), (Object)innerSoi.getStructFieldData(innerData, stringField));
    }

    @Test
    public void testIcebergRecordObjectInspectorWithRowNull() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"integer_field", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"struct_field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"string_field", (Type)Types.StringType.get())}))});
        StructObjectInspector soi = (StructObjectInspector)IcebergObjectInspector.create((Schema)schema);
        Assert.assertNull((Object)soi.getStructFieldsDataAsList(null));
        StructField integerField = soi.getStructFieldRef("integer_field");
        Assert.assertNull((Object)soi.getStructFieldData(null, integerField));
    }
}

