/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergBinaryObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDecimalObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergFixedObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergRecordObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimeObjectInspector;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampObjectInspectorHive3;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergTimestampWithZoneObjectInspectorHive3;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergUUIDObjectInspector;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergObjectInspector {
    private final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"binary_field", (Type)Types.BinaryType.get(), (String)"binary comment"), Types.NestedField.required((int)2, (String)"boolean_field", (Type)Types.BooleanType.get(), (String)"boolean comment"), Types.NestedField.required((int)3, (String)"date_field", (Type)Types.DateType.get(), (String)"date comment"), Types.NestedField.required((int)4, (String)"decimal_field", (Type)Types.DecimalType.of((int)38, (int)18), (String)"decimal comment"), Types.NestedField.required((int)5, (String)"double_field", (Type)Types.DoubleType.get(), (String)"double comment"), Types.NestedField.required((int)6, (String)"fixed_field", (Type)Types.FixedType.ofLength((int)3), (String)"fixed comment"), Types.NestedField.required((int)7, (String)"float_field", (Type)Types.FloatType.get(), (String)"float comment"), Types.NestedField.required((int)8, (String)"integer_field", (Type)Types.IntegerType.get(), (String)"integer comment"), Types.NestedField.required((int)9, (String)"long_field", (Type)Types.LongType.get(), (String)"long comment"), Types.NestedField.required((int)10, (String)"string_field", (Type)Types.StringType.get(), (String)"string comment"), Types.NestedField.required((int)11, (String)"timestamp_field", (Type)Types.TimestampType.withoutZone(), (String)"timestamp comment"), Types.NestedField.required((int)12, (String)"timestamptz_field", (Type)Types.TimestampType.withZone(), (String)"timestamptz comment"), Types.NestedField.required((int)13, (String)"uuid_field", (Type)Types.UUIDType.get(), (String)"uuid comment"), Types.NestedField.required((int)14, (String)"list_field", (Type)Types.ListType.ofRequired((int)15, (Type)Types.StringType.get()), (String)"list comment"), Types.NestedField.required((int)16, (String)"map_field", (Type)Types.MapType.ofRequired((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()), (String)"map comment"), Types.NestedField.required((int)19, (String)"struct_field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"nested_field", (Type)Types.StringType.get(), (String)"nested field comment")}), (String)"struct comment"), Types.NestedField.required((int)21, (String)"time_field", (Type)Types.TimeType.get(), (String)"time comment")});

    @Test
    public void testIcebergObjectInspector() {
        ObjectInspector oi = IcebergObjectInspector.create((Schema)this.schema);
        Assert.assertNotNull((Object)oi);
        Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)oi.getCategory());
        StructObjectInspector soi = (StructObjectInspector)oi;
        StructField binaryField = soi.getStructFieldRef("binary_field");
        Assert.assertEquals((long)1L, (long)binaryField.getFieldID());
        Assert.assertEquals((Object)"binary_field", (Object)binaryField.getFieldName());
        Assert.assertEquals((Object)"binary comment", (Object)binaryField.getFieldComment());
        Assert.assertEquals((Object)IcebergBinaryObjectInspector.get(), (Object)binaryField.getFieldObjectInspector());
        StructField booleanField = soi.getStructFieldRef("boolean_field");
        Assert.assertEquals((long)2L, (long)booleanField.getFieldID());
        Assert.assertEquals((Object)"boolean_field", (Object)booleanField.getFieldName());
        Assert.assertEquals((Object)"boolean comment", (Object)booleanField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(Boolean.TYPE), (Object)booleanField.getFieldObjectInspector());
        StructField dateField = soi.getStructFieldRef("date_field");
        Assert.assertEquals((long)3L, (long)dateField.getFieldID());
        Assert.assertEquals((Object)"date_field", (Object)dateField.getFieldName());
        Assert.assertEquals((Object)"date comment", (Object)dateField.getFieldComment());
        if (HiveVersion.min((HiveVersion)HiveVersion.HIVE_3)) {
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDateObjectInspectorHive3", (Object)dateField.getFieldObjectInspector().getClass().getName());
        } else {
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDateObjectInspector", (Object)dateField.getFieldObjectInspector().getClass().getName());
        }
        StructField decimalField = soi.getStructFieldRef("decimal_field");
        Assert.assertEquals((long)4L, (long)decimalField.getFieldID());
        Assert.assertEquals((Object)"decimal_field", (Object)decimalField.getFieldName());
        Assert.assertEquals((Object)"decimal comment", (Object)decimalField.getFieldComment());
        Assert.assertEquals((Object)IcebergDecimalObjectInspector.get((int)38, (int)18), (Object)decimalField.getFieldObjectInspector());
        StructField doubleField = soi.getStructFieldRef("double_field");
        Assert.assertEquals((long)5L, (long)doubleField.getFieldID());
        Assert.assertEquals((Object)"double_field", (Object)doubleField.getFieldName());
        Assert.assertEquals((Object)"double comment", (Object)doubleField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(Double.TYPE), (Object)doubleField.getFieldObjectInspector());
        StructField fixedField = soi.getStructFieldRef("fixed_field");
        Assert.assertEquals((long)6L, (long)fixedField.getFieldID());
        Assert.assertEquals((Object)"fixed_field", (Object)fixedField.getFieldName());
        Assert.assertEquals((Object)"fixed comment", (Object)fixedField.getFieldComment());
        Assert.assertEquals((Object)IcebergFixedObjectInspector.get(), (Object)fixedField.getFieldObjectInspector());
        StructField floatField = soi.getStructFieldRef("float_field");
        Assert.assertEquals((long)7L, (long)floatField.getFieldID());
        Assert.assertEquals((Object)"float_field", (Object)floatField.getFieldName());
        Assert.assertEquals((Object)"float comment", (Object)floatField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(Float.TYPE), (Object)floatField.getFieldObjectInspector());
        StructField integerField = soi.getStructFieldRef("integer_field");
        Assert.assertEquals((long)8L, (long)integerField.getFieldID());
        Assert.assertEquals((Object)"integer_field", (Object)integerField.getFieldName());
        Assert.assertEquals((Object)"integer comment", (Object)integerField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(Integer.TYPE), (Object)integerField.getFieldObjectInspector());
        StructField longField = soi.getStructFieldRef("long_field");
        Assert.assertEquals((long)9L, (long)longField.getFieldID());
        Assert.assertEquals((Object)"long_field", (Object)longField.getFieldName());
        Assert.assertEquals((Object)"long comment", (Object)longField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(Long.TYPE), (Object)longField.getFieldObjectInspector());
        StructField stringField = soi.getStructFieldRef("string_field");
        Assert.assertEquals((long)10L, (long)stringField.getFieldID());
        Assert.assertEquals((Object)"string_field", (Object)stringField.getFieldName());
        Assert.assertEquals((Object)"string comment", (Object)stringField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(String.class), (Object)stringField.getFieldObjectInspector());
        StructField timestampField = soi.getStructFieldRef("timestamp_field");
        Assert.assertEquals((long)11L, (long)timestampField.getFieldID());
        Assert.assertEquals((Object)"timestamp_field", (Object)timestampField.getFieldName());
        Assert.assertEquals((Object)"timestamp comment", (Object)timestampField.getFieldComment());
        Assert.assertEquals((Object)IcebergTimestampObjectInspectorHive3.get(), (Object)timestampField.getFieldObjectInspector());
        StructField timestampTzField = soi.getStructFieldRef("timestamptz_field");
        Assert.assertEquals((long)12L, (long)timestampTzField.getFieldID());
        Assert.assertEquals((Object)"timestamptz_field", (Object)timestampTzField.getFieldName());
        Assert.assertEquals((Object)"timestamptz comment", (Object)timestampTzField.getFieldComment());
        Assert.assertEquals((Object)IcebergTimestampWithZoneObjectInspectorHive3.get(), (Object)timestampTzField.getFieldObjectInspector());
        StructField uuidField = soi.getStructFieldRef("uuid_field");
        Assert.assertEquals((long)13L, (long)uuidField.getFieldID());
        Assert.assertEquals((Object)"uuid_field", (Object)uuidField.getFieldName());
        Assert.assertEquals((Object)"uuid comment", (Object)uuidField.getFieldComment());
        Assert.assertEquals((Object)IcebergUUIDObjectInspector.get(), (Object)uuidField.getFieldObjectInspector());
        StructField listField = soi.getStructFieldRef("list_field");
        Assert.assertEquals((long)14L, (long)listField.getFieldID());
        Assert.assertEquals((Object)"list_field", (Object)listField.getFieldName());
        Assert.assertEquals((Object)"list comment", (Object)listField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getListObjectInspector(String.class), (Object)listField.getFieldObjectInspector());
        StructField mapField = soi.getStructFieldRef("map_field");
        Assert.assertEquals((long)16L, (long)mapField.getFieldID());
        Assert.assertEquals((Object)"map_field", (Object)mapField.getFieldName());
        Assert.assertEquals((Object)"map comment", (Object)mapField.getFieldComment());
        Assert.assertEquals((Object)TestIcebergObjectInspector.getMapObjectInspector(String.class, Integer.TYPE), (Object)mapField.getFieldObjectInspector());
        StructField structField = soi.getStructFieldRef("struct_field");
        Assert.assertEquals((long)19L, (long)structField.getFieldID());
        Assert.assertEquals((Object)"struct_field", (Object)structField.getFieldName());
        Assert.assertEquals((Object)"struct comment", (Object)structField.getFieldComment());
        IcebergRecordObjectInspector expectedObjectInspector = new IcebergRecordObjectInspector((Types.StructType)this.schema.findType(19), (List)ImmutableList.of((Object)TestIcebergObjectInspector.getPrimitiveObjectInspector(String.class)));
        Assert.assertEquals((Object)expectedObjectInspector, (Object)structField.getFieldObjectInspector());
        StructField timeField = soi.getStructFieldRef("time_field");
        Assert.assertEquals((long)21L, (long)timeField.getFieldID());
        Assert.assertEquals((Object)"time_field", (Object)timeField.getFieldName());
        Assert.assertEquals((Object)"time comment", (Object)timeField.getFieldComment());
        Assert.assertEquals((Object)IcebergTimeObjectInspector.get(), (Object)timeField.getFieldObjectInspector());
    }

    private static ObjectInspector getPrimitiveObjectInspector(Class<?> clazz) {
        PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(clazz);
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)typeInfo);
    }

    private static ObjectInspector getListObjectInspector(Class<?> clazz) {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)TestIcebergObjectInspector.getPrimitiveObjectInspector(clazz));
    }

    private static ObjectInspector getMapObjectInspector(Class<?> keyClazz, Class<?> valueClazz) {
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)TestIcebergObjectInspector.getPrimitiveObjectInspector(keyClazz), (ObjectInspector)TestIcebergObjectInspector.getPrimitiveObjectInspector(valueClazz));
    }
}

