/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergFixedObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergFixedObjectInspector {
    @Test
    public void testIcebergFixedObjectInspector() {
        IcebergFixedObjectInspector oi = IcebergFixedObjectInspector.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.binaryTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.binaryTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(byte[].class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(BytesWritable.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        Assert.assertNull((Object)oi.convert(null));
        byte[] bytes = new byte[]{0, 1};
        BytesWritable bytesWritable = new BytesWritable(bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])oi.getPrimitiveJavaObject((Object)bytes));
        Assert.assertEquals((Object)bytesWritable, (Object)oi.getPrimitiveWritableObject((Object)bytes));
        Assert.assertEquals((Object)bytes, (Object)oi.convert((Object)bytes));
        byte[] copy = (byte[])oi.copyObject((Object)bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])copy);
        Assert.assertNotSame((Object)bytes, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
    }
}

