/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDecimalObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergDecimalObjectInspector {
    @Test
    public void testCache() {
        IcebergDecimalObjectInspector oi = IcebergDecimalObjectInspector.get((int)38, (int)18);
        Assert.assertSame((Object)oi, (Object)IcebergDecimalObjectInspector.get((int)38, (int)18));
        Assert.assertNotSame((Object)oi, (Object)IcebergDecimalObjectInspector.get((int)28, (int)18));
        Assert.assertNotSame((Object)oi, (Object)IcebergDecimalObjectInspector.get((int)38, (int)28));
    }

    @Test
    public void testIcebergDecimalObjectInspector() {
        IcebergDecimalObjectInspector oi = IcebergDecimalObjectInspector.get((int)38, (int)18);
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)new DecimalTypeInfo(38, 18), (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.decimalTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals((long)38L, (long)oi.precision());
        Assert.assertEquals((long)18L, (long)oi.scale());
        Assert.assertEquals(HiveDecimal.class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(HiveDecimalWritable.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        HiveDecimal one = HiveDecimal.create((BigDecimal)BigDecimal.ONE);
        Assert.assertEquals((Object)one, (Object)oi.getPrimitiveJavaObject((Object)BigDecimal.ONE));
        Assert.assertEquals((Object)new HiveDecimalWritable(one), (Object)oi.getPrimitiveWritableObject((Object)BigDecimal.ONE));
        HiveDecimal copy = (HiveDecimal)oi.copyObject((Object)one);
        Assert.assertEquals((Object)one, (Object)copy);
        Assert.assertNotSame((Object)one, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
    }
}

