/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.LocalDate;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergDateObjectInspectorHive3;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergDateObjectInspectorHive3 {
    @Test
    public void testIcebergDateObjectInspector() {
        IcebergDateObjectInspectorHive3 oi = IcebergDateObjectInspectorHive3.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.DATE, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(Date.class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(DateWritableV2.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        int epochDays = 5005;
        LocalDate local = LocalDate.ofEpochDay(epochDays);
        Date date = Date.ofEpochDay((int)epochDays);
        Assert.assertEquals((Object)date, (Object)oi.getPrimitiveJavaObject((Object)local));
        Assert.assertEquals((Object)new DateWritableV2(date), (Object)oi.getPrimitiveWritableObject((Object)local));
        Date copy = (Date)oi.copyObject((Object)date);
        Assert.assertEquals((Object)date, (Object)copy);
        Assert.assertNotSame((Object)date, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
    }
}

