/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergBinaryObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergBinaryObjectInspector {
    @Test
    public void testIcebergByteBufferObjectInspector() {
        IcebergBinaryObjectInspector oi = IcebergBinaryObjectInspector.get();
        Assert.assertEquals((Object)ObjectInspector.Category.PRIMITIVE, (Object)oi.getCategory());
        Assert.assertEquals((Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY, (Object)oi.getPrimitiveCategory());
        Assert.assertEquals((Object)TypeInfoFactory.binaryTypeInfo, (Object)oi.getTypeInfo());
        Assert.assertEquals((Object)TypeInfoFactory.binaryTypeInfo.getTypeName(), (Object)oi.getTypeName());
        Assert.assertEquals(byte[].class, (Object)oi.getJavaPrimitiveClass());
        Assert.assertEquals(BytesWritable.class, (Object)oi.getPrimitiveWritableClass());
        Assert.assertNull((Object)oi.copyObject(null));
        Assert.assertNull((Object)oi.getPrimitiveJavaObject(null));
        Assert.assertNull((Object)oi.getPrimitiveWritableObject(null));
        byte[] bytes = new byte[]{0, 1, 2, 3};
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])oi.getPrimitiveJavaObject((Object)buffer));
        Assert.assertEquals((Object)new BytesWritable(bytes), (Object)oi.getPrimitiveWritableObject((Object)buffer));
        ByteBuffer slice = ByteBuffer.wrap(bytes, 1, 2).slice();
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])oi.getPrimitiveJavaObject((Object)slice));
        Assert.assertEquals((Object)new BytesWritable(new byte[]{1, 2}), (Object)oi.getPrimitiveWritableObject((Object)slice));
        slice.position(1);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])oi.getPrimitiveJavaObject((Object)slice));
        Assert.assertEquals((Object)new BytesWritable(new byte[]{2}), (Object)oi.getPrimitiveWritableObject((Object)slice));
        byte[] copy = (byte[])oi.copyObject((Object)bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])copy);
        Assert.assertNotSame((Object)bytes, (Object)copy);
        Assert.assertFalse((boolean)oi.preferWritable());
    }
}

