/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.metastore.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.utils.TableFetcher;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.metastore.task.IcebergHouseKeeperService;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIcebergHouseKeeperService {
    private static final Logger LOG = LoggerFactory.getLogger(TestIcebergHouseKeeperService.class);
    private static final HiveConf conf = new HiveConf(TestIcebergHouseKeeperService.class);
    private static Hive db;

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf.set("hive.security.authorization.enabled", "false");
        conf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdConfOnlyAuthorizerFactory");
        conf.set("iceberg.engine.hive.lock-enabled", "false");
        db = Hive.get((HiveConf)conf);
    }

    @AfterClass
    public static void afterClass() {
        db.close(true);
    }

    @Test
    public void testIcebergTableFetched() throws Exception {
        this.createIcebergTable("iceberg_table");
        IcebergHouseKeeperService service = new IcebergHouseKeeperService();
        TableFetcher tableFetcher = service.getTableFetcher(db.getMSC(), null, "default", "*");
        List tables = tableFetcher.getTables();
        Assert.assertEquals((Object)new TableName("hive", "default", "iceberg_table"), tables.get(0));
    }

    @Test
    public void testExpireSnapshotsByServiceRun() throws Exception {
        String tableName = "iceberg_table_snapshot_expiry_e2e_test";
        this.createIcebergTable(tableName);
        IcebergHouseKeeperService service = this.getServiceForTable("default", tableName);
        GetTableRequest request = new GetTableRequest("default", tableName);
        Table icebergTable = IcebergTableUtil.getTable((Configuration)conf, (org.apache.hadoop.hive.metastore.api.Table)db.getMSC().getTable(request));
        String metadataDirectory = icebergTable.location().replaceAll("^[a-zA-Z]+:", "") + "/metadata";
        DataFile datafile = DataFiles.builder((PartitionSpec)icebergTable.spec()).withRecordCount(3L).withPath("/tmp/file.parquet").withFileSizeInBytes(10L).build();
        icebergTable.newAppend().appendFile(datafile).commit();
        this.assertSnapshotFiles(metadataDirectory, 1);
        icebergTable.newAppend().appendFile(datafile).commit();
        this.assertSnapshotFiles(metadataDirectory, 2);
        Thread.sleep(1000L);
        service.run();
        this.assertSnapshotFiles(metadataDirectory, 1);
        db.dropTable("default", "iceberg_table_snapshot_expiry_e2e_test");
    }

    private void createIcebergTable(String name) throws Exception {
        org.apache.hadoop.hive.ql.metadata.Table table = new org.apache.hadoop.hive.ql.metadata.Table("default", name);
        ArrayList columns = Lists.newArrayList();
        columns.add(new FieldSchema("col", "string", "First column"));
        table.setFields((List)columns);
        table.setProperty("EXTERNAL", "TRUE");
        table.setTableType(TableType.EXTERNAL_TABLE);
        table.setProperty("table_type", "ICEBERG");
        table.setProperty("history.expire.max-snapshot-age-ms", "500");
        db.createTable(table);
    }

    private IcebergHouseKeeperService getServiceForTable(String dbName, String tableName) {
        IcebergHouseKeeperService service = new IcebergHouseKeeperService();
        HiveConf serviceConf = new HiveConf(conf);
        serviceConf.set("hive.metastore.iceberg.table.expiry.database.pattern", dbName);
        serviceConf.set("hive.metastore.iceberg.table.expiry.table.pattern", tableName);
        service.setConf((Configuration)serviceConf);
        return service;
    }

    private void assertSnapshotFiles(String metadataDirectory, int numberForSnapshotFiles) {
        File[] matchingFiles = new File(metadataDirectory).listFiles((dir, name) -> name.startsWith("snap-"));
        List files = Optional.ofNullable(matchingFiles).map(Arrays::asList).orElse(Collections.emptyList());
        LOG.debug("Snapshot files found in directory({}): {}", (Object)metadataDirectory, files);
        Assert.assertEquals((String)String.format("Unexpected no. of snapshot files in metadata directory: %s", metadataDirectory), (long)numberForSnapshotFiles, (long)files.size());
    }
}

