/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.concurrent.Phaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtilPhaser {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtilPhaser.class);
    private static TestUtilPhaser instance;
    private final Phaser phaser = new Phaser();

    private TestUtilPhaser() {
    }

    public static synchronized TestUtilPhaser getInstance() {
        if (instance == null) {
            LOG.info("UnitTestConcurrency: Instantiating the Phaser barrier");
            instance = new TestUtilPhaser();
        }
        return instance;
    }

    public Phaser getPhaser() {
        return this.phaser;
    }

    public static synchronized boolean isInstantiated() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance.getPhaser().forceTermination();
            LOG.info("UnitTestConcurrency: Destroying the Phaser barrier");
            instance = null;
        }
    }
}

