/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Tables;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.TestCatalogs;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.ObjectArrays;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public abstract class TestTables {
    public static final TestTableType[] ALL_TABLE_TYPES = new TestTableType[]{TestTableType.HADOOP_TABLE, TestTableType.HADOOP_CATALOG, TestTableType.CUSTOM_CATALOG, TestTableType.HIVE_CATALOG};
    private final Tables tables;
    protected final TemporaryFolder temp;
    protected final String catalog;

    protected TestTables(Tables tables, TemporaryFolder temp, String catalogName) {
        this.tables = tables;
        this.temp = temp;
        this.catalog = catalogName;
    }

    protected TestTables(Catalog catalog, TemporaryFolder temp, String catalogName) {
        this(new CatalogToTables(catalog), temp, catalogName);
    }

    public Map<String, String> properties() {
        return Collections.emptyMap();
    }

    public String identifier(String tableIdentifier) {
        return tableIdentifier;
    }

    public Tables tables() {
        return this.tables;
    }

    public String catalogName() {
        return this.catalog;
    }

    public abstract String locationForCreateTableSQL(TableIdentifier var1);

    public String propertiesForCreateTableSQL(Map<String, String> tableProperties) {
        HashMap properties = Maps.newHashMap(tableProperties);
        properties.putIfAbsent("iceberg.catalog", this.catalog);
        String props = properties.entrySet().stream().map(entry -> String.format("'%s'='%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
        return " TBLPROPERTIES (" + props + ")";
    }

    public String createHiveTableSQL(TableIdentifier identifier, Map<String, String> tableProps) {
        Preconditions.checkArgument((!identifier.namespace().isEmpty() ? 1 : 0) != 0, (Object)"Namespace should not be empty");
        Preconditions.checkArgument((identifier.namespace().levels().length == 1 ? 1 : 0) != 0, (Object)"Namespace should be single level");
        return String.format("CREATE EXTERNAL TABLE %s.%s STORED BY '%s' %s %s", identifier.namespace(), identifier.name(), HiveIcebergStorageHandler.class.getName(), this.locationForCreateTableSQL(identifier), this.propertiesForCreateTableSQL(tableProps));
    }

    public Table loadTable(TableIdentifier identifier) {
        return this.tables.load(identifier.toString());
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, List<Record> records) throws IOException {
        return this.createTable(shell, tableName, schema, fileFormat, records, 1);
    }

    public Table createTableWithVersions(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, List<Record> records, int versions) throws IOException, InterruptedException {
        Table table = this.createTable(shell, tableName, schema, fileFormat, records);
        for (int i = 0; i < versions - 1; ++i) {
            Thread.sleep(100L);
            shell.executeStatement("INSERT INTO " + tableName + " values(" + (i + records.size()) + ",'Alice','Green_" + i + "')");
        }
        table.refresh();
        return table;
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, List<Record> records, Map<String, String> tblProperties) throws IOException {
        return this.createTable(shell, tableName, schema, fileFormat, records, 1, tblProperties);
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, List<Record> records, int formatVersion) throws IOException {
        return this.createTable(shell, tableName, schema, fileFormat, records, formatVersion, Collections.emptyMap());
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, List<Record> records, int formatVersion, Map<String, String> tblProperties) throws IOException {
        return this.createTable(shell, tableName, schema, SortOrder.unsorted(), PartitionSpec.unpartitioned(), fileFormat, records, formatVersion, tblProperties);
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, SortOrder order, PartitionSpec partSpec, FileFormat fileFormat, List<Record> records, int formatVersion, Map<String, String> tblProperties) throws IOException {
        ImmutableMap tblProps = ImmutableMap.builder().putAll(tblProperties).put((Object)"format-version", (Object)Integer.toString(formatVersion)).build();
        Table table = this.createIcebergTable(shell.getHiveConf(), tableName, schema, order, partSpec, fileFormat, (Map<String, String>)tblProps, records);
        String createHiveSQL = this.createHiveTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName}), (Map<String, String>)tblProps);
        if (createHiveSQL != null) {
            shell.executeStatement(createHiveSQL);
        }
        return table;
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, PartitionSpec spec, FileFormat fileFormat, List<Record> records) {
        return this.createTable(shell, tableName, schema, spec, fileFormat, records, 1);
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, PartitionSpec spec, FileFormat fileFormat, List<Record> records, Integer formatVersion) {
        return this.createTable(shell, tableName, schema, spec, fileFormat, records, formatVersion, Collections.emptyMap());
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, PartitionSpec spec, FileFormat fileFormat, List<Record> records, Integer formatVersion, Map<String, String> tblProperties) {
        return this.createTable(shell, tableName, schema, spec, fileFormat, records, formatVersion, tblProperties, "ICEBERG");
    }

    public Table createTable(TestHiveShell shell, String tableName, Schema schema, PartitionSpec spec, FileFormat fileFormat, List<Record> records, Integer formatVersion, Map<String, String> tblProperties, String storageHandler) {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", tableName});
        String tblProps = this.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.builder().putAll(tblProperties).put((Object)"write.format.default", (Object)fileFormat.toString()).put((Object)"iceberg.mr.table.schema", (Object)SchemaParser.toJson((Schema)schema)).put((Object)"iceberg.mr.table.partition.spec", (Object)PartitionSpecParser.toJson((PartitionSpec)spec)).put((Object)"format-version", (Object)Integer.toString(formatVersion)).build());
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " STORED BY " + storageHandler + " " + this.locationForCreateTableSQL(identifier) + tblProps);
        if (records != null && !records.isEmpty()) {
            String query = this.getInsertQuery(records, identifier, false);
            shell.executeStatement(query);
        }
        return this.loadTable(identifier);
    }

    public String getInsertQuery(List<Record> records, TableIdentifier identifier, boolean isOverwrite) {
        StringBuilder query = new StringBuilder(String.format("INSERT %s %s VALUES ", isOverwrite ? "OVERWRITE TABLE" : "INTO", identifier));
        records.forEach(record -> {
            query.append("(");
            query.append(record.struct().fields().stream().map(field -> this.getStringValueForInsert(record.getField(field.name()), field.type())).collect(Collectors.joining(",")));
            query.append("),");
        });
        query.setLength(query.length() - 1);
        return query.toString();
    }

    public String getUpdateQuery(String tableName, Record record) {
        StringBuilder query = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        query.append(record.struct().fields().stream().map(field -> field.name() + "=" + this.getStringValueForInsert(record.getField(field.name()), field.type())).collect(Collectors.joining(",")));
        return query.toString();
    }

    public List<Record> createTableWithGeneratedRecords(TestHiveShell shell, String tableName, Schema schema, FileFormat fileFormat, int numRecords) throws IOException {
        List<Record> records = TestHelper.generateRandomRecords(schema, numRecords, 0L);
        this.createTable(shell, tableName, schema, fileFormat, records);
        return records;
    }

    public Table createIcebergTable(Configuration configuration, String tableName, Schema schema, FileFormat fileFormat, Map<String, String> additionalTableProps, List<Record> records) throws IOException {
        return this.createIcebergTable(configuration, tableName, schema, SortOrder.unsorted(), PartitionSpec.unpartitioned(), fileFormat, additionalTableProps, records);
    }

    public Table createIcebergTable(Configuration configuration, String tableName, Schema schema, SortOrder order, PartitionSpec partSpec, FileFormat fileFormat, Map<String, String> additionalTableProps, List<Record> records) throws IOException {
        String identifier = this.identifier("default." + tableName);
        TestHelper helper = new TestHelper(new Configuration(configuration), this.tables(), identifier, schema, partSpec, fileFormat, additionalTableProps, this.temp);
        helper.setOrder(order);
        Table table = helper.createTable();
        if (records != null && !records.isEmpty()) {
            helper.appendToTable(helper.writeFile(null, records));
        }
        return table;
    }

    public void appendIcebergTable(Configuration configuration, Table table, FileFormat format, StructLike partition, List<Record> records) throws IOException {
        TestHelper helper = new TestHelper(configuration, null, null, null, null, format, this.temp);
        helper.setTable(table);
        if (!records.isEmpty()) {
            helper.appendToTable(helper.writeFile(partition, records));
        }
    }

    public void truncateIcebergTable(Table table) {
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
    }

    private static String tablePath(TableIdentifier identifier) {
        return "/" + Joiner.on((String)"/").join((Object[])identifier.namespace().levels()) + "/" + identifier.name();
    }

    private String getStringValueForInsert(Object value, Type type) {
        String template = "'%s'";
        if (value == null) {
            return "NULL";
        }
        if (type.equals(Types.TimestampType.withoutZone())) {
            return String.format(template, Timestamp.valueOf((LocalDateTime)value));
        }
        if (type.equals(Types.TimestampType.withZone())) {
            return String.format(template, Timestamp.from(((OffsetDateTime)value).toInstant()));
        }
        if (type.equals(Types.BooleanType.get())) {
            return value.toString();
        }
        return String.format(template, value.toString());
    }

    private static class CatalogToTables
    implements Tables {
        private final Catalog catalog;

        private CatalogToTables(Catalog catalog) {
            this.catalog = catalog;
        }

        public Table create(Schema schema, PartitionSpec spec, SortOrder sortOrder, Map<String, String> properties, String tableIdentifier) {
            TableIdentifier tableIdent = TableIdentifier.parse((String)tableIdentifier);
            return this.catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withSortOrder(sortOrder).withProperties(properties).create();
        }

        public Table load(String tableIdentifier) {
            return this.catalog.loadTable(TableIdentifier.parse((String)tableIdentifier));
        }

        public boolean exists(String tableIdentifier) {
            return this.catalog.tableExists(TableIdentifier.parse((String)tableIdentifier));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TestTableType {
        HADOOP_TABLE{

            @Override
            public TestTables instance(Configuration conf, TemporaryFolder temporaryFolder, String catalogName) {
                return new HadoopTestTables(conf, temporaryFolder);
            }
        }
        ,
        HADOOP_CATALOG{

            @Override
            public TestTables instance(Configuration conf, TemporaryFolder temporaryFolder, String catalogName) throws IOException {
                return new HadoopCatalogTestTables(conf, temporaryFolder, catalogName);
            }
        }
        ,
        CUSTOM_CATALOG{

            @Override
            public TestTables instance(Configuration conf, TemporaryFolder temporaryFolder, String catalogName) throws IOException {
                return new CustomCatalogTestTables(conf, temporaryFolder, catalogName);
            }
        }
        ,
        HIVE_CATALOG{

            @Override
            public TestTables instance(Configuration conf, TemporaryFolder temporaryFolder, String catalogName) {
                return new HiveTestTables(conf, temporaryFolder, catalogName);
            }
        };


        public abstract TestTables instance(Configuration var1, TemporaryFolder var2, String var3) throws IOException;
    }

    static class HiveTestTables
    extends TestTables {
        HiveTestTables(Configuration conf, TemporaryFolder temp, String catalogName) {
            super(CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)conf), temp, catalogName);
        }

        @Override
        public Map<String, String> properties() {
            return ImmutableMap.of((Object)InputFormatConfig.catalogPropertyConfigKey((String)this.catalog, (String)"type"), (Object)"hive");
        }

        @Override
        public String locationForCreateTableSQL(TableIdentifier identifier) {
            return "";
        }

        @Override
        public String createHiveTableSQL(TableIdentifier identifier, Map<String, String> tblProps) {
            return null;
        }
    }

    static class HadoopTestTables
    extends TestTables {
        HadoopTestTables(Configuration conf, TemporaryFolder temp) {
            super((Tables)new HadoopTables(conf), temp, "location_based_table");
        }

        @Override
        public String identifier(String tableIdentifier) {
            File location;
            try {
                TableIdentifier identifier = TableIdentifier.parse((String)tableIdentifier);
                location = this.temp.newFolder((String[])ObjectArrays.concat((Object[])identifier.namespace().levels(), (Object)identifier.name()));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            Assert.assertTrue((boolean)location.delete());
            return "file://" + location;
        }

        @Override
        public String locationForCreateTableSQL(TableIdentifier identifier) {
            return "LOCATION '" + this.temp.getRoot().getPath() + TestTables.tablePath(identifier) + "' ";
        }

        @Override
        public Table loadTable(TableIdentifier identifier) {
            return this.tables().load(this.temp.getRoot().getPath() + TestTables.tablePath(identifier));
        }
    }

    static class HadoopCatalogTestTables
    extends TestTables {
        private final String warehouseLocation;

        HadoopCatalogTestTables(Configuration conf, TemporaryFolder temp, String catalogName) throws IOException {
            this(conf, temp, (HiveVersion.min((HiveVersion)HiveVersion.HIVE_3) ? "file:" : "") + temp.newFolder(new String[]{"hadoop", "warehouse"}).toString(), catalogName);
        }

        HadoopCatalogTestTables(Configuration conf, TemporaryFolder temp, String warehouseLocation, String catalogName) {
            super((Catalog)new HadoopCatalog(conf, warehouseLocation), temp, catalogName);
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public Map<String, String> properties() {
            return ImmutableMap.of((Object)InputFormatConfig.catalogPropertyConfigKey((String)this.catalog, (String)"type"), (Object)"hadoop", (Object)InputFormatConfig.catalogPropertyConfigKey((String)this.catalog, (String)"warehouse"), (Object)this.warehouseLocation);
        }

        @Override
        public String locationForCreateTableSQL(TableIdentifier identifier) {
            return "LOCATION '" + this.warehouseLocation + TestTables.tablePath(identifier) + "' ";
        }
    }

    static class CustomCatalogTestTables
    extends TestTables {
        private final String warehouseLocation;

        CustomCatalogTestTables(Configuration conf, TemporaryFolder temp, String catalogName) throws IOException {
            this(conf, temp, (HiveVersion.min((HiveVersion)HiveVersion.HIVE_3) ? "file:" : "") + temp.newFolder(new String[]{"custom", "warehouse"}).toString(), catalogName);
        }

        CustomCatalogTestTables(Configuration conf, TemporaryFolder temp, String warehouseLocation, String catalogName) {
            super((Catalog)new TestCatalogs.CustomHadoopCatalog(conf, warehouseLocation), temp, catalogName);
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public Map<String, String> properties() {
            return ImmutableMap.of((Object)InputFormatConfig.catalogPropertyConfigKey((String)this.catalog, (String)"catalog-impl"), (Object)TestCatalogs.CustomHadoopCatalog.class.getName(), (Object)InputFormatConfig.catalogPropertyConfigKey((String)this.catalog, (String)"warehouse"), (Object)this.warehouseLocation);
        }

        @Override
        public String locationForCreateTableSQL(TableIdentifier identifier) {
            return "LOCATION '" + this.warehouseLocation + TestTables.tablePath(identifier) + "' ";
        }
    }
}

