/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.List;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.mr.hive.TestUtilPhaser;
import org.apache.iceberg.relocated.com.google.common.base.Throwables;
import org.apache.iceberg.util.Tasks;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestOptimisticRetry
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentOverlappingUpdates() {
        block2: {
            this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
            String sql = "UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'";
            try {
                Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict");
                    shell.executeStatement(sql);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                if (!(cause instanceof ValidationException) || !cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM customers WHERE last_name='Changed'");
        Assert.assertEquals((long)5L, (long)res.size());
    }

    @Test
    public void testConcurrentOverwriteAndUpdate() {
        TestUtilPhaser.getInstance();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        String[] sql = new String[]{"INSERT OVERWRITE table customers SELECT * FROM customers where last_name='Taylor'", "UPDATE customers SET first_name='Changed' WHERE  last_name='Taylor'"};
        Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
            TestUtilPhaser.getInstance().getPhaser().register();
            HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
            HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict");
            shell.executeStatement(sql[i]);
            shell.closeSession();
        });
        TestUtilPhaser.destroyInstance();
    }

    @Test
    public void testNonOverlappingConcurrent2Updates() {
        block2: {
            this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
            String[] sql = new String[]{"UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'", "UPDATE customers SET last_name='Changed2' WHERE customer_id=2 and first_name='Jake'"};
            try {
                Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict");
                    shell.executeStatement(sql[i]);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                if (!(cause instanceof ValidationException) || !cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM customers WHERE last_name='Changed'");
        Assert.assertEquals((long)5L, (long)res.size());
        res = shell.executeStatement("SELECT * FROM customers WHERE last_name='Changed2'");
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test
    public void testConcurrent2MergeInserts() {
        block2: {
            this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1);
            this.testTables.createTable(shell, "target", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
            String sql = "MERGE INTO target t USING source s on t.customer_id = s.customer_id WHEN Not MATCHED THEN INSERT values (s.customer_id, s.first_name, s.last_name)";
            try {
                Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict");
                    shell.executeStatement(sql);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                if (!(cause instanceof ValidationException) || !cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM target");
        Assert.assertEquals((long)6L, (long)res.size());
    }

    @Test
    public void testConcurrent2MergeUpdates() {
        block2: {
            this.testTables.createTable(shell, "merge_update_source", HiveIcebergStorageHandlerTestUtils.USER_CLICKS_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.USER_CLICKS_RECORDS_1, 2);
            this.testTables.createTable(shell, "merge_update_target", HiveIcebergStorageHandlerTestUtils.USER_CLICKS_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.USER_CLICKS_RECORDS_2, 2);
            String query1 = "merge into merge_update_target using ( select * from merge_update_source) sub on sub.name = merge_update_target.name when matched then update set age=15";
            String query2 = "merge into merge_update_target using ( select * from merge_update_source) sub on sub.age = merge_update_target.age when matched then update set age=15";
            String[] mergeQueryList = new String[]{query1, query2};
            try {
                Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict");
                    shell.executeStatement(mergeQueryList[i]);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                if (!(cause instanceof ValidationException) || !cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM merge_update_target where age = 15");
        Assert.assertEquals((long)2L, (long)res.size());
    }
}

