/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.HiveServer2;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.mr.hive.HiveIcebergQueryLifeTimeHook;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class TestHiveShell {
    private final TestHiveMetastore metastore;
    private final HiveServer2 hs2;
    private final HiveConf hs2Conf;
    private CLIService client;
    private boolean started;
    private ThreadLocal<HiveSession> session = ThreadLocal.withInitial(this::openSession);

    public TestHiveShell() {
        this.metastore = new TestHiveMetastore();
        this.hs2Conf = this.initializeConf();
        this.hs2 = new HiveServer2();
    }

    public void setHiveConfValue(String key, String value) {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"TestHiveShell has already been started. Cannot set Hive conf anymore.");
        this.hs2Conf.verifyAndSet(key, value);
    }

    public void setHiveSessionValue(String key, String value) {
        Preconditions.checkState((this.session.get() != null ? 1 : 0) != 0, (Object)"There is no open session for setting variables.");
        try {
            this.session.get().getSessionConf().set(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set Hive session variable: ", e);
        }
    }

    public void setHiveSessionValue(String key, boolean value) {
        this.setHiveSessionValue(key, Boolean.toString(value));
    }

    public void start() {
        this.metastore.start(new HiveConf(this.hs2Conf), 20);
        this.hs2Conf.setVar(HiveConf.ConfVars.METASTORE_URIS, this.metastore.hiveConf().getVar(HiveConf.ConfVars.METASTORE_URIS));
        this.hs2Conf.setVar(HiveConf.ConfVars.METASTORE_WAREHOUSE, this.metastore.hiveConf().getVar(HiveConf.ConfVars.METASTORE_WAREHOUSE));
        this.hs2Conf.setVar(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL, this.metastore.hiveConf().getVar(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL));
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.hs2.init(this.hs2Conf);
        this.hs2.start();
        this.client = this.hs2.getServices().stream().filter(CLIService.class::isInstance).findFirst().map(CLIService.class::cast).get();
        this.started = true;
    }

    public void stop() throws Exception {
        if (this.client != null) {
            this.client.stop();
        }
        this.hs2.stop();
        this.metastore.stop();
        this.started = false;
    }

    public TestHiveMetastore metastore() {
        return this.metastore;
    }

    private HiveSession openSession() {
        Preconditions.checkState((boolean)this.started, (Object)"You have to start TestHiveShell first, before opening a session.");
        try {
            SessionHandle sessionHandle = this.client.getSessionManager().openSession(CLIService.SERVER_VERSION, "", "", IPStackUtils.resolveLoopbackAddress(), Collections.emptyMap());
            return this.client.getSessionManager().getSession(sessionHandle);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open new Hive session: ", e);
        }
    }

    public void closeSession() {
        Preconditions.checkState((this.session.get() != null ? 1 : 0) != 0, (Object)"There is no open session to be closed.");
        try {
            this.session.get().close();
            this.session.remove();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close Hive session: ", e);
        }
    }

    public List<Object[]> executeStatement(String statement) {
        Preconditions.checkState((this.session.get() != null ? 1 : 0) != 0, (Object)"You have to start TestHiveShell and open a session first, before running a query.");
        try {
            OperationHandle handle = this.client.executeStatement(this.session.get().getSessionHandle(), statement, Collections.emptyMap());
            ArrayList resultSet = Lists.newArrayList();
            if (handle.hasResultSet()) {
                RowSet rowSet;
                while ((rowSet = this.client.fetchResults(handle)) != null && rowSet.numRows() > 0) {
                    for (Object[] row : rowSet) {
                        resultSet.add((Object[])row.clone());
                    }
                }
            }
            return resultSet;
        }
        catch (HiveSQLException e) {
            throw new IllegalArgumentException("Failed to execute Hive query '" + statement + "': " + e.getMessage(), e);
        }
    }

    public String executeAndStringify(String statement) {
        List<Object[]> objects = this.executeStatement(statement);
        return objects.stream().map(o -> Joiner.on((String)"\t").useForNull("NULL").join(o)).collect(Collectors.joining("\n"));
    }

    public Configuration getHiveConf() {
        if (this.session != null) {
            return this.session.get().getHiveConf();
        }
        return this.hs2Conf;
    }

    public HiveSession getSession() {
        return this.session.get();
    }

    private HiveConf initializeConf() {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 0);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT, -1);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, true);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_METADATA_ONLY_QUERIES, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPT_INDEX_FILTER, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SKEW_JOIN, false);
        hiveConf.setLongVar(HiveConf.ConfVars.HIVE_COUNTERS_PULL_INTERVAL, 1L);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        hiveConf.setInt("mapreduce.map.memory.mb", 1024);
        hiveConf.setBoolean("tez.local.mode", true);
        hiveConf.setBoolean("tez.local.mode.without.network", true);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        hiveConf.set(HiveConf.ConfVars.HIVE_TXN_MANAGER.varname, DbTxnManager.class.getName());
        hiveConf.set(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER.varname, SQLStdHiveAuthorizerFactory.class.getName());
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_IDE, true);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, HiveIcebergQueryLifeTimeHook.class.getName());
        MetastoreConf.setBoolVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL, (boolean)true);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED, false);
        return hiveConf;
    }
}

