/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveIcebergTypes
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testDecimalTableWithPredicateLiterals() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"decimal_field", (Type)Types.DecimalType.of((int)7, (int)2))});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(new BigDecimal("85.00")).add(new BigDecimal("100.56")).add(new BigDecimal("100.57")).build();
        this.testTables.createTable(shell, "dec_test", schema, this.fileFormat, records);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.dec_test where decimal_field >= 85");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"85.00"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"100.56"}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"100.57"}, (Object[])rows.get(2));
        rows = shell.executeStatement("SELECT * FROM default.dec_test where decimal_field > 99.1");
        Assert.assertEquals((long)2L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"100.56"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"100.57"}, (Object[])rows.get(1));
        rows = shell.executeStatement("SELECT * FROM default.dec_test where decimal_field > 100.565");
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"100.57"}, (Object[])rows.get(0));
        rows = shell.executeStatement("SELECT * FROM default.dec_test where decimal_field > 640.34");
        Assert.assertEquals((long)0L, (long)rows.size());
    }

    @Test
    public void testStructOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"structofmaps", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"map1", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.StringType.get())), Types.NestedField.required((int)5, (String)"map2", (Type)Types.MapType.ofRequired((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))}))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "structtable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List<Object[]> queryResult;
            GenericRecord expectedStruct = (GenericRecord)records.get(i).getField("structofmaps");
            Map expectedMap = (Map)expectedStruct.getField("map1");
            for (Map.Entry entry : expectedMap.entrySet()) {
                queryResult = shell.executeStatement(String.format("SELECT structofmaps.map1[\"%s\"] from default.structtable LIMIT 1 OFFSET %d", entry.getKey(), i));
                Assert.assertEquals(entry.getValue(), (Object)queryResult.get(0)[0]);
            }
            expectedMap = (Map)expectedStruct.getField("map2");
            for (Map.Entry entry : expectedMap.entrySet()) {
                queryResult = shell.executeStatement(String.format("SELECT structofmaps.map2[\"%s\"] from default.structtable LIMIT 1 OFFSET %d", entry.getKey(), i));
                Assert.assertEquals(entry.getValue(), (Object)queryResult.get(0)[0]);
            }
        }
    }

    @Test
    public void testStructOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"structofarrays", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"names", (Type)Types.ListType.ofRequired((int)3, (Type)Types.StringType.get())), Types.NestedField.required((int)4, (String)"birthdays", (Type)Types.ListType.ofRequired((int)5, (Type)Types.DateType.get()))}))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "structtable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List<Object[]> queryResult;
            int j;
            GenericRecord expectedStruct = (GenericRecord)records.get(i).getField("structofarrays");
            List expectedList = (List)expectedStruct.getField("names");
            for (j = 0; j < expectedList.size(); ++j) {
                queryResult = shell.executeStatement(String.format("SELECT structofarrays.names[%d] FROM default.structtable LIMIT 1 OFFSET %d", j, i));
                Assert.assertEquals(expectedList.get(j), (Object)queryResult.get(0)[0]);
            }
            expectedList = (List)expectedStruct.getField("birthdays");
            for (j = 0; j < expectedList.size(); ++j) {
                queryResult = shell.executeStatement(String.format("SELECT structofarrays.birthdays[%d] FROM default.structtable LIMIT 1 OFFSET %d", j, i));
                Assert.assertEquals((Object)expectedList.get(j).toString(), (Object)queryResult.get(0)[0]);
            }
        }
    }

    @Test
    public void testStructOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"structofprimitives", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"key", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"value", (Type)Types.IntegerType.get())}))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "structtable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            GenericRecord expectedStruct = (GenericRecord)records.get(i).getField("structofprimitives");
            List<Object[]> queryResult = shell.executeStatement(String.format("SELECT structofprimitives.key, structofprimitives.value FROM default.structtable LIMIT 1 OFFSET %d", i));
            Assert.assertEquals((Object)expectedStruct.getField("key"), (Object)queryResult.get(0)[0]);
            Assert.assertEquals((Object)expectedStruct.getField("value"), (Object)queryResult.get(0)[1]);
        }
    }

    @Test
    public void testStructOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"structofstructs", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"key", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"value", (Type)Types.IntegerType.get())}))}))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "structtable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            GenericRecord expectedStruct = (GenericRecord)records.get(i).getField("structofstructs");
            GenericRecord expectedInnerStruct = (GenericRecord)expectedStruct.getField("struct1");
            List<Object[]> queryResult = shell.executeStatement(String.format("SELECT structofstructs.struct1.key, structofstructs.struct1.value FROM default.structtable LIMIT 1 OFFSET %d", i));
            Assert.assertEquals((Object)expectedInnerStruct.getField("key"), (Object)queryResult.get(0)[0]);
            Assert.assertEquals((Object)expectedInnerStruct.getField("value"), (Object)queryResult.get(0)[1]);
        }
    }
}

