/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveIcebergTruncateTable
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testTruncateTable() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTruncateTable(databaseName, tableName, icebergTable, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, true, false);
    }

    @Test
    public void testTruncateEmptyTable() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{databaseName, tableName});
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, null);
        String alterTableCommand = "ALTER TABLE " + identifier + " SET TBLPROPERTIES('external.table.purge'='true')";
        shell.executeStatement(alterTableCommand);
        shell.executeStatement("ANALYZE TABLE " + identifier + " COMPUTE STATISTICS");
        shell.executeStatement("TRUNCATE " + identifier);
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{databaseName, tableName}));
        Map summary = icebergTable.currentSnapshot().summary();
        for (String key : STATS_MAPPING.values()) {
            Assert.assertEquals((Object)"0", summary.get(key));
        }
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + identifier);
        Assert.assertEquals((long)0L, (long)rows.size());
        this.validateBasicStats(icebergTable, databaseName, tableName);
    }

    @Test
    public void testMultipleTruncateTable() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTruncateTable(databaseName, tableName, icebergTable, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, true, false);
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(3L, "Jane", "Purple").add(4L, "Tim", "Grey").add(5L, "Eva", "Yellow").add(6L, "James", "White").add(7L, "Jack", "Black").build();
        shell.executeStatement("INSERT INTO default.customers values (3, 'Jane', 'Purple'), (4, 'Tim', 'Grey'),(5, 'Eva', 'Yellow'), (6, 'James', 'White'), (7, 'Jack', 'Black')");
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{databaseName, tableName}));
        this.testTruncateTable(databaseName, tableName, icebergTable, newRecords, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, true, false);
    }

    @Test
    public void testTruncateTableExternalPurgeFalse() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTruncateTable(databaseName, tableName, icebergTable, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, false, false);
    }

    @Test
    public void testTruncateTableForceExternalPurgeFalse() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTruncateTable(databaseName, tableName, icebergTable, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, false, true);
    }

    @Test
    public void testTruncateTableWithPartitionSpecOnUnpartitionedTable() throws IOException, TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{databaseName, tableName});
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("ALTER TABLE " + identifier + " SET TBLPROPERTIES('external.table.purge'='true')");
        shell.executeStatement("ANALYZE TABLE " + identifier + " COMPUTE STATISTICS");
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Writing data into a partition fails when the Iceberg table is unpartitioned.", () -> shell.executeStatement("TRUNCATE " + identifier + " PARTITION (customer_id=1)"));
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + identifier);
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{databaseName, tableName}));
        this.validateBasicStats(icebergTable, databaseName, tableName);
    }

    @Test
    public void testTruncateTableWithPartitionSpecOnPartitionedTable() {
        String databaseName = "default";
        String tableName = "customers";
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{databaseName, tableName});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("ALTER TABLE " + identifier + " SET TBLPROPERTIES('external.table.purge'='true')");
        shell.executeStatement("ANALYZE TABLE " + identifier + " COMPUTE STATISTICS");
        shell.executeStatement("TRUNCATE " + identifier + " PARTITION (customer_id=1)");
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + identifier);
        List<Record> truncatedRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Alice", "Brown").add(2L, "Trudy", "Pink").build();
        HiveIcebergTestUtils.validateData(truncatedRecords, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
    }

    @Test
    public void testTruncateTablePartitionedIcebergTable() throws TException, InterruptedException {
        String databaseName = "default";
        String tableName = "customers";
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Alice", "Brown").add(1L, "Bob", "Brown").add(2L, "Trudy", "Green").add(3L, "John", "Pink").add(4L, "Jane", "Pink").build();
        Table icebergTable = this.testTables.createTable(shell, tableName, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, records);
        this.testTruncateTable(databaseName, tableName, icebergTable, records, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, true, false);
    }

    private void testTruncateTable(String databaseName, String tableName, Table icebergTable, List<Record> records, Schema schema, boolean externalTablePurge, boolean force) throws TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{databaseName, tableName});
        String alterTableCommand = "ALTER TABLE " + identifier + " SET TBLPROPERTIES('external.table.purge'='" + externalTablePurge + "')";
        shell.executeStatement(alterTableCommand);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + identifier);
        HiveIcebergTestUtils.validateData(records, HiveIcebergTestUtils.valueForRow(schema, rows), 0);
        shell.executeStatement("ANALYZE TABLE " + identifier + " COMPUTE STATISTICS");
        this.validateBasicStats(icebergTable, databaseName, tableName);
        String truncateCommand = "TRUNCATE " + identifier;
        if (force) {
            truncateCommand = truncateCommand + " FORCE";
        }
        shell.executeStatement(truncateCommand);
        Table table = this.testTables.loadTable(identifier);
        Map summary = table.currentSnapshot().summary();
        for (String key : STATS_MAPPING.values()) {
            Assert.assertEquals((Object)"0", summary.get(key));
        }
        rows = shell.executeStatement("SELECT * FROM " + identifier);
        Assert.assertEquals((long)0L, (long)rows.size());
        this.validateBasicStats(table, databaseName, tableName);
    }
}

