/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergTimeTravel
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectAsOfTimestamp() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 0) + "'");
        Assert.assertEquals((long)3L, (long)rows.size());
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "'");
        Assert.assertEquals((long)4L, (long)rows.size());
        try {
            shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '1970-01-01 00:00:00'");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find a snapshot older than 1970-01-01"));
        }
    }

    @Test
    public void testSelectAsOfVersion() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        HistoryEntry first = (HistoryEntry)table.history().get(0);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF " + first.snapshotId());
        Assert.assertEquals((long)3L, (long)rows.size());
        HistoryEntry second = (HistoryEntry)table.history().get(1);
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF " + second.snapshotId());
        Assert.assertEquals((long)4L, (long)rows.size());
        try {
            shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF 1234");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find snapshot with ID 1234"));
        }
    }

    @Test
    public void testSelectAsOfBranchReference() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        long firstSnapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        table.manageSnapshots().createBranch("main_branch", firstSnapshotId).commit();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF 'main_branch'");
        Assert.assertEquals((long)3L, (long)rows.size());
        long secondSnapshotId = ((HistoryEntry)table.history().get(1)).snapshotId();
        table.manageSnapshots().createBranch("test_branch", secondSnapshotId).commit();
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF 'test_branch'");
        Assert.assertEquals((long)4L, (long)rows.size());
        try {
            shell.executeStatement("SELECT * FROM customers FOR SYSTEM_VERSION AS OF 'unknown_branch'");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find matching snapshot ID or reference name for version unknown_branch"));
        }
    }

    @Test
    public void testCTASAsOfVersionAndTimestamp() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 3);
        shell.executeStatement("CREATE TABLE customers2 AS SELECT * FROM customers FOR SYSTEM_VERSION AS OF " + ((HistoryEntry)table.history().get(0)).snapshotId());
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers2");
        Assert.assertEquals((long)3L, (long)rows.size());
        shell.executeStatement("INSERT INTO customers2 SELECT * FROM customers FOR SYSTEM_VERSION AS OF " + ((HistoryEntry)table.history().get(1)).snapshotId());
        rows = shell.executeStatement("SELECT * FROM customers2");
        Assert.assertEquals((long)7L, (long)rows.size());
        shell.executeStatement("CREATE TABLE customers3 AS SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "'");
        rows = shell.executeStatement("SELECT * FROM customers3");
        Assert.assertEquals((long)4L, (long)rows.size());
        shell.executeStatement("INSERT INTO customers3 SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 0) + "'");
        rows = shell.executeStatement("SELECT * FROM customers3");
        Assert.assertEquals((long)7L, (long)rows.size());
    }

    @Test
    public void testSelectAsOfCurrentTimestampAndInterval() throws IOException, InterruptedException {
        this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 3);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF CURRENT_TIMESTAMP + interval '10' hours");
        Assert.assertEquals((long)5L, (long)rows.size());
    }

    @Test
    public void testInvalidSelectAsOfTimestampExpression() throws IOException, InterruptedException {
        Table icebergTable = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 3);
        icebergTable.updateSchema().addColumn("create_time", (Type)Types.TimestampType.withZone()).commit();
        Assert.assertThrows(IllegalArgumentException.class, () -> shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF create_time - interval '10' hours"));
    }

    @Test
    public void testAsOfWithJoins() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 4);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 0) + "' fv, customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "' sv WHERE fv.first_name=sv.first_name");
        Assert.assertEquals((long)4L, (long)rows.size());
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "' sv, customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 2) + "' tv WHERE sv.first_name=tv.first_name");
        Assert.assertEquals((long)8L, (long)rows.size());
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 2) + "' sv, customers lv WHERE sv.first_name=lv.first_name");
        Assert.assertEquals((long)14L, (long)rows.size());
        rows = shell.executeStatement("SELECT * FROM customers FOR SYSTEM_TIME AS OF '" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "' sv, customers FOR SYSTEM_VERSION AS OF " + ((HistoryEntry)table.history().get(2)).snapshotId() + " tv WHERE sv.first_name=tv.first_name");
        Assert.assertEquals((long)8L, (long)rows.size());
    }
}

