/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergTagOperation
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTagWithDefaultConfig() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s", tagName));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.maxRefAgeMs());
        try {
            shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s", tagName));
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Ref test_tag_1 already exists"));
        }
    }

    @Test
    public void testCreateTagWithSnapshotId() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s FOR SYSTEM_VERSION AS OF %d", tagName, snapshotId));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateTagWithTimeStamp() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s FOR SYSTEM_TIME AS OF '%s'", tagName, HiveIcebergTestUtils.timestampAfterSnapshot(table, 0)));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
    }

    @Test
    public void testCreateTagWithMaxRefAge() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        long maxRefAge = 5L;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s RETAIN %d DAYS", tagName, maxRefAge));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateTagWithAllCustomConfig() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        long maxRefAge = 5L;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s FOR SYSTEM_VERSION AS OF %d RETAIN %d DAYS", tagName, snapshotId, maxRefAge));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateTagWithNonIcebergTable() {
        shell.executeStatement("create table nonice_tbl (id int, name string)");
        String tagName = "test_tag_1";
        try {
            shell.executeStatement(String.format("ALTER TABLE nonice_tbl CREATE TAG %s", tagName));
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Not an iceberg table"));
        }
    }

    @Test
    public void testQueryIcebergTag() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        long firstSnapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        table.manageSnapshots().createTag("testtag", firstSnapshotId).commit();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers.tag_testtag");
        Assert.assertEquals((long)3L, (long)rows.size());
        try {
            shell.executeStatement("insert into default.customers.tag_testtag values (0L, \"Alice\", \"Brown\")");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Don't support write (insert/delete/update/merge) to iceberg tag"));
        }
        try {
            shell.executeStatement("delete from default.customers.tag_testtag where customer_id=0L");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Don't support write (insert/delete/update/merge) to iceberg tag"));
        }
        try {
            shell.executeStatement("update default.customers.tag_testtag set customer_id=0L where customer_id=0L");
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Don't support write (insert/delete/update/merge) to iceberg tag"));
        }
    }

    @Test
    public void testDropTag() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String tagName = "test_tag_1";
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s", tagName));
        table.refresh();
        Assert.assertNotNull(table.refs().get(tagName));
        shell.executeStatement(String.format("ALTER TABLE customers DROP TAG IF EXISTS %s", tagName));
        table.refresh();
        Assert.assertNull(table.refs().get(tagName));
        try {
            shell.executeStatement(String.format("ALTER TABLE customers DROP TAG %s", tagName));
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Tag does not exist: test_tag_1"));
        }
    }

    @Test
    public void testReplaceTag() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "testReplaceTag"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (id INT) STORED BY iceberg  %s %s", identifier.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(1),(2),(3),(4)", identifier.name()));
        Table icebergTable = this.testTables.loadTable(identifier);
        icebergTable.refresh();
        long id1 = icebergTable.currentSnapshot().snapshotId();
        shell.executeStatement(String.format("ALTER TABLE %s create tag tag1", identifier.name()));
        shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(5),(6)", identifier.name()));
        icebergTable.refresh();
        long id2 = icebergTable.currentSnapshot().snapshotId();
        shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(7),(8)", identifier.name()));
        List<Object[]> result = shell.executeStatement("SELECT COUNT(*) FROM default.testReplaceTag.tag_tag1");
        Assert.assertEquals((Object)4L, (Object)result.get(0)[0]);
        shell.executeStatement(String.format("ALTER TABLE %s replace tag tag1 as of system_version %s", identifier.name(), id2));
        result = shell.executeStatement("SELECT COUNT(*) FROM default.testReplaceTag.tag_tag1");
        Assert.assertEquals((Object)6L, (Object)result.get(0)[0]);
        shell.executeStatement(String.format("ALTER TABLE %s replace tag tag1 as of system_version %s retain 2 days", identifier.name(), id1));
        result = shell.executeStatement("SELECT COUNT(*) FROM default.testReplaceTag.tag_tag1");
        Assert.assertEquals((Object)4L, (Object)result.get(0)[0]);
        icebergTable.refresh();
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(2L), (long)((SnapshotRef)icebergTable.refs().get("tag1")).maxRefAgeMs());
    }
}

