/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveIcebergStorageHandlerWithMultipleCatalogs {
    private static final String HIVECATALOGNAME = "table1_catalog";
    private static final String OTHERCATALOGNAME = "table2_catalog";
    private static TestHiveShell shell;
    @Parameterized.Parameter(value=0)
    public FileFormat fileFormat1;
    @Parameterized.Parameter(value=1)
    public FileFormat fileFormat2;
    @Parameterized.Parameter(value=2)
    public TestTables.TestTableType testTableType1;
    @Parameterized.Parameter(value=3)
    public String table1CatalogName;
    @Parameterized.Parameter(value=4)
    public TestTables.TestTableType testTableType2;
    @Parameterized.Parameter(value=5)
    public String table2CatalogName;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private TestTables testTables1;
    private TestTables testTables2;

    @Parameterized.Parameters(name="fileFormat1={0}, fileFormat2={1}, tableType1={2}, catalogName1={3}, tableType2={4}, catalogName2={5}")
    public static Collection<Object[]> parameters() {
        ArrayList testParams = Lists.newArrayList();
        for (TestTables.TestTableType testTableType : TestTables.ALL_TABLE_TYPES) {
            if (TestTables.TestTableType.HIVE_CATALOG.equals((Object)testTableType)) continue;
            testParams.add(new Object[]{FileFormat.PARQUET, FileFormat.ORC, TestTables.TestTableType.HIVE_CATALOG, HIVECATALOGNAME, testTableType, OTHERCATALOGNAME});
        }
        return testParams;
    }

    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        shell.stop();
    }

    @Before
    public void before() throws IOException {
        this.testTables1 = HiveIcebergStorageHandlerTestUtils.testTables(shell, this.testTableType1, this.temp, this.table1CatalogName);
        HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables1, this.temp);
        this.testTables1.properties().entrySet().forEach(e -> shell.setHiveSessionValue((String)e.getKey(), (String)e.getValue()));
        this.testTables2 = HiveIcebergStorageHandlerTestUtils.testTables(shell, this.testTableType2, this.temp, this.table2CatalogName);
        this.testTables2.properties().entrySet().forEach(e -> shell.setHiveSessionValue((String)e.getKey(), (String)e.getValue()));
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(shell);
    }

    @Test
    public void testJoinTablesFromDifferentCatalogs() throws IOException {
        this.createAndAddRecords(this.testTables1, this.fileFormat1, TableIdentifier.of((String[])new String[]{"default", "customers1"}), HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.createAndAddRecords(this.testTables2, this.fileFormat2, TableIdentifier.of((String[])new String[]{"default", "customers2"}), HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT c2.customer_id, c2.first_name, c2.last_name FROM default.customers2 c2 JOIN default.customers1 c1 ON c2.customer_id = c1.customer_id ORDER BY c2.customer_id");
        Assert.assertEquals((long)HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.size(), (long)rows.size());
        HiveIcebergTestUtils.validateData(Lists.newArrayList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS), HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
    }

    @Test
    public void testCTASFromOtherCatalog() throws IOException {
        this.testTables2.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat2, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement(String.format("CREATE TABLE target STORED BY ICEBERG TBLPROPERTIES ('%s'='%s') AS SELECT * FROM source", "iceberg.catalog", HIVECATALOGNAME));
        List<Object[]> objects = shell.executeStatement("SELECT * FROM target");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testCTASFromOtherCatalogFailureRollback() throws IOException {
        shell.setHiveSessionValue("hive.tez.mapreduce.output.committer.class", "org.apache.NotExistingClass");
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        this.testTables2.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat2, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        AssertHelpers.assertThrows((String)"Should fail while loading non-existent output committer class.", IllegalArgumentException.class, (String)"org.apache.NotExistingClass", () -> shell.executeStatement(String.format("CREATE TABLE target STORED BY ICEBERG TBLPROPERTIES ('%s'='%s') AS SELECT * FROM source", "iceberg.catalog", HIVECATALOGNAME)));
        Assert.assertThrows(NoSuchTableException.class, () -> this.testTables1.loadTable(target));
    }

    private void createAndAddRecords(TestTables testTables, FileFormat fileFormat, TableIdentifier identifier, List<Record> records) throws IOException {
        String createSql = String.format("CREATE EXTERNAL TABLE %s (customer_id BIGINT, first_name STRING, last_name STRING) STORED BY ICEBERG %s  TBLPROPERTIES ('%s'='%s', '%s'='%s')", identifier, testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", testTables.catalogName(), "write.format.default", fileFormat);
        shell.executeStatement(createSql);
        Table icebergTable = testTables.loadTable(identifier);
        testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, fileFormat, null, records);
    }
}

