/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveIcebergStorageHandlerTimezone {
    private static final Optional<ThreadLocal<DateFormat>> dateFormat = Optional.ofNullable((ThreadLocal)DynFields.builder().hiddenImpl(TimestampWritable.class, "threadLocalDateFormat").defaultAlwaysNull().buildStatic().get());
    private static final Optional<ThreadLocal<TimeZone>> localTimeZone = Optional.ofNullable((ThreadLocal)DynFields.builder().hiddenImpl(DateWritable.class, "LOCAL_TIMEZONE").defaultAlwaysNull().buildStatic().get());
    private static TestHiveShell shell;
    private TestTables testTables;
    @Parameterized.Parameter(value=0)
    public String timezoneString;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="timezone={0}")
    public static Collection<Object[]> parameters() {
        return ImmutableList.of((Object)new String[]{"America/New_York"}, (Object)new String[]{"Asia/Kolkata"}, (Object)new String[]{"UTC/Greenwich"});
    }

    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        shell.stop();
    }

    @Before
    public void before() throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone(this.timezoneString));
        TypeInfoFactory.timestampLocalTZTypeInfo.setTimeZone(TimeZone.getTimeZone(this.timezoneString).toZoneId());
        dateFormat.ifPresent(ThreadLocal::remove);
        localTimeZone.ifPresent(ThreadLocal::remove);
        this.testTables = HiveIcebergStorageHandlerTestUtils.testTables(shell, TestTables.TestTableType.HIVE_CATALOG, this.temp);
        HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(shell);
    }

    @Test
    public void testDateQuery() throws IOException {
        Schema dateSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"d_date", (Type)Types.DateType.get())});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(dateSchema).add(LocalDate.of(2020, 1, 21)).add(LocalDate.of(2020, 1, 24)).build();
        this.testTables.createTable(shell, "date_test", dateSchema, FileFormat.PARQUET, records);
        List<Object[]> result = shell.executeStatement("SELECT * from date_test WHERE d_date='2020-01-21'");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2020-01-21", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT * from date_test WHERE d_date in ('2020-01-21', '2020-01-22')");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2020-01-21", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT * from date_test WHERE d_date > '2020-01-21'");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2020-01-24", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT * from date_test WHERE d_date='2020-01-20'");
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testTimestampQuery() throws IOException {
        Schema timestampSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"d_ts", (Type)Types.TimestampType.withoutZone())});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(timestampSchema).add(LocalDateTime.of(2019, 1, 22, 9, 44, 54, 100000000)).add(LocalDateTime.of(2019, 2, 22, 9, 44, 54, 200000000)).build();
        this.testTables.createTable(shell, "ts_test", timestampSchema, FileFormat.PARQUET, records);
        List<Object[]> result = shell.executeStatement("SELECT d_ts FROM ts_test WHERE d_ts='2019-02-22 09:44:54.2'");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2019-02-22 09:44:54.2", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT * FROM ts_test WHERE d_ts in ('2017-01-01 22:30:57.1', '2019-02-22 09:44:54.2')");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2019-02-22 09:44:54.2", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT d_ts FROM ts_test WHERE d_ts < '2019-02-22 09:44:54.2'");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"2019-01-22 09:44:54.1", (Object)result.get(0)[0]);
        result = shell.executeStatement("SELECT * FROM ts_test WHERE d_ts='2017-01-01 22:30:57.3'");
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testTimestampQueryWithTimeZone() throws IOException {
        Schema timestampSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"d_ts", (Type)Types.TimestampType.withZone())});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(timestampSchema).add(OffsetDateTime.of(LocalDateTime.of(2019, 1, 22, 9, 44, 54, 100000000), ZoneOffset.of("+00"))).add(OffsetDateTime.of(LocalDateTime.of(2019, 2, 22, 9, 44, 54, 200000000), ZoneOffset.of("+00"))).build();
        this.testTables.createTable(shell, "ts_test_tz", timestampSchema, FileFormat.PARQUET, records);
        List<Object[]> result = shell.executeStatement("SELECT d_ts FROM ts_test_tz where d_ts='2019-02-22 09:44:54.200Z'");
        Assert.assertEquals((long)1L, (long)result.size());
        if (this.timezoneString.equals("America/New_York")) {
            Assert.assertEquals((Object)("2019-02-22 04:44:54.2 " + this.timezoneString), (Object)result.get(0)[0]);
        } else if (this.timezoneString.equals("Asia/Kolkata")) {
            Assert.assertEquals((Object)("2019-02-22 15:14:54.2 " + this.timezoneString), (Object)result.get(0)[0]);
        } else if (this.timezoneString.equals("GMT")) {
            Assert.assertEquals((Object)("2019-02-22 09:44:54.2 " + this.timezoneString), (Object)result.get(0)[0]);
        }
    }

    @Test
    public void testFetchTaskWithTimestampWithLocalTimeZone() throws IOException {
        Schema timestampSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"d_ts", (Type)Types.TimestampType.withZone())});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(timestampSchema).add(OffsetDateTime.of(LocalDateTime.of(2019, 2, 22, 9, 44, 54, 100000000), ZoneOffset.of("+00"))).build();
        this.testTables.createTable(shell, "ts_test_tz", timestampSchema, FileFormat.PARQUET, records);
        List<Object[]> result = shell.executeStatement("SELECT * FROM ts_test_tz");
        Assert.assertEquals((long)1L, (long)result.size());
        if (this.timezoneString.equals("America/New_York")) {
            Assert.assertEquals((Object)("2019-02-22 04:44:54.1 " + this.timezoneString), (Object)result.get(0)[0]);
        } else if (this.timezoneString.equals("Asia/Kolkata")) {
            Assert.assertEquals((Object)("2019-02-22 15:14:54.1 " + this.timezoneString), (Object)result.get(0)[0]);
        } else if (this.timezoneString.equals("GMT")) {
            Assert.assertEquals((Object)("2019-02-22 09:44:54.1 " + this.timezoneString), (Object)result.get(0)[0]);
        }
    }
}

