/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.CustomTestHiveAuthorizerFactory;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestHiveIcebergStorageHandlerNoScan {
    private static final PartitionSpec SPEC = PartitionSpec.unpartitioned();
    private static final Schema COMPLEX_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"name", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"employee_info", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"employer", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)9, (String)"address", (Type)Types.StringType.get())})), Types.NestedField.optional((int)4, (String)"places_lived", (Type)Types.ListType.ofOptional((int)10, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)11, (String)"street", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"city", (Type)Types.StringType.get()), Types.NestedField.optional((int)13, (String)"country", (Type)Types.StringType.get())}))), Types.NestedField.optional((int)5, (String)"memorable_moments", (Type)Types.MapType.ofOptional((int)14, (int)15, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)16, (String)"year", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)17, (String)"place", (Type)Types.StringType.get()), Types.NestedField.optional((int)18, (String)"details", (Type)Types.StringType.get())}))), Types.NestedField.optional((int)6, (String)"current_address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"street_address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"street_number", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)23, (String)"street_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)24, (String)"street_type", (Type)Types.StringType.get())})), Types.NestedField.optional((int)20, (String)"country", (Type)Types.StringType.get()), Types.NestedField.optional((int)21, (String)"postal_code", (Type)Types.StringType.get())}))});
    private static final Set<String> IGNORED_PARAMS = ImmutableSet.of((Object)"bucketing_version", (Object)"numFilesErasureCoded");
    private static TestHiveShell shell;
    private TestTables testTables;
    @Parameterized.Parameter(value=0)
    public TestTables.TestTableType testTableType;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="catalog={0}")
    public static Collection<Object[]> parameters() {
        ArrayList testParams = Lists.newArrayList();
        for (TestTables.TestTableType testTableType : TestTables.ALL_TABLE_TYPES) {
            testParams.add(new Object[]{testTableType});
        }
        return testParams;
    }

    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        shell.stop();
    }

    @Before
    public void before() throws IOException {
        this.testTables = HiveIcebergStorageHandlerTestUtils.testTables(shell, this.testTableType, this.temp);
        HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp, "mr");
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(shell);
    }

    @Test
    public void testPartitionEvolution() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"ts", (Type)Types.TimestampType.withZone())});
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "part_test"});
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + " TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)schema) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "', 'format-version'='1')");
        shell.executeStatement("ALTER TABLE " + identifier + " SET PARTITION SPEC (month(ts))");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).withSpecId(1).month("ts").build();
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE " + identifier + " SET PARTITION SPEC (day(ts))");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(2).alwaysNull("ts", "ts_month").day("ts").build();
        table.refresh();
        Assert.assertEquals((Object)spec, (Object)table.spec());
    }

    @Test
    public void testSetPartitionTransform() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"year_field", (Type)Types.DateType.get()), Types.NestedField.optional((int)3, (String)"month_field", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"day_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)5, (String)"hour_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)6, (String)"truncate_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"bucket_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"identity_field", (Type)Types.StringType.get())});
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "part_test"});
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " PARTITIONED BY SPEC (year(year_field), hour(hour_field), truncate(2, truncate_field), bucket(2, bucket_field), identity_field) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)schema) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "', 'format-version'='1')");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).year("year_field").hour("hour_field").truncate("truncate_field", 2).bucket("bucket_field", 2).identity("identity_field").build();
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((long)spec.specId(), (long)table.spec().specId());
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE default.part_test SET PARTITION SPEC(year(year_field), month(month_field), day(day_field))");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(1).year("year_field").alwaysNull("hour_field", "hour_field_hour").alwaysNull("truncate_field", "truncate_field_trunc").alwaysNull("bucket_field", "bucket_field_bucket").alwaysNull("identity_field", "identity_field").month("month_field").day("day_field").build();
        table.refresh();
        Assert.assertEquals((long)spec.specId(), (long)table.spec().specId());
        for (PartitionField field : spec.fields()) {
            Assert.assertTrue((String)field.name(), (boolean)table.spec().fields().stream().anyMatch(tableField -> tableField.name().equals(field.name())));
        }
    }

    @Test
    public void testPartitionTransform() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"year_field", (Type)Types.DateType.get()), Types.NestedField.optional((int)3, (String)"month_field", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"day_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)5, (String)"hour_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)6, (String)"truncate_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"bucket_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"identity_field", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).year("year_field").month("month_field").day("day_field").hour("hour_field").truncate("truncate_field", 2).bucket("bucket_field", 2).identity("identity_field").build();
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "part_test"});
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " PARTITIONED BY SPEC (year(year_field), month(month_field), day(day_field), hour(hour_field), truncate(2, truncate_field), bucket(2, bucket_field), identity_field) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + " TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)schema) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "')");
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)spec, (Object)table.spec());
    }

    @Test
    public void testSetPartitionTransformSameField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"truncate_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"bucket_field", (Type)Types.StringType.get())});
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "part_test"});
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " PARTITIONED BY SPEC (truncate(2, truncate_field), bucket(2, bucket_field)) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)schema) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "', 'format-version'='1')");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("truncate_field", 2).bucket("bucket_field", 2).build();
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE default.part_test SET PARTITION SPEC (truncate(3, truncate_field), bucket(2, bucket_field) )");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(1).alwaysNull("truncate_field", "truncate_field_trunc").bucket("bucket_field", 2).truncate("truncate_field", 3, "truncate_field_trunc_3").build();
        table.refresh();
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE default.part_test SET PARTITION SPEC (truncate(4, truncate_field), bucket(2, bucket_field) )");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(2).alwaysNull("truncate_field", "truncate_field_trunc").bucket("bucket_field", 2).alwaysNull("truncate_field", "truncate_field_trunc_3").truncate("truncate_field", 4, "truncate_field_trunc_4").build();
        table.refresh();
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE default.part_test SET PARTITION SPEC (bucket(3, bucket_field), truncate(4, truncate_field))");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(3).alwaysNull("truncate_field", "truncate_field_trunc").alwaysNull("bucket_field", "bucket_field_bucket").alwaysNull("truncate_field", "truncate_field_trunc_3").truncate("truncate_field", 4, "truncate_field_trunc_4").bucket("bucket_field", 3, "bucket_field_bucket_3").build();
        table.refresh();
        Assert.assertEquals((Object)spec, (Object)table.spec());
    }

    @Test
    public void testSetPartitionTransformCaseSensitive() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"truncate_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"bucket_field", (Type)Types.StringType.get())});
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "part_test"});
        shell.executeStatement("CREATE EXTERNAL TABLE " + identifier + " PARTITIONED BY SPEC (truncate(2, truncate_field), bucket(2, bucket_field)) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)schema) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "', 'format-version'='1')");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("truncate_field", 2).bucket("bucket_field", 2).build();
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        shell.executeStatement("ALTER TABLE default.part_test SET PARTITION SPEC (truncaTe(3, truncate_Field), buCket(3, bUckeT_field))");
        spec = PartitionSpec.builderFor((Schema)schema).withSpecId(1).alwaysNull("truncate_field", "truncate_field_trunc").alwaysNull("bucket_field", "bucket_field_bucket").truncate("truncate_field", 3, "truncate_field_trunc_3").bucket("bucket_field", 3, "bucket_field_bucket_3").build();
        table.refresh();
        Assert.assertEquals((Object)spec, (Object)table.spec());
    }

    @Test
    public void testInvalidCreateWithPartitionTransform() {
        Assume.assumeTrue((String)"Test on hive catalog is enough", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT, first_name STRING, last_name STRING) PARTITIONED BY spec(TRUNCATE(2, last_name)) STORED AS ORC", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(query)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Partition transforms are only supported by Iceberg storage handler");
    }

    @Test
    public void testCreateDropTable() throws TException, IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "', 'iceberg.mr.table.partition.spec'='" + PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()) + "', 'dummy'='test', 'external.table.purge'='TRUE', 'iceberg.catalog'='" + this.testTables.catalogName() + "')");
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.asStruct(), (Object)icebergTable.schema().asStruct());
        Assert.assertEquals((Object)PartitionSpec.unpartitioned(), (Object)icebergTable.spec());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        Properties tableProperties = new Properties();
        hmsTable.getParameters().entrySet().stream().filter(e -> !IGNORED_PARAMS.contains(e.getKey())).forEach(e -> tableProperties.put(e.getKey(), e.getValue()));
        if (!Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            shell.executeStatement("DROP TABLE customers");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testTables.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessageStartingWith("Table does not exist");
        } else {
            Path hmsTableLocation = new Path(hmsTable.getSd().getLocation());
            shell.executeStatement("DROP TABLE customers");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testTables.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: default.customers");
            FileSystem fs = Util.getFs((Path)hmsTableLocation, (Configuration)shell.getHiveConf());
            if (fs.exists(hmsTableLocation)) {
                Assert.assertEquals((long)1L, (long)fs.listStatus(hmsTableLocation).length);
                Assert.assertEquals((long)0L, (long)fs.listStatus(new Path(hmsTableLocation, "metadata")).length);
            }
        }
    }

    @Test
    public void testCreateDropTableNonDefaultCatalog() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String catalogName = "nondefaultcatalog";
        this.testTables.properties().entrySet().forEach(e -> shell.setHiveSessionValue(((String)e.getKey()).replace(this.testTables.catalog, catalogName), (String)e.getValue()));
        String createSql = "CREATE EXTERNAL TABLE " + identifier + " (customer_id BIGINT, first_name STRING COMMENT 'This is first name', last_name STRING COMMENT 'This is last name') STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"external.table.purge", (Object)"TRUE"));
        shell.executeStatement(createSql);
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.asStruct(), (Object)icebergTable.schema().asStruct());
        shell.executeStatement("DROP TABLE default.customers");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testTables.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessageStartingWith("Table does not exist");
    }

    @Test
    public void testCreateTableStoredByIceberg() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT, first_name STRING, last_name STRING) STORED BY iceBerg %s TBLPROPERTIES ('%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        shell.executeStatement(query);
        Assert.assertNotNull((Object)this.testTables.loadTable(identifier));
    }

    @Test
    public void testCreateTableStoredByIcebergWithSerdeProperties() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT, first_name STRING, last_name STRING) STORED BY iceberg WITH SERDEPROPERTIES('%s'='%s') %s TBLPROPERTIES ('%s'='%s')", "write.format.default", "orc", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        shell.executeStatement(query);
        Table table = this.testTables.loadTable(identifier);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)"orc", table.properties().get("write.format.default"));
    }

    @Test
    public void testCreateTableWithoutSpec() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "','iceberg.catalog'='" + this.testTables.catalogName() + "')");
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)PartitionSpec.unpartitioned(), (Object)icebergTable.spec());
    }

    @Test
    public void testCreateTableWithUnpartitionedSpec() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "', 'iceberg.mr.table.partition.spec'='" + PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "')");
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)SPEC, (Object)icebergTable.spec());
    }

    @Test
    public void testDeleteBackingTable() throws TException, IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "', 'external.table.purge'='FALSE', 'iceberg.catalog'='" + this.testTables.catalogName() + "')");
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        Properties tableProperties = new Properties();
        hmsTable.getParameters().entrySet().stream().filter(e -> !IGNORED_PARAMS.contains(e.getKey())).forEach(e -> tableProperties.put(e.getKey(), e.getValue()));
        if (!Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            shell.executeStatement("DROP TABLE customers");
            this.testTables.loadTable(identifier);
        } else {
            Path hmsTableLocation = new Path(hmsTable.getSd().getLocation());
            shell.executeStatement("DROP TABLE customers");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testTables.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: default.customers");
            FileSystem fs = Util.getFs((Path)hmsTableLocation, (Configuration)shell.getHiveConf());
            Assert.assertEquals((long)1L, (long)fs.listStatus(hmsTableLocation).length);
            Assert.assertEquals((long)1L, (long)fs.listStatus(new Path(hmsTableLocation, "metadata")).length);
        }
    }

    @Test
    public void testDropTableWithCorruptedMetadata() throws TException, IOException, InterruptedException {
        Assume.assumeTrue((String)"Only HiveCatalog attempts to load the Iceberg table prior to dropping it.", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        Table table = this.testTables.loadTable(identifier);
        table.updateProperties().set("gc.enabled", "true").commit();
        String metadataLocation = (String)shell.metastore().getTable(identifier).getParameters().get("metadata_location");
        table.io().deleteFile(metadataLocation);
        shell.executeStatement(String.format("DROP TABLE %s", identifier));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testTables.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: default.customers");
    }

    @Test
    public void testCreateTableError() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "withShell2"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE withShell2 STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='WrongSchema','iceberg.catalog'='" + this.testTables.catalogName() + "')")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("Unrecognized token 'WrongSchema'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE withShell2 STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("Please provide an existing table or a valid schema");
        if (!this.testTables.locationForCreateTableSQL(identifier).isEmpty()) {
            AbstractThrowableAssert assertThatThrownBy = Assertions.assertThatCode(() -> shell.executeStatement("CREATE EXTERNAL TABLE withShell2 STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "','iceberg.catalog'='" + this.testTables.catalogName() + "')"));
            if (this.testTableType != TestTables.TestTableType.HADOOP_CATALOG) {
                ((AbstractThrowableAssert)assertThatThrownBy.isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("Table location not set");
            } else {
                assertThatThrownBy.doesNotThrowAnyException();
            }
        }
    }

    @Test
    public void testCreateTableAboveExistingTable() throws IOException {
        this.testTables.createIcebergTable(shell.getHiveConf(), "customers", COMPLEX_SCHEMA, FileFormat.PARQUET, Collections.emptyMap(), Collections.emptyList());
        if (this.testTableType == TestTables.TestTableType.HIVE_CATALOG) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "',' iceberg.catalog'='" + this.testTables.catalogName() + "')")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("customers already exists");
        } else {
            shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "customers"})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        }
    }

    @Test
    public void testFormatVersion() throws IOException {
        Assume.assumeTrue((this.testTableType != TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier tbl = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createIcebergTable(shell.getHiveConf(), "customers", COMPLEX_SCHEMA, FileFormat.PARQUET, Collections.singletonMap("format-version", "2"), Collections.emptyList());
        shell.executeStatement("CREATE EXTERNAL TABLE customers STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "customers"})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        String fmt = shell.executeAndStringify("show create table " + tbl);
        Assert.assertTrue((String)fmt, (boolean)fmt.contains("'format-version'='2'"));
    }

    @Test
    public void testCreatePartitionedTableWithPropertiesAndWithColumnSpecification() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE customers (customer_id BIGINT) PARTITIONED BY (first_name STRING) STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "customers"})) + " TBLPROPERTIES ('iceberg.mr.table.partition.spec'='" + PartitionSpecParser.toJson((PartitionSpec)spec) + "')")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("Provide only one of the following: Hive partition transform specification, or the iceberg.mr.table.partition.spec property");
    }

    @Test
    public void testCreateTableWithColumnSpecificationHierarchy() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (id BIGINT, name STRING, employee_info STRUCT < employer: STRING, id: BIGINT, address: STRING >, places_lived ARRAY < STRUCT <street: STRING, city: STRING, country: STRING >>, memorable_moments MAP < STRING, STRUCT < year: INT, place: STRING, details: STRING >>, current_address STRUCT < street_address: STRUCT <street_number: INT, street_name: STRING, street_type: STRING>, country: STRING, postal_code: STRING >) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)COMPLEX_SCHEMA.asStruct(), (Object)icebergTable.schema().asStruct());
    }

    @Test
    public void testCreateTableWithAllSupportedTypes() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "all_types"});
        Schema allSupportedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"t_float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"t_double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)3, (String)"t_boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)4, (String)"t_int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"t_bigint", (Type)Types.LongType.get()), Types.NestedField.optional((int)6, (String)"t_binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)7, (String)"t_string", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"t_timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"t_date", (Type)Types.DateType.get()), Types.NestedField.optional((int)10, (String)"t_decimal", (Type)Types.DecimalType.of((int)3, (int)2))});
        shell.executeStatement("CREATE EXTERNAL TABLE all_types (t_Float FLOaT, t_dOuble DOUBLE, t_boolean BOOLEAN, t_int INT, t_bigint BIGINT, t_binary BINARY, t_string STRING, t_timestamp TIMESTAMP, t_date DATE, t_decimal DECIMAL(3,2)) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)allSupportedSchema.asStruct(), (Object)icebergTable.schema().asStruct());
    }

    @Test
    public void testCreateTableWithNotSupportedTypes() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "not_supported_types"});
        ImmutableMap notSupportedTypes = ImmutableMap.of((Object)"TINYINT", (Object)Types.IntegerType.get(), (Object)"SMALLINT", (Object)Types.IntegerType.get(), (Object)"VARCHAR(1)", (Object)Types.StringType.get(), (Object)"CHAR(1)", (Object)Types.StringType.get());
        for (String notSupportedType : notSupportedTypes.keySet()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE not_supported_types (not_supported " + notSupportedType + ") STORED BY 'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler' " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Failed to execute Hive query").hasMessageContaining("Unsupported Hive type " + notSupportedType.replaceAll("\\(.*\\)", ""));
        }
    }

    @Test
    public void testCreateTableWithNotSupportedTypesWithAutoConversion() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "not_supported_types"});
        ImmutableMap notSupportedTypes = ImmutableMap.of((Object)"TINYINT", (Object)Types.IntegerType.get(), (Object)"SMALLINT", (Object)Types.IntegerType.get(), (Object)"VARCHAR(1)", (Object)Types.StringType.get(), (Object)"CHAR(1)", (Object)Types.StringType.get());
        shell.setHiveSessionValue("iceberg.mr.schema.auto.conversion", "true");
        for (String notSupportedType : notSupportedTypes.keySet()) {
            shell.executeStatement("CREATE EXTERNAL TABLE not_supported_types (not_supported " + notSupportedType + ") STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"external.table.purge", (Object)"TRUE")));
            Table icebergTable = this.testTables.loadTable(identifier);
            Assert.assertEquals(notSupportedTypes.get(notSupportedType), (Object)((Types.NestedField)icebergTable.schema().columns().get(0)).type());
            shell.executeStatement("DROP TABLE not_supported_types");
        }
    }

    @Test
    public void testCreateTableWithColumnComments() throws InterruptedException, TException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "comment_table"});
        shell.executeStatement("CREATE EXTERNAL TABLE comment_table (t_int INT COMMENT 'int column',  t_string STRING COMMENT 'string column', t_string_2 STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        Table icebergTable = this.testTables.loadTable(identifier);
        List<Object[]> rows = shell.executeStatement("DESCRIBE default.comment_table");
        Assert.assertEquals((long)icebergTable.schema().columns().size(), (long)rows.size());
        for (int i = 0; i < icebergTable.schema().columns().size(); ++i) {
            Types.NestedField field = (Types.NestedField)icebergTable.schema().columns().get(i);
            Assert.assertArrayEquals((Object[])new Object[]{field.name(), HiveSchemaUtil.convert((Type)field.type()).getTypeName(), field.doc() != null ? field.doc() : ""}, (Object[])rows.get(i));
        }
        List cols = shell.metastore().getTable(identifier).getSd().getCols();
        Assert.assertEquals((Object)icebergTable.schema().asStruct(), (Object)HiveSchemaUtil.convert((List)cols).asStruct());
    }

    @Test
    public void testCreateTableWithoutColumnComments() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "without_comment_table"});
        shell.executeStatement("CREATE EXTERNAL TABLE without_comment_table (t_int INT,  t_string STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        Table icebergTable = this.testTables.loadTable(identifier);
        List<Object[]> rows = shell.executeStatement("DESCRIBE default.without_comment_table");
        Assert.assertEquals((long)icebergTable.schema().columns().size(), (long)rows.size());
        for (int i = 0; i < icebergTable.schema().columns().size(); ++i) {
            Types.NestedField field = (Types.NestedField)icebergTable.schema().columns().get(i);
            Assert.assertNull((Object)field.doc());
            Assert.assertArrayEquals((Object[])new Object[]{field.name(), HiveSchemaUtil.convert((Type)field.type()).getTypeName(), ""}, (Object[])rows.get(i));
        }
    }

    @Test
    public void testCreatePartitionedTableWithColumnComments() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "partitioned_with_comment_table"});
        String[] expectedDoc = new String[]{"int column", "string column", null, "partition column", null};
        shell.executeStatement("CREATE EXTERNAL TABLE partitioned_with_comment_table (t_int INT COMMENT 'int column',  t_string STRING COMMENT 'string column', t_string_2 STRING) PARTITIONED BY (t_string_3 STRING COMMENT 'partition column', t_string_4 STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        Table icebergTable = this.testTables.loadTable(identifier);
        List<Object[]> rows = shell.executeStatement("DESCRIBE default.partitioned_with_comment_table");
        List columns = icebergTable.schema().columns();
        Assert.assertEquals((long)(columns.size() + 5), (long)rows.size());
        for (int i = 0; i < columns.size(); ++i) {
            Types.NestedField field = (Types.NestedField)columns.get(i);
            Assert.assertArrayEquals((Object[])new Object[]{field.name(), HiveSchemaUtil.convert((Type)field.type()).getTypeName(), field.doc() != null ? field.doc() : ""}, (Object[])rows.get(i));
            Assert.assertEquals((Object)expectedDoc[i], (Object)field.doc());
        }
    }

    @Test
    public void testAlterTableProperties() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (t_int INT,  t_string STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        String propKey = "dummy";
        String propValue = "dummy_val";
        shell.executeStatement(String.format("ALTER TABLE customers SET TBLPROPERTIES('%s'='%s')", propKey, propValue));
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertTrue((boolean)icebergTable.properties().containsKey(propKey));
        Assert.assertEquals(icebergTable.properties().get(propKey), (Object)propValue);
        propValue = "new_dummy_val";
        shell.executeStatement(String.format("ALTER TABLE customers SET TBLPROPERTIES('%s'='%s')", propKey, propValue));
        icebergTable.refresh();
        Assert.assertTrue((boolean)icebergTable.properties().containsKey(propKey));
        Assert.assertEquals(icebergTable.properties().get(propKey), (Object)propValue);
        shell.executeStatement(String.format("ALTER TABLE customers UNSET TBLPROPERTIES('%s'='%s')", propKey, propValue));
        icebergTable.refresh();
        Assert.assertFalse((boolean)icebergTable.properties().containsKey(propKey));
    }

    @Test
    public void testIcebergAndHmsTableProperties() throws Exception {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE default.customers STORED BY ICEBERG %sTBLPROPERTIES ('%s'='%s', '%s'='%s', '%s'='%s', '%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.mr.table.schema", SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA), "iceberg.mr.table.partition.spec", PartitionSpecParser.toJson((PartitionSpec)SPEC), "custom_property", "initial_val", "iceberg.catalog", this.testTables.catalogName()));
        Table icebergTable = this.testTables.loadTable(identifier);
        HashMap expectedIcebergProperties = Maps.newHashMap();
        expectedIcebergProperties.put("custom_property", "initial_val");
        expectedIcebergProperties.put("EXTERNAL", "TRUE");
        expectedIcebergProperties.put("storage_handler", HiveIcebergStorageHandler.class.getName());
        expectedIcebergProperties.put("serialization.format", "1");
        expectedIcebergProperties.put("write.parquet.compression-codec", "zstd");
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        Map hmsParams = hmsTable.getParameters().entrySet().stream().filter(e -> !IGNORED_PARAMS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Properties tableProperties = new Properties();
        tableProperties.putAll((Map<?, ?>)hmsParams);
        if (HiveVersion.min((HiveVersion)HiveVersion.HIVE_3)) {
            expectedIcebergProperties.put("bucketing_version", "2");
        }
        expectedIcebergProperties.put("write.delete.mode", "merge-on-read");
        expectedIcebergProperties.put("write.update.mode", "merge-on-read");
        expectedIcebergProperties.put("write.merge.mode", "merge-on-read");
        Assert.assertEquals((Object)expectedIcebergProperties, (Object)icebergTable.properties());
        if (Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            Assert.assertEquals((Object)"initial_val", (Object)hmsParams.get("custom_property"));
            Assert.assertEquals((Object)"TRUE", (Object)hmsParams.get("EXTERNAL"));
            Assert.assertEquals((Object)HiveIcebergStorageHandler.class.getName(), (Object)hmsParams.get("storage_handler"));
            Assert.assertEquals((Object)"iceberg".toUpperCase(), (Object)hmsParams.get("table_type"));
            Assert.assertEquals((Object)hmsParams.get("metadata_location"), (Object)this.getCurrentSnapshotForHiveCatalogTable(icebergTable));
            Assert.assertNull((Object)hmsParams.get("previous_metadata_location"));
            Assert.assertNotNull((Object)hmsParams.get("transient_lastDdlTime"));
            Assert.assertNotNull((Object)hmsParams.get("serialization.format"));
        } else {
            Assert.assertNull((Object)hmsParams.get("engine.hive.enabled"));
        }
        Assert.assertEquals((Object)HiveIcebergInputFormat.class.getName(), (Object)hmsTable.getSd().getInputFormat());
        Assert.assertEquals((Object)HiveIcebergOutputFormat.class.getName(), (Object)hmsTable.getSd().getOutputFormat());
        Assert.assertEquals((Object)HiveIcebergSerDe.class.getName(), (Object)hmsTable.getSd().getSerdeInfo().getSerializationLib());
        icebergTable.updateProperties().set("new_prop_1", "true").set("new_prop_2", "false").set("custom_property", "new_val").commit();
        hmsParams = shell.metastore().getTable("default", "customers").getParameters().entrySet().stream().filter(e -> !IGNORED_PARAMS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            Assert.assertEquals((Object)"true", (Object)hmsParams.get("new_prop_1"));
            Assert.assertEquals((Object)"false", (Object)hmsParams.get("new_prop_2"));
            Assert.assertEquals((Object)"new_val", (Object)hmsParams.get("custom_property"));
            String prevSnapshot = this.getCurrentSnapshotForHiveCatalogTable(icebergTable);
            icebergTable.refresh();
            String newSnapshot = this.getCurrentSnapshotForHiveCatalogTable(icebergTable);
            Assert.assertEquals(hmsParams.get("previous_metadata_location"), (Object)prevSnapshot);
            Assert.assertEquals(hmsParams.get("metadata_location"), (Object)newSnapshot);
        }
        if (Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            icebergTable.updateProperties().remove("custom_property").remove("new_prop_1").commit();
            hmsParams = shell.metastore().getTable("default", "customers").getParameters();
            Assert.assertFalse((boolean)hmsParams.containsKey("custom_property"));
            Assert.assertFalse((boolean)hmsParams.containsKey("new_prop_1"));
            Assert.assertTrue((boolean)hmsParams.containsKey("new_prop_2"));
        }
        if (Catalogs.hiveCatalog((Configuration)shell.getHiveConf(), (Properties)tableProperties)) {
            List<Record> records = HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS;
            this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, FileFormat.PARQUET, null, records);
            hmsParams = shell.metastore().getTable("default", "customers").getParameters();
            Map summary = icebergTable.currentSnapshot().summary();
            Assert.assertEquals(summary.get("total-data-files"), hmsParams.get("numFiles"));
            Assert.assertEquals(summary.get("total-records"), hmsParams.get("numRows"));
            Assert.assertEquals(summary.get("total-files-size"), hmsParams.get("totalSize"));
        }
    }

    @Test
    public void testIcebergHMSPropertiesTranslation() throws Exception {
        Assume.assumeTrue((String)"Iceberg - HMS property translation is only relevant for HiveCatalog", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE default.customers STORED BY ICEBERG TBLPROPERTIES ('%s'='%s', '%s'='%s', '%s'='%s')", "iceberg.mr.table.schema", SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA), "iceberg.mr.table.partition.spec", PartitionSpecParser.toJson((PartitionSpec)SPEC), "external.table.purge", "false"));
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)"false", icebergTable.properties().get("gc.enabled"));
        Assert.assertNull(icebergTable.properties().get("external.table.purge"));
        icebergTable.updateProperties().set("gc.enabled", "true").commit();
        Map hmsParams = shell.metastore().getTable("default", "customers").getParameters();
        Assert.assertEquals((Object)"true", hmsParams.get("external.table.purge"));
        Assert.assertNull(hmsParams.get("gc.enabled"));
    }

    @Test
    public void testDropTableWithAppendedData() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        Table icebergTable = this.testTables.loadTable(identifier);
        this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("DROP TABLE customers");
    }

    @Test
    public void testDropTableWithPurgeFalse() throws IOException, TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (t_int INT, t_string STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"external.table.purge", (Object)"FALSE")));
        String purge = (String)shell.metastore().getTable(identifier).getParameters().get("external.table.purge");
        Assert.assertEquals((Object)"FALSE", (Object)purge);
        Table icebergTable = this.testTables.loadTable(identifier);
        Path tableLocation = new Path(icebergTable.location());
        shell.executeStatement("DROP TABLE customers");
        FileSystem fs = Util.getFs((Path)tableLocation, (Configuration)shell.getHiveConf());
        Assert.assertEquals((long)1L, (long)fs.listStatus(tableLocation).length);
        Assert.assertTrue((fs.listStatus(new Path(tableLocation, "metadata")).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDropTableWithPurgeTrue() throws IOException, TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (t_int INT, t_string STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"external.table.purge", (Object)"TRUE")));
        String purge = (String)shell.metastore().getTable(identifier).getParameters().get("external.table.purge");
        Assert.assertEquals((Object)"TRUE", (Object)purge);
        Table icebergTable = this.testTables.loadTable(identifier);
        Path tableLocation = new Path(icebergTable.location());
        shell.executeStatement("DROP TABLE customers");
        FileSystem fs = Util.getFs((Path)tableLocation, (Configuration)shell.getHiveConf());
        Assert.assertFalse((boolean)fs.exists(tableLocation));
    }

    @Test
    public void testDropTableWithoutPurge() throws IOException, TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (t_int INT, t_string STRING) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        String purge = (String)shell.metastore().getTable(identifier).getParameters().get("external.table.purge");
        Assert.assertNull((Object)purge);
        Table icebergTable = this.testTables.loadTable(identifier);
        Path tableLocation = new Path(icebergTable.location());
        shell.executeStatement("DROP TABLE customers");
        FileSystem fs = Util.getFs((Path)tableLocation, (Configuration)shell.getHiveConf());
        if (HiveConf.getBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXTERNALTABLE_PURGE_DEFAULT)) {
            Assert.assertFalse((boolean)fs.exists(tableLocation));
        } else {
            Assert.assertEquals((long)1L, (long)fs.listStatus(tableLocation).length);
            Assert.assertTrue((fs.listStatus(new Path(tableLocation, "metadata")).length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDropHiveTableWithoutUnderlyingTable() throws IOException {
        Assume.assumeFalse((String)"Not relevant for HiveCatalog", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createIcebergTable(shell.getHiveConf(), identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, FileFormat.PARQUET, Collections.emptyMap(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        String tableLocation = this.testTables.locationForCreateTableSQL(identifier);
        shell.executeStatement(this.testTables.createHiveTableSQL(identifier, (Map<String, String>)ImmutableMap.of((Object)"external.table.purge", (Object)"TRUE")));
        Properties properties = new Properties();
        properties.put("name", identifier.toString());
        properties.put("location", tableLocation);
        Catalogs.dropTable((Configuration)shell.getHiveConf(), (Properties)properties);
        shell.executeStatement("DROP TABLE " + identifier);
    }

    @Test
    public void testAlterTableAddColumns() throws Exception {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        shell.executeStatement("ALTER TABLE default.customers ADD COLUMNS (newintcol int, newstringcol string COMMENT 'Column with description')");
        this.verifyAlterTableAddColumnsTests();
    }

    @Test
    public void testCreateTableWithFormatV2ThroughTableProperty() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement("CREATE EXTERNAL TABLE customers (id int, name string) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + " TBLPROPERTIES ('iceberg.catalog'='" + this.testTables.catalogName() + "', 'format-version'='2')");
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((String)"should create table using format v2", (long)2L, (long)((BaseTable)icebergTable).operations().current().formatVersion());
    }

    @Test
    public void testAlterTableAddColumnsConcurrently() throws Exception {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        Table icebergTable = this.testTables.loadTable(identifier);
        UpdateSchema updateSchema = icebergTable.updateSchema().addColumn("newfloatcol", (Type)Types.FloatType.get());
        shell.executeStatement("ALTER TABLE default.customers ADD COLUMNS (newintcol int, newstringcol string COMMENT 'Column with description')");
        try {
            updateSchema.commit();
            Assert.fail();
        }
        catch (CommitFailedException commitFailedException) {
            // empty catch block
        }
        this.verifyAlterTableAddColumnsTests();
    }

    @Test
    public void testAlterTableRenamePartitionColumn() throws Exception {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        shell.executeStatement("ALTER TABLE default.customers SET PARTITION SPEC (last_name)");
        shell.executeStatement("ALTER TABLE default.customers CHANGE last_name family_name string FIRST");
        List partitionFields = this.testTables.loadTable(identifier).spec().fields();
        Assert.assertEquals((long)1L, (long)partitionFields.size());
        Assert.assertEquals((Object)"family_name", (Object)((PartitionField)partitionFields.get(0)).name());
        shell.executeStatement("ALTER TABLE default.customers ADD COLUMNS (p1 string, p2 string)");
        shell.executeStatement("ALTER TABLE default.customers SET PARTITION SPEC (family_name, p1, p2)");
        shell.executeStatement("ALTER TABLE default.customers CHANGE p1 region string");
        shell.executeStatement("ALTER TABLE default.customers CHANGE p2 city string");
        shell.executeStatement("ALTER TABLE default.customers SET PARTITION SPEC (region, city)");
        List<Object[]> result = shell.executeStatement("DESCRIBE default.customers");
        Assert.assertArrayEquals((Object[])new String[]{"region", "IDENTITY", null}, (Object[])result.get(8));
        Assert.assertArrayEquals((Object[])new String[]{"city", "IDENTITY", null}, (Object[])result.get(9));
    }

    @Test
    public void testAlterTableReplaceColumns() throws TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)4, (String)"address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"city", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"street", (Type)Types.StringType.get())}), null)});
        this.testTables.createTable(shell, identifier.name(), schema, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        shell.executeStatement("ALTER TABLE default.customers CHANGE COLUMN customer_id customer_id bigint");
        shell.executeStatement("ALTER TABLE default.customers REPLACE COLUMNS (customer_id bigint, last_name string COMMENT 'This is last name', address struct<city:string,street:string>)");
        Table icebergTable = this.testTables.loadTable(identifier);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        List icebergSchema = HiveSchemaUtil.convert((Schema)icebergTable.schema());
        List hmsSchema = hmsTable.getSd().getCols();
        ArrayList expectedSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("customer_id", "bigint", null), new FieldSchema("last_name", "string", "This is last name"), new FieldSchema("address", "struct<city:string,street:string>", null)});
        Assert.assertEquals((Object)expectedSchema, (Object)icebergSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)hmsSchema);
    }

    @Test
    public void testAlterTableReplaceColumnsFailsWhenNotOnlyDropping() {
        String[] commands;
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)4, (String)"address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"city", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"street", (Type)Types.StringType.get())}), null)});
        this.testTables.createTable(shell, identifier.name(), schema, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        for (String command : commands = new String[]{"ALTER TABLE default.customers REPLACE COLUMNS (customer_id bigint, first_name string COMMENT 'This is first name', last_name string COMMENT 'This is last name', address struct<city:string,street:string>)", "ALTER TABLE default.customers REPLACE COLUMNS (customer_id int, first_name string, last_name string COMMENT 'This is last name', address struct<city:string,street:string>)", "ALTER TABLE default.customers REPLACE COLUMNS (customer_id int, first_name string COMMENT 'New docs', last_name string COMMENT 'This is last name', address struct<city:string,street:string>)", "ALTER TABLE default.customers REPLACE COLUMNS (customer_id int, last_name string COMMENT 'This is last name', first_name string COMMENT 'This is first name', address struct<city:string,street:string>)", "ALTER TABLE default.customers REPLACE COLUMNS (customer_id int, first_name string COMMENT 'This is first name', last_name string COMMENT 'This is last name', address struct<city:string,street:string>, new_col timestamp)", "ALTER TABLE default.customers REPLACE COLUMNS (last_name string COMMENT 'This is last name', first_name string COMMENT 'This is first name', address struct<city:string,street:string>)"}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(command)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unsupported operation to use REPLACE COLUMNS");
        }
        String command = "ALTER TABLE default.customers REPLACE COLUMNS (customer_id int, first_name string COMMENT 'This is first name', last_name string COMMENT 'This is last name', address struct<city:string,street:string>)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(command)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No schema change detected");
    }

    @Test
    public void testAlterTableChangeColumnNameAndComment() throws TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name")});
        this.testTables.createTable(shell, identifier.name(), schema, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        shell.executeStatement("ALTER TABLE default.customers CHANGE COLUMN last_name family_name string COMMENT 'This is family name'");
        Table icebergTable = this.testTables.loadTable(identifier);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        List icebergSchema = HiveSchemaUtil.convert((Schema)icebergTable.schema());
        List hmsSchema = hmsTable.getSd().getCols();
        ArrayList expectedSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("customer_id", "int", null), new FieldSchema("family_name", "string", "This is family name")});
        Assert.assertEquals((Object)expectedSchema, (Object)icebergSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)hmsSchema);
    }

    @Test
    public void testAlterTableChangeColumnTypeAndComment() throws TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name")});
        this.testTables.createTable(shell, identifier.name(), schema, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        shell.executeStatement("ALTER TABLE default.customers CHANGE COLUMN customer_id customer_id bigint COMMENT 'This is an identifier'");
        Table icebergTable = this.testTables.loadTable(identifier);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        List icebergSchema = HiveSchemaUtil.convert((Schema)icebergTable.schema());
        List hmsSchema = hmsTable.getSd().getCols();
        ArrayList expectedSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("customer_id", "bigint", "This is an identifier"), new FieldSchema("last_name", "string", "This is last name")});
        Assert.assertEquals((Object)expectedSchema, (Object)icebergSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)hmsSchema);
    }

    @Test
    public void testMetaHookWithUndefinedAlterOperationType() throws Exception {
        Assume.assumeTrue((String)"Enough to check for one type only", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        HiveIcebergMetaHook metaHook = new HiveIcebergMetaHook(shell.getHiveConf());
        EnvironmentContext environmentContext = new EnvironmentContext((Map)Maps.newHashMap());
        metaHook.preAlterTable(hmsTable, environmentContext);
        metaHook.commitAlterTable(hmsTable, environmentContext);
    }

    @Test
    public void testCommandsWithPartitionClauseThrow() {
        String[] commands;
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        for (String command : commands = new String[]{"DESCRIBE target PARTITION (last_name='Johnson')"}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(command)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Using partition spec in query is unsupported");
        }
    }

    @Test
    public void testAuthzURIMasked() throws TException, URISyntaxException, InterruptedException {
        this.testAuthzURI(true);
    }

    @Test
    public void testAuthzURIUnmasked() throws TException, URISyntaxException, InterruptedException {
        this.testAuthzURI(false);
    }

    public void testAuthzURI(boolean masked) throws TException, InterruptedException, URISyntaxException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable(target);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        shell.getHiveConf().setBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, masked);
        storageHandler.setConf(shell.getHiveConf());
        URI uriForAuth = storageHandler.getURIForAuth(hmsTable);
        String metadataLocation = storageHandler.getPathForAuth(((BaseTable)table).operations().current().metadataFileLocation(), hmsTable.getSd().getLocation());
        if (masked) {
            Assert.assertTrue((boolean)metadataLocation.startsWith("TABLE_DEFAULT_LOCATION"));
        }
        Assert.assertEquals((Object)("iceberg://" + HiveIcebergStorageHandler.encodeString((String)target.namespace().toString()) + "/" + HiveIcebergStorageHandler.encodeString((String)target.name()) + "?snapshot=" + HiveIcebergStorageHandler.encodeString((String)URI.create(metadataLocation).getPath())), (Object)uriForAuth.toString());
        Assert.assertEquals((Object)("iceberg://" + target.namespace() + "/" + target.name() + "?snapshot=" + URI.create(metadataLocation).getPath()), (Object)HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(uriForAuth.toString()));
    }

    @Test
    public void testAuthzURIWithAuthEnabledWithMetadataLocationMasked() throws HiveException {
        this.testAuthzURIWithAuthEnabledWithMetadataLocation(true);
    }

    @Test
    public void testAuthzURIWithAuthEnabledWithMetadataLocationUnmasked() throws HiveException {
        this.testAuthzURIWithAuthEnabledWithMetadataLocation(false);
    }

    public void testAuthzURIWithAuthEnabledWithMetadataLocation(boolean masked) throws HiveException {
        shell.getHiveConf().setBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, masked);
        shell.setHiveSessionValue("hive.security.authorization.enabled", true);
        shell.setHiveSessionValue("hive.security.authorization.manager", "org.apache.iceberg.mr.hive.CustomTestHiveAuthorizerFactory");
        TableIdentifier source = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table sourceTable = this.testTables.createTable(shell, source.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        String metadataFileLocation = URI.create(((BaseTable)sourceTable).operations().current().metadataFileLocation()).getPath();
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table targetTable = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, (List<Record>)ImmutableList.of(), 1, Collections.singletonMap("metadata_location", metadataFileLocation));
        HiveAuthorizer authorizer = CustomTestHiveAuthorizerFactory.getAuthorizer();
        ArgumentCaptor outputHObjsCaptor = ArgumentCaptor.forClass(List.class);
        ((HiveAuthorizer)Mockito.verify((Object)authorizer, (VerificationMode)Mockito.times((int)2))).checkPrivileges((HiveOperationType)Mockito.any(), (List)Mockito.any(), (List)outputHObjsCaptor.capture(), (HiveAuthzContext)Mockito.any());
        Optional<HivePrivilegeObject> hivePrivObject = ((List)outputHObjsCaptor.getValue()).stream().filter(hpo -> hpo.getType().equals((Object)HivePrivilegeObject.HivePrivilegeObjectType.STORAGEHANDLER_URI)).findAny();
        if (hivePrivObject.isPresent()) {
            Assert.assertEquals((Object)("iceberg://" + target.namespace() + "/" + target.name() + "?snapshot=" + metadataFileLocation), (Object)HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(hivePrivObject.get().getObjectName()));
        } else {
            Assert.fail((String)"StorageHandler auth URI is not found");
        }
    }

    @Test
    public void testAuthzURIWithAuthEnabledAndMockCommandAuthorizerMasked() throws HiveException, TException, InterruptedException {
        Assume.assumeTrue((boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        this.testAuthzURIWithAuthEnabledAndMockCommandAuthorizer(true);
    }

    @Test
    public void testAuthzURIWithAuthEnabledAndMockCommandAuthorizerUnmasked() throws HiveException, TException, InterruptedException {
        this.testAuthzURIWithAuthEnabledAndMockCommandAuthorizer(false);
    }

    public void testAuthzURIWithAuthEnabledAndMockCommandAuthorizer(boolean masked) throws HiveException, TException, InterruptedException {
        shell.getHiveConf().setBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, masked);
        shell.setHiveSessionValue("hive.security.authorization.enabled", true);
        shell.setHiveSessionValue("hive.security.authorization.manager", "org.apache.iceberg.mr.hive.CustomTestHiveAuthorizerFactory");
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        HiveAuthorizer authorizer = CustomTestHiveAuthorizerFactory.getAuthorizer();
        ArgumentCaptor outputHObjsCaptor = ArgumentCaptor.forClass(List.class);
        ((HiveAuthorizer)Mockito.verify((Object)authorizer)).checkPrivileges((HiveOperationType)Mockito.any(), (List)Mockito.any(), (List)outputHObjsCaptor.capture(), (HiveAuthzContext)Mockito.any());
        Optional<HivePrivilegeObject> hivePrivObject = ((List)outputHObjsCaptor.getValue()).stream().filter(hpo -> hpo.getType().equals((Object)HivePrivilegeObject.HivePrivilegeObjectType.STORAGEHANDLER_URI)).findAny();
        if (hivePrivObject.isPresent()) {
            org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable(target);
            HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
            storageHandler.setConf(shell.getHiveConf());
            String metadataLocation = HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(storageHandler.getPathForAuth(((BaseTable)table).operations().current().metadataFileLocation(), hmsTable.getSd().getLocation()));
            if (masked) {
                Assert.assertTrue((boolean)metadataLocation.startsWith("TABLE_DEFAULT_LOCATION"));
            }
            Assert.assertEquals((Object)("iceberg://" + target.namespace() + "/" + target.name() + "?snapshot=" + new Path(metadataLocation).getParent().toUri().getPath() + "/dummy.metadata.json"), (Object)HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(hivePrivObject.get().getObjectName()));
        } else {
            Assert.fail((String)"StorageHandler auth URI is not found");
        }
    }

    @Test
    public void testAuthzURIWithAuthEnabledMasked() throws TException, URISyntaxException, InterruptedException {
        Assume.assumeTrue((boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        this.testAuthzURIWithAuthEnabled(true);
    }

    @Test
    public void testAuthzURIWithAuthEnabledUnmasked() throws TException, URISyntaxException, InterruptedException {
        this.testAuthzURIWithAuthEnabled(false);
    }

    public void testAuthzURIWithAuthEnabled(boolean masked) throws TException, InterruptedException, URISyntaxException {
        shell.getHiveConf().setBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, masked);
        shell.setHiveSessionValue("hive.security.authorization.enabled", true);
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable(target);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        storageHandler.setConf(shell.getHiveConf());
        URI uriForAuth = storageHandler.getURIForAuth(hmsTable);
        String metadataLocation = storageHandler.getPathForAuth(((BaseTable)table).operations().current().metadataFileLocation(), hmsTable.getSd().getLocation());
        if (masked) {
            Assert.assertTrue((boolean)metadataLocation.startsWith("TABLE_DEFAULT_LOCATION"));
        }
        Assert.assertEquals((Object)("iceberg://" + target.namespace() + "/" + target.name() + "?snapshot=" + URI.create(metadataLocation).getPath()), (Object)HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(uriForAuth.toString()));
    }

    @Test
    public void testCreateTableWithMetadataLocation() throws IOException {
        Assume.assumeTrue((String)"Create with metadata location is only supported for Hive Catalog tables", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier sourceIdentifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table sourceTable = this.testTables.createTable(shell, sourceIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, Collections.emptyList(), 1, (Map<String, String>)ImmutableMap.builder().put((Object)"external.table.purge", (Object)"FALSE").build());
        this.testTables.appendIcebergTable(shell.getHiveConf(), sourceTable, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        String metadataLocation = ((BaseTable)sourceTable).operations().current().metadataFileLocation();
        shell.executeStatement("DROP TABLE " + sourceIdentifier.name());
        TableIdentifier targetIdentifier = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table targetTable = this.testTables.createTable(shell, targetIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, Collections.emptyList(), 1, (Map<String, String>)ImmutableMap.builder().put((Object)"metadata_location", (Object)metadataLocation).build());
        Assert.assertEquals((Object)metadataLocation, (Object)((BaseTable)targetTable).operations().current().metadataFileLocation());
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + targetIdentifier.name());
        List<Record> records = HiveIcebergTestUtils.valueForRow(targetTable.schema(), rows);
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, records, 0);
        this.testTables.appendIcebergTable(shell.getHiveConf(), targetTable, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        rows = shell.executeStatement("SELECT * FROM " + targetIdentifier.name());
        records = HiveIcebergTestUtils.valueForRow(targetTable.schema(), rows);
        HiveIcebergTestUtils.validateData(Stream.concat(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.stream(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.stream()).collect(Collectors.toList()), records, 0);
    }

    @Test
    public void testAlterTableWithMetadataLocation() throws IOException {
        Assume.assumeTrue((String)"Alter table with metadata location is only supported for Hive Catalog tables", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTable(shell, tableIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, Collections.emptyList(), 1, Collections.emptyMap());
        this.testTables.appendIcebergTable(shell.getHiveConf(), table, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        String firstMetadataLocation = ((BaseTable)table).operations().current().metadataFileLocation();
        this.testTables.appendIcebergTable(shell.getHiveConf(), table, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        table.refresh();
        String secondMetadataLocation = ((BaseTable)table).operations().current().metadataFileLocation();
        Assert.assertNotEquals((Object)firstMetadataLocation, (Object)secondMetadataLocation);
        shell.executeStatement("ALTER TABLE " + tableIdentifier.name() + " SET TBLPROPERTIES('metadata_location'='" + firstMetadataLocation + "')");
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + tableIdentifier.name());
        List<Record> records = HiveIcebergTestUtils.valueForRow(table.schema(), rows);
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, records, 0);
        this.testTables.appendIcebergTable(shell.getHiveConf(), table, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        rows = shell.executeStatement("SELECT * FROM " + tableIdentifier.name());
        records = HiveIcebergTestUtils.valueForRow(table.schema(), rows);
        HiveIcebergTestUtils.validateData(Stream.concat(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.stream(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.stream()).collect(Collectors.toList()), records, 0);
    }

    @Test
    public void testAlterTableWithMetadataLocationFromAnotherTable() throws IOException {
        TableIdentifier sourceIdentifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table sourceTable = this.testTables.createTable(shell, sourceIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, Collections.emptyList(), 1, (Map<String, String>)ImmutableMap.builder().put((Object)"external.table.purge", (Object)"FALSE").build());
        this.testTables.appendIcebergTable(shell.getHiveConf(), sourceTable, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        String metadataLocation = ((BaseTable)sourceTable).operations().current().metadataFileLocation();
        shell.executeStatement("DROP TABLE " + sourceIdentifier.name());
        TableIdentifier targetIdentifier = TableIdentifier.of((String[])new String[]{"default", "target"});
        this.testTables.createTable(shell, targetIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, Collections.emptyList(), 1, Collections.emptyMap());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("ALTER TABLE " + targetIdentifier.name() + " SET TBLPROPERTIES('metadata_location'='" + metadataLocation + "')")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot change iceberg table");
    }

    @Test
    public void testAlterTableToIcebergAndMetadataLocation() throws IOException {
        String tableName = "tbl";
        String createQuery = "CREATE EXTERNAL TABLE " + tableName + " (a int) STORED AS PARQUET " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of());
        shell.executeStatement(createQuery);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("ALTER TABLE " + tableName + " SET TBLPROPERTIES('storage_handler'='org.apache.iceberg.mr.hive.HiveIcebergStorageHandler','metadata_location'='asdf')")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot perform table migration to Iceberg and setting the snapshot location in one step.");
    }

    @Test
    public void testCTLT() throws TException, InterruptedException {
        Assume.assumeTrue((String)" CTLT target table must be a HiveCatalog table", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        shell.executeStatement("CREATE TABLE source(a int)");
        shell.executeStatement("insert into source values(1)");
        shell.executeStatement(String.format("CREATE TABLE dest LIKE source STORED BY ICEBERG %s %s", this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "dest"})), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        String result = shell.executeAndStringify("select a from " + TableIdentifier.of((String[])new String[]{"default", "dest"}).name());
        Assert.assertTrue((boolean)result.isEmpty());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "dest");
        StorageDescriptor sd = hmsTable.getSd();
        Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergSerDe", (Object)sd.getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergInputFormat", (Object)sd.getInputFormat());
        Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergOutputFormat", (Object)sd.getOutputFormat());
        Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergStorageHandler", hmsTable.getParameters().get("storage_handler"));
        Assert.assertEquals((Object)"ICEBERG", hmsTable.getParameters().get("table_type"));
    }

    @Test
    public void testCTLTHiveCatalogValidation() throws TException, InterruptedException {
        Assume.assumeTrue((String)" CTLT target table works on HiveCatalog table", (this.testTableType != TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        shell.executeStatement("CREATE TABLE source(a int)");
        shell.executeStatement("insert into source values(1)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(String.format("CREATE TABLE dest LIKE source STORED BY ICEBERG %s %s", this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "dest"})), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("CTLT target table must be a HiveCatalog table");
    }

    @Test
    public void testCreateTemporaryTable() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE temporary TABLE customers (customer_id BIGINT, first_name STRING, last_name STRING) STORED BY iceberg %s %s", this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(query)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Creation of temporary iceberg tables is not supported");
    }

    @Test
    public void testParquetHiveCatalogValidation() throws TException, InterruptedException, IOException {
        HashMap props = Maps.newHashMap();
        props.put("parquet.block.size", "10000");
        props.put("parquet.compression", "SNAPPY");
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), FileFormat.PARQUET, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 1, props);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable(target);
        Assert.assertEquals((Object)"SNAPPY", (Object)((String)hmsTable.getParameters().get("parquet.compression")).toUpperCase());
        Assert.assertEquals((Object)"10000", hmsTable.getParameters().get("parquet.block.size"));
        Table icebergTable = this.testTables.loadTable(target);
        Assert.assertEquals((Object)"SNAPPY", (Object)((String)icebergTable.properties().get("write.parquet.compression-codec")).toUpperCase());
        Assert.assertEquals((Object)"10000", icebergTable.properties().get("write.parquet.row-group-size-bytes"));
    }

    @Test
    public void testConcurrentIcebergCommitsAndHiveAlterTableCalls() throws Exception {
        Assume.assumeTrue((boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, SPEC, FileFormat.PARQUET, (List<Record>)ImmutableList.of());
        Table icebergTable = this.testTables.loadTable(identifier);
        icebergTable.updateProperties().set("commit.retry.num-retries", "1000000").commit();
        IMetaStoreClient realMSC = shell.getSession().getMetaStoreClient();
        IMetaStoreClient spyMSC = (IMetaStoreClient)Mockito.spy((Object)realMSC);
        shell.getSession().getSessionHive().setMSC(spyMSC);
        ((IMetaStoreClient)Mockito.doAnswer(i -> {
            Thread.sleep(3000L);
            return i.callRealMethod();
        }).when((Object)spyMSC)).alter_table((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (org.apache.hadoop.hive.metastore.api.Table)ArgumentMatchers.any(org.apache.hadoop.hive.metastore.api.Table.class), (EnvironmentContext)ArgumentMatchers.any(EnvironmentContext.class), (String)ArgumentMatchers.isNull());
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(1)));
        executorService.submit(() -> {
            try {
                this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, FileFormat.PARQUET, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        shell.executeStatement("ALTER TABLE default.customers SET TBLPROPERTIES ('dummyKey'='dummyValue')");
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
        Assert.assertEquals((String)((BaseTable)this.testTables.loadTable(identifier)).operations().current().metadataFileLocation(), (Object)HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.size(), (Object)shell.executeStatement("select count(*) from customers").get(0)[0]);
        Assert.assertEquals((Object)"dummyValue", shell.metastore().getTable(identifier).getParameters().get("dummyKey"));
        Assert.assertEquals((long)3L, (long)((BaseTable)this.testTables.loadTable(identifier)).operations().current().previousFiles().size());
    }

    @Test
    public void testCreateTableWithMetadataLocationWithoutSchema() throws IOException, TException, InterruptedException {
        Assume.assumeTrue((String)"Create with metadata location is only supported for Hive Catalog tables", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier sourceIdentifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        List<Record> records = TestHelper.generateRandomRecords(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, 4, 0L);
        Table sourceTable = this.testTables.createTable(shell, sourceIdentifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, FileFormat.PARQUET, records, 1, (Map<String, String>)ImmutableMap.builder().put((Object)"external.table.purge", (Object)"FALSE").build());
        String metadataLocation = ((BaseTable)sourceTable).operations().current().metadataFileLocation();
        shell.executeStatement("DROP TABLE " + sourceIdentifier.name());
        TableIdentifier targetIdentifier = TableIdentifier.of((String[])new String[]{"default", "target"});
        String tblProps = this.testTables.propertiesForCreateTableSQL(Collections.singletonMap("metadata_location", metadataLocation));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("CREATE EXTERNAL TABLE target (id int) STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(targetIdentifier) + tblProps)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Column names can not be provided along with metadata location.");
        shell.executeStatement("CREATE EXTERNAL TABLE target STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(targetIdentifier) + tblProps);
        Table targetIcebergTable = IcebergTableUtil.getTable((Configuration)shell.getHiveConf(), (org.apache.hadoop.hive.metastore.api.Table)shell.metastore().getTable(targetIdentifier));
        Assert.assertEquals((long)1L, (long)targetIcebergTable.spec().fields().size());
        Assert.assertEquals((Object)sourceTable.spec().fields(), (Object)targetIcebergTable.spec().fields());
        Assert.assertEquals((Object)sourceTable.schema().toString(), (Object)targetIcebergTable.schema().toString());
    }

    private void verifyAlterTableAddColumnsTests() throws Exception {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        Table icebergTable = this.testTables.loadTable(identifier);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers");
        List icebergSchema = HiveSchemaUtil.convert((Schema)icebergTable.schema());
        List hmsSchema = hmsTable.getSd().getCols();
        ArrayList expectedSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("customer_id", "bigint", null), new FieldSchema("first_name", "string", "This is first name"), new FieldSchema("last_name", "string", "This is last name"), new FieldSchema("newintcol", "int", null), new FieldSchema("newstringcol", "string", "Column with description")});
        Assert.assertEquals((Object)expectedSchema, (Object)icebergSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)hmsSchema);
    }

    @Test
    public void checkIcebergTableLocation() throws TException, InterruptedException, IOException {
        Assume.assumeTrue((String)"This test is only for hive catalog", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        String dBName = "testdb";
        String tableName = "tbl";
        String dbWithSuffix = "/" + dBName + ".db";
        String dbManagedLocation = shell.getHiveConf().get(HiveConf.ConfVars.METASTORE_WAREHOUSE.varname) + dbWithSuffix;
        String dbExternalLocation = shell.getHiveConf().get(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL.varname) + dbWithSuffix;
        Path noExistedTblPath = new Path(dbManagedLocation + "/" + tableName);
        Path expectedTblPath = new Path(dbExternalLocation + "/" + tableName);
        shell.executeStatement("CREATE DATABASE " + dBName);
        shell.executeStatement("CREATE TABLE " + dBName + "." + tableName + " (id int) STORED BY ICEBERG");
        Assert.assertFalse((boolean)noExistedTblPath.getFileSystem(shell.getHiveConf()).exists(noExistedTblPath));
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable(dBName, tableName);
        Table iceTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{dBName, tableName}));
        Path hmsTblLocation = new Path(hmsTable.getSd().getLocation());
        Assert.assertTrue((boolean)hmsTblLocation.getFileSystem(shell.getHiveConf()).exists(hmsTblLocation));
        Assert.assertTrue((boolean)expectedTblPath.toString().equalsIgnoreCase(hmsTblLocation.toString()));
        Assert.assertTrue((boolean)expectedTblPath.toString().equalsIgnoreCase(iceTable.location()));
        shell.executeStatement("DROP TABLE " + dBName + "." + tableName);
        Assert.assertTrue((boolean)hmsTblLocation.getFileSystem(shell.getHiveConf()).exists(hmsTblLocation));
    }

    @Test
    public void testSnycProperties() throws TException, InterruptedException {
        Assume.assumeTrue((String)"This test is only for hive catalog", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers_v2"});
        shell.executeStatement("CREATE TABLE customers_v2 (id int, name string) Stored by Iceberg stored as ORC TBLPROPERTIES ('format-version'='2','write.delete.mode'='copy-on-write')");
        Table icebergTable = this.testTables.loadTable(identifier);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "customers_v2");
        Map icePros = icebergTable.properties();
        Map hmsProps = hmsTable.getParameters();
        Assert.assertEquals(icePros.get("write.delete.mode"), (Object)"copy-on-write");
        Assert.assertEquals(icePros.get("write.update.mode"), (Object)"merge-on-read");
        Assert.assertEquals(icePros.get("write.merge.mode"), (Object)"merge-on-read");
        Assert.assertEquals(icePros.get("write.delete.mode"), hmsProps.get("write.delete.mode"));
        Assert.assertEquals(icePros.get("write.update.mode"), hmsProps.get("write.update.mode"));
        Assert.assertEquals(icePros.get("write.merge.mode"), hmsProps.get("write.merge.mode"));
        identifier = TableIdentifier.of((String[])new String[]{"default", "customers_v1"});
        shell.executeStatement("CREATE TABLE customers_v1 (id int, name string) Stored by Iceberg stored as ORC TBLPROPERTIES ('format-version'='1')");
        icebergTable = this.testTables.loadTable(identifier);
        hmsTable = shell.metastore().getTable("default", "customers_v1");
        icePros = icebergTable.properties();
        hmsProps = hmsTable.getParameters();
        Assert.assertEquals(icePros.get("write.delete.mode"), null);
        Assert.assertEquals(icePros.get("write.update.mode"), null);
        Assert.assertEquals(icePros.get("write.merge.mode"), null);
        Assert.assertEquals(icePros.get("write.delete.mode"), hmsProps.get("write.delete.mode"));
        Assert.assertEquals(icePros.get("write.update.mode"), hmsProps.get("write.update.mode"));
        Assert.assertEquals(icePros.get("write.merge.mode"), hmsProps.get("write.merge.mode"));
        shell.executeStatement("ALTER TABLE customers_v1 SET TBLPROPERTIES ('format-version'='2')");
        icebergTable = this.testTables.loadTable(identifier);
        hmsTable = shell.metastore().getTable("default", "customers_v1");
        icePros = icebergTable.properties();
        hmsProps = hmsTable.getParameters();
        Assert.assertEquals(icePros.get("write.delete.mode"), (Object)"merge-on-read");
        Assert.assertEquals(icePros.get("write.update.mode"), (Object)"merge-on-read");
        Assert.assertEquals(icePros.get("write.merge.mode"), (Object)"merge-on-read");
        Assert.assertEquals(icePros.get("write.delete.mode"), hmsProps.get("write.delete.mode"));
        Assert.assertEquals(icePros.get("write.update.mode"), hmsProps.get("write.update.mode"));
        Assert.assertEquals(icePros.get("write.merge.mode"), hmsProps.get("write.merge.mode"));
    }

    @Test
    public void testCreateTableWithIdentifierField() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT primary key disable novalidate, first_name STRING, last_name STRING) STORED BY iceBerg %s TBLPROPERTIES ('%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        shell.executeStatement(query);
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((String)"Should have new identifier field", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("customer_id").fieldId()}), (Object)table.schema().identifierFieldIds());
    }

    @Test
    public void testCreateTableWithMultiIdentifierFields() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT,first_name STRING, last_name STRING,primary key (customer_id, first_name) disable novalidate) STORED BY iceBerg %s TBLPROPERTIES ('%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        shell.executeStatement(query);
        Table table = this.testTables.loadTable(identifier);
        Assert.assertEquals((String)"Should have new two identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("customer_id").fieldId(), table.schema().findField("first_name").fieldId()}), (Object)table.schema().identifierFieldIds());
    }

    @Test
    public void testCreateTableFailedWithNestedIdentifierField() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers_with_nested_column (customer_id BIGINT,first_name STRING, last_name STRING, user_info STRUCT<address: STRING, phone: STRING> primary key disable novalidate) STORED BY iceBerg %s TBLPROPERTIES ('%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        Assert.assertThrows((String)"Cannot add field user_info as an identifier field: not a primitive type field", IllegalArgumentException.class, () -> shell.executeStatement(query));
    }

    private String getCurrentSnapshotForHiveCatalogTable(Table icebergTable) {
        return ((BaseMetastoreTableOperations)((BaseTable)icebergTable).operations()).currentMetadataLocation();
    }

    @Test
    public void testCreateTableWithPercentInName() throws IOException {
        Assume.assumeTrue((String)"This test is only for hive catalog", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "[|]#&%_@"});
        shell.executeStatement("CREATE EXTERNAL TABLE `[|]#&%_@` STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "', 'iceberg.mr.table.partition.spec'='" + PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()) + "', 'dummy'='test', 'external.table.purge'='TRUE', 'iceberg.catalog'='" + this.testTables.catalogName() + "')");
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.asStruct(), (Object)icebergTable.schema().asStruct());
        Assert.assertEquals((Object)PartitionSpec.unpartitioned(), (Object)icebergTable.spec());
    }
}

