/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveIcebergStorageHandlerLocalScan {
    private static TestHiveShell shell;
    private TestTables testTables;
    @Parameterized.Parameter(value=0)
    public FileFormat fileFormat;
    @Parameterized.Parameter(value=1)
    public TestTables.TestTableType testTableType;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="fileFormat={0}, catalog={1}")
    public static Collection<Object[]> parameters() {
        ArrayList testParams = Lists.newArrayList();
        for (FileFormat fileFormat : HiveIcebergStorageHandlerTestUtils.FILE_FORMATS) {
            testParams.add(new Object[]{fileFormat, TestTables.TestTableType.HIVE_CATALOG});
        }
        for (TestTables.TestTableType testTableType : TestTables.ALL_TABLE_TYPES) {
            if (TestTables.TestTableType.HIVE_CATALOG.equals((Object)testTableType)) continue;
            testParams.add(new Object[]{FileFormat.PARQUET, testTableType});
        }
        return testParams;
    }

    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        shell.stop();
    }

    @Before
    public void before() throws IOException {
        this.testTables = HiveIcebergStorageHandlerTestUtils.testTables(shell, this.testTableType, this.temp);
        HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp, "mr");
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(shell);
    }

    @Test
    public void testScanEmptyTable() throws IOException {
        Schema emptySchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"empty", (Type)Types.StringType.get())});
        this.testTables.createTable(shell, "empty", emptySchema, this.fileFormat, (List<Record>)ImmutableList.of());
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.empty");
        Assert.assertEquals((long)0L, (long)rows.size());
    }

    @Test
    public void testScanTable() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])rows.get(2));
    }

    @Test
    public void testColumnSelection() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> outOfOrderColumns = shell.executeStatement("SELECT first_name, customer_id, last_name FROM default.customers");
        Assert.assertEquals((long)3L, (long)outOfOrderColumns.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", 0L, "Brown"}, (Object[])outOfOrderColumns.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Bob", 1L, "Green"}, (Object[])outOfOrderColumns.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Trudy", 2L, "Pink"}, (Object[])outOfOrderColumns.get(2));
        List<Object[]> allButFirstColumn = shell.executeStatement("SELECT first_name, last_name FROM default.customers");
        Assert.assertEquals((long)3L, (long)allButFirstColumn.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", "Brown"}, (Object[])allButFirstColumn.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Bob", "Green"}, (Object[])allButFirstColumn.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Trudy", "Pink"}, (Object[])allButFirstColumn.get(2));
        List<Object[]> allButMiddleColumn = shell.executeStatement("SELECT customer_id, last_name FROM default.customers");
        Assert.assertEquals((long)3L, (long)allButMiddleColumn.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Brown"}, (Object[])allButMiddleColumn.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Green"}, (Object[])allButMiddleColumn.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Pink"}, (Object[])allButMiddleColumn.get(2));
        List<Object[]> allButLastColumn = shell.executeStatement("SELECT customer_id, first_name FROM default.customers");
        Assert.assertEquals((long)3L, (long)allButLastColumn.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice"}, (Object[])allButLastColumn.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob"}, (Object[])allButLastColumn.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy"}, (Object[])allButLastColumn.get(2));
    }

    @Test
    public void selectSameColumnTwice() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> columns = shell.executeStatement("SELECT first_name, first_name FROM default.customers");
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", "Alice"}, (Object[])columns.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Bob", "Bob"}, (Object[])columns.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Trudy", "Trudy"}, (Object[])columns.get(2));
    }

    @Test
    public void testCreateTableWithColumnSpecification() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        HashMap data = Maps.newHashMapWithExpectedSize((int)1);
        data.put(null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        String createSql = "CREATE EXTERNAL TABLE " + identifier + " (customer_id BIGINT, first_name STRING COMMENT 'This is first name', last_name STRING COMMENT 'This is last name') STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of());
        this.runCreateAndReadTest(identifier, createSql, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), data);
    }

    @Test
    public void testCreateTableWithColumnSpecificationPartitioned() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        ImmutableMap data = ImmutableMap.of((Object)TestHelpers.Row.of((Object[])new Object[]{"Brown"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(0)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Green"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(1)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Pink"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(2)));
        String createSql = "CREATE EXTERNAL TABLE " + identifier + " (customer_id BIGINT, first_name STRING COMMENT 'This is first name') PARTITIONED BY (last_name STRING COMMENT 'This is last name') STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of());
        this.runCreateAndReadTest(identifier, createSql, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, (Map<StructLike, List<Record>>)data);
    }

    @Test
    public void testCreatePartitionedTableByProperty() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        ImmutableMap data = ImmutableMap.of((Object)TestHelpers.Row.of((Object[])new Object[]{"Brown"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(0)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Green"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(1)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Pink"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(2)));
        String createSql = "CREATE EXTERNAL TABLE " + identifier + " STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + "TBLPROPERTIES ('iceberg.mr.table.partition.spec'='" + PartitionSpecParser.toJson((PartitionSpec)spec) + "', 'iceberg.mr.table.schema'='" + SchemaParser.toJson((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA) + "', 'iceberg.catalog'='" + this.testTables.catalogName() + "')";
        this.runCreateAndReadTest(identifier, createSql, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, (Map<StructLike, List<Record>>)data);
    }

    @Test
    public void testCreateTableWithColumnSpecificationMultilevelPartitioned() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("first_name").identity("last_name").build();
        ImmutableMap data = ImmutableMap.of((Object)TestHelpers.Row.of((Object[])new Object[]{"Alice", "Brown"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(0)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Bob", "Green"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(1)), (Object)TestHelpers.Row.of((Object[])new Object[]{"Trudy", "Pink"}), Collections.singletonList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(2)));
        String createSql = "CREATE EXTERNAL TABLE " + identifier + " (customer_id BIGINT) PARTITIONED BY (first_name STRING COMMENT 'This is first name', last_name STRING COMMENT 'This is last name') STORED BY ICEBERG " + this.testTables.locationForCreateTableSQL(identifier) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of());
        this.runCreateAndReadTest(identifier, createSql, HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, (Map<StructLike, List<Record>>)data);
    }

    @Test
    public void testArrayOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"arrayofprimitives", (Type)Types.ListType.ofRequired((int)2, (Type)Types.IntegerType.get()))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "arraytable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List expectedList = (List)records.get(i).getField("arrayofprimitives");
            for (int j = 0; j < expectedList.size(); ++j) {
                List<Object[]> queryResult = shell.executeStatement(String.format("SELECT arrayofprimitives[%d] FROM default.arraytable LIMIT 1 OFFSET %d", j, i));
                Assert.assertEquals(expectedList.get(j), (Object)queryResult.get(0)[0]);
            }
        }
    }

    @Test
    public void testArrayOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"arrayofarrays", (Type)Types.ListType.ofRequired((int)2, (Type)Types.ListType.ofRequired((int)3, (Type)Types.DateType.get())))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "arraytable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List expectedList = (List)records.get(i).getField("arrayofarrays");
            for (int j = 0; j < expectedList.size(); ++j) {
                List expectedInnerList = (List)expectedList.get(j);
                for (int k = 0; k < expectedInnerList.size(); ++k) {
                    List<Object[]> queryResult = shell.executeStatement(String.format("SELECT arrayofarrays[%d][%d] FROM default.arraytable LIMIT 1 OFFSET %d", j, k, i));
                    Assert.assertEquals((Object)expectedInnerList.get(k).toString(), (Object)queryResult.get(0)[0]);
                }
            }
        }
    }

    @Test
    public void testArrayOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"arrayofmaps", (Type)Types.ListType.ofRequired((int)2, (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.BooleanType.get())))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "arraytable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List expectedList = (List)records.get(i).getField("arrayofmaps");
            for (int j = 0; j < expectedList.size(); ++j) {
                Map expectedMap = (Map)expectedList.get(j);
                for (Map.Entry entry : expectedMap.entrySet()) {
                    List<Object[]> queryResult = shell.executeStatement(String.format("SELECT arrayofmaps[%d][\"%s\"] FROM default.arraytable LIMIT 1 OFFSET %d", j, entry.getKey(), i));
                    Assert.assertEquals(entry.getValue(), (Object)queryResult.get(0)[0]);
                }
            }
        }
    }

    @Test
    public void testArrayOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"arrayofstructs", (Type)Types.ListType.ofRequired((int)2, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"something", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"someone", (Type)Types.LongType.get()), Types.NestedField.required((int)5, (String)"somewhere", (Type)Types.StringType.get())})))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "arraytable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            List expectedList = (List)records.get(i).getField("arrayofstructs");
            for (int j = 0; j < expectedList.size(); ++j) {
                List<Object[]> queryResult = shell.executeStatement(String.format("SELECT arrayofstructs[%d].something, arrayofstructs[%d].someone, arrayofstructs[%d].somewhere FROM default.arraytable LIMIT 1 OFFSET %d", j, j, j, i));
                GenericRecord genericRecord = (GenericRecord)expectedList.get(j);
                Assert.assertEquals((Object)genericRecord.getField("something"), (Object)queryResult.get(0)[0]);
                Assert.assertEquals((Object)genericRecord.getField("someone"), (Object)queryResult.get(0)[1]);
                Assert.assertEquals((Object)genericRecord.getField("somewhere"), (Object)queryResult.get(0)[2]);
            }
        }
    }

    @Test
    public void testMapOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"mapofprimitives", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "maptable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            Map expectedMap = (Map)records.get(i).getField("mapofprimitives");
            for (Map.Entry entry : expectedMap.entrySet()) {
                List<Object[]> queryResult = shell.executeStatement(String.format("SELECT mapofprimitives[\"%s\"] FROM default.maptable LIMIT 1 OFFSET %d", entry.getKey(), i));
                Assert.assertEquals(entry.getValue(), (Object)queryResult.get(0)[0]);
            }
        }
    }

    @Test
    public void testMapOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"mapofarrays", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.ListType.ofRequired((int)4, (Type)Types.DateType.get())))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "maptable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            Map expectedMap = (Map)records.get(i).getField("mapofarrays");
            for (Map.Entry entry : expectedMap.entrySet()) {
                List expectedList = (List)entry.getValue();
                for (int j = 0; j < expectedList.size(); ++j) {
                    List<Object[]> queryResult = shell.executeStatement(String.format("SELECT mapofarrays[\"%s\"][%d] FROM maptable LIMIT 1 OFFSET %d", entry.getKey(), j, i));
                    Assert.assertEquals((Object)expectedList.get(j).toString(), (Object)queryResult.get(0)[0]);
                }
            }
        }
    }

    @Test
    public void testMapOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"mapofmaps", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StringType.get())))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "maptable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            Map expectedMap = (Map)records.get(i).getField("mapofmaps");
            for (Map.Entry entry : expectedMap.entrySet()) {
                Map expectedInnerMap = (Map)entry.getValue();
                for (Map.Entry innerEntry : expectedInnerMap.entrySet()) {
                    List<Object[]> queryResult = shell.executeStatement(String.format("SELECT mapofmaps[\"%s\"][\"%s\"] FROM maptable LIMIT 1 OFFSET %d", entry.getKey(), innerEntry.getKey(), i));
                    Assert.assertEquals(innerEntry.getValue(), (Object)queryResult.get(0)[0]);
                }
            }
        }
    }

    @Test
    public void testMapOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"mapofstructs", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"something", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"someone", (Type)Types.LongType.get()), Types.NestedField.required((int)6, (String)"somewhere", (Type)Types.StringType.get())})))});
        List<Record> records = this.testTables.createTableWithGeneratedRecords(shell, "maptable", schema, this.fileFormat, 1);
        for (int i = 0; i < records.size(); ++i) {
            Map expectedMap = (Map)records.get(i).getField("mapofstructs");
            for (Map.Entry entry : expectedMap.entrySet()) {
                List<Object[]> queryResult = shell.executeStatement(String.format("SELECT mapofstructs[\"%s\"].something, mapofstructs[\"%s\"].someone, mapofstructs[\"%s\"].somewhere FROM default.maptable LIMIT 1 OFFSET %d", entry.getKey(), entry.getKey(), entry.getKey(), i));
                GenericRecord genericRecord = (GenericRecord)entry.getValue();
                Assert.assertEquals((Object)genericRecord.getField("something"), (Object)queryResult.get(0)[0]);
                Assert.assertEquals((Object)genericRecord.getField("someone"), (Object)queryResult.get(0)[1]);
                Assert.assertEquals((Object)genericRecord.getField("somewhere"), (Object)queryResult.get(0)[2]);
            }
        }
    }

    private void runCreateAndReadTest(TableIdentifier identifier, String createSQL, Schema expectedSchema, PartitionSpec expectedSpec, Map<StructLike, List<Record>> data) throws IOException {
        shell.executeStatement(createSQL);
        Table icebergTable = this.testTables.loadTable(identifier);
        Assert.assertEquals((Object)expectedSchema.asStruct(), (Object)icebergTable.schema().asStruct());
        Assert.assertEquals((Object)expectedSpec, (Object)icebergTable.spec());
        ArrayList expected = Lists.newArrayList();
        for (StructLike partition : data.keySet()) {
            this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, this.fileFormat, partition, data.get(partition));
            expected.addAll((Collection)data.get(partition));
        }
        List<Object[]> descRows = shell.executeStatement("SELECT * FROM " + identifier);
        List<Record> records = HiveIcebergTestUtils.valueForRow(icebergTable.schema(), descRows);
        HiveIcebergTestUtils.validateData(expected, records, 0);
    }
}

