/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveIcebergStorageHandler {
    @Mock
    private Snapshot anySnapshot;
    @Mock
    private Snapshot appendSnapshot;
    @Mock
    private Snapshot deleteSnapshot;

    @Before
    public void before() {
        Mockito.when((Object)this.anySnapshot.snapshotId()).thenReturn((Object)42L);
        Mockito.lenient().when((Object)this.appendSnapshot.snapshotId()).thenReturn((Object)20L);
        HashMap summary = Maps.newHashMap();
        summary.put("added-records", "12");
        Mockito.lenient().when((Object)this.appendSnapshot.summary()).thenReturn((Object)summary);
        Mockito.when((Object)this.appendSnapshot.operation()).thenReturn((Object)"append");
        Mockito.lenient().when((Object)this.deleteSnapshot.snapshotId()).thenReturn((Object)100L);
        Mockito.when((Object)this.deleteSnapshot.operation()).thenReturn((Object)"delete");
        summary = Maps.newHashMap();
        summary.put("deleted-records", "3");
        Mockito.lenient().when((Object)this.deleteSnapshot.summary()).thenReturn((Object)summary);
    }

    @Test
    public void testHasAppendsOnlyReturnsNullWhenTableIsEmpty() {
        SnapshotContext since = new SnapshotContext(42L);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(Collections.emptyList(), since);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testHasAppendsOnlyReturnsNullWhenTableIsEmptyAndGivenSnapShotIsNull() {
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(Collections.emptyList(), null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHasAppendsOnlyTrueWhenGivenSnapShotIsNull() {
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(Collections.singletonList(this.appendSnapshot), null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHasAppendsOnlyFalseWhenGivenSnapShotIsNullButHasNonAppend() {
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(Arrays.asList(this.appendSnapshot, this.deleteSnapshot), null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testHasAppendsOnlyTrueWhenOnlyAppendsAfterGivenSnapshot() {
        SnapshotContext since = new SnapshotContext(42L);
        List<Snapshot> snapshotList = Arrays.asList(this.anySnapshot, this.appendSnapshot);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(snapshotList, since);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHasAppendsOnlyFalseWhenNotOnlyAppendsAfterGivenSnapshot() {
        SnapshotContext since = new SnapshotContext(42L);
        List<Snapshot> snapshotList = Arrays.asList(this.anySnapshot, this.appendSnapshot, this.deleteSnapshot);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(snapshotList, since);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testHasAppendsOnlyReturnsNullWhenGivenSnapshotNotInTheList() {
        SnapshotContext since = new SnapshotContext(1L);
        List<Snapshot> snapshotList = Arrays.asList(this.anySnapshot, this.appendSnapshot, this.deleteSnapshot);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Boolean result = storageHandler.hasAppendsOnly(snapshotList, since);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGetSnapshotContextsReturnsEmptyIterableWhenTableIsEmpty() {
        SnapshotContext since = new SnapshotContext(42L);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Iterable result = storageHandler.getSnapshots(Collections.emptyList(), since);
        MatcherAssert.assertThat((Object)result.iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetSnapshotContextsReturnsEmptyIterableWhenTableIsEmptyAndGivenSnapShotIsNull() {
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Iterable result = storageHandler.getSnapshots(Collections.emptyList(), null);
        MatcherAssert.assertThat((Object)result.iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetSnapshotContextsReturnsAllSnapshotsWhenGivenSnapshotIsNull() {
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Iterable result = storageHandler.getSnapshots(Arrays.asList(this.appendSnapshot, this.deleteSnapshot), null);
        List resultList = IterableUtils.toList((Iterable)result);
        MatcherAssert.assertThat((Object)resultList.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(0)).getSnapshotId(), (Matcher)CoreMatchers.is((Object)this.appendSnapshot.snapshotId()));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(0)).getOperation(), (Matcher)CoreMatchers.is((Object)SnapshotContext.WriteOperationType.APPEND));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(0)).getAddedRowCount(), (Matcher)CoreMatchers.is((Object)12L));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(0)).getDeletedRowCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(1)).getSnapshotId(), (Matcher)CoreMatchers.is((Object)this.deleteSnapshot.snapshotId()));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(1)).getOperation(), (Matcher)CoreMatchers.is((Object)SnapshotContext.WriteOperationType.DELETE));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(1)).getAddedRowCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)((SnapshotContext)resultList.get(1)).getDeletedRowCount(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testGetSnapshotContextsReturnsEmptyIterableWhenGivenSnapshotNotInTheList() {
        SnapshotContext since = new SnapshotContext(1L);
        List<Snapshot> snapshotList = Arrays.asList(this.anySnapshot, this.appendSnapshot, this.deleteSnapshot);
        HiveIcebergStorageHandler storageHandler = new HiveIcebergStorageHandler();
        Iterable result = storageHandler.getSnapshots(snapshotList, since);
        MatcherAssert.assertThat((Object)result.iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }
}

