/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHiveIcebergSnapshotOperations {
    private TestTables testTables;
    private TestHiveShell shell;
    private TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void before() throws IOException {
        this.shell = HiveIcebergStorageHandlerTestUtils.shell();
        this.temp.create();
        this.testTables = HiveIcebergStorageHandlerTestUtils.testTables(this.shell, TestTables.TestTableType.HIVE_CATALOG, this.temp);
        HiveIcebergStorageHandlerTestUtils.init(this.shell, this.testTables, this.temp);
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(this.shell);
    }

    @Test
    public void testCherryPick() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "testCherryPick"});
        this.shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (id INT) STORED BY iceberg  %s %s", identifier.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(1),(2),(3),(4)", identifier.name()));
        Table icebergTable = this.testTables.loadTable(identifier);
        long id1 = icebergTable.currentSnapshot().snapshotId();
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(5),(6)", identifier.name()));
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(7),(8)", identifier.name()));
        icebergTable.refresh();
        long id2 = icebergTable.currentSnapshot().snapshotId();
        Assert.assertNotEquals((long)id1, (long)id2);
        this.shell.executeStatement("ALTER TABLE default.testCherryPick EXECUTE ROLLBACK (" + id1 + ")");
        this.shell.executeStatement("ALTER TABLE default.testCherryPick EXECUTE CHERRY-PICK " + id2);
        List<Object[]> result = this.shell.executeStatement("SELECT COUNT(*) FROM " + identifier.name());
        Assert.assertEquals((Object)6L, (Object)result.get(0)[0]);
    }

    @Test
    public void testReplaceBranchWithSnapshot() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "testReplaceBranchWithSnapshot"});
        this.shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (id INT) STORED BY iceberg  %s %s", identifier.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(1),(2),(3),(4)", identifier.name()));
        Table icebergTable = this.testTables.loadTable(identifier);
        icebergTable.refresh();
        this.shell.executeStatement(String.format("ALTER TABLE %s create branch branch1", identifier.name()));
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(5),(6)", identifier.name()));
        icebergTable.refresh();
        long id = icebergTable.currentSnapshot().snapshotId();
        this.shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(7),(8)", identifier.name()));
        List<Object[]> result = this.shell.executeStatement("SELECT COUNT(*) FROM default.testReplaceBranchWithSnapshot.branch_branch1");
        Assert.assertEquals((Object)4L, (Object)result.get(0)[0]);
        this.shell.executeStatement(String.format("ALTER TABLE %s replace branch branch1 as of system_version %s", identifier.name(), id));
        result = this.shell.executeStatement("SELECT COUNT(*) FROM default.testReplaceBranchWithSnapshot.branch_branch1");
        Assert.assertEquals((Object)6L, (Object)result.get(0)[0]);
    }
}

