/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergSetCurrentSnapshot
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSetCurrentSnapshot() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 5);
        Assert.assertEquals((long)5L, (long)table.history().size());
        List<Object[]> result4 = shell.executeStatement("SELECT * from " + identifier.name() + " FOR SYSTEM_VERSION AS OF " + ((HistoryEntry)table.history().get(4)).snapshotId());
        List<Object[]> result3 = shell.executeStatement("SELECT * from " + identifier.name() + " FOR SYSTEM_VERSION AS OF " + ((HistoryEntry)table.history().get(3)).snapshotId());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT(" + ((HistoryEntry)table.history().get(3)).snapshotId() + ")");
        List<Object[]> currentResult = shell.executeStatement("SELECT * from " + identifier.name());
        Assert.assertEquals((long)result3.size(), (long)currentResult.size());
        HiveIcebergTestUtils.validateData(HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, currentResult), HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result3), 0);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT(" + ((HistoryEntry)table.history().get(4)).snapshotId() + ")");
        currentResult = shell.executeStatement("SELECT * from " + identifier.name());
        Assert.assertEquals((long)result4.size(), (long)currentResult.size());
        HiveIcebergTestUtils.validateData(HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, currentResult), HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result4), 0);
    }

    @Test
    public void testSetCurrentSnapshotBySnapshotRef() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 5);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " CREATE TAG test_tag");
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT('test_tag')");
        table.refresh();
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)((SnapshotRef)table.refs().get("test_tag")).snapshotId());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " CREATE BRANCH test_branch");
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT('test_branch')");
        table.refresh();
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)((SnapshotRef)table.refs().get("test_branch")).snapshotId());
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"SnapshotRef unknown_ref does not exist", () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT('unknown_ref')"));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT(" + table.currentSnapshot().snapshotId() + ")");
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)("SnapshotRef " + table.currentSnapshot().snapshotId() + " does not exist"), () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE SET_CURRENT_SNAPSHOT('" + table.currentSnapshot().snapshotId() + "')"));
    }
}

