/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHiveIcebergSerDe {
    private static final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"string_field", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void testInitialize() throws IOException, SerDeException {
        File location = this.tmp.newFolder();
        Assert.assertTrue((boolean)location.delete());
        Configuration conf = new Configuration();
        Properties properties = new Properties();
        properties.setProperty("location", location.toString());
        properties.setProperty("iceberg.catalog", "location_based_table");
        HadoopTables tables = new HadoopTables(conf);
        tables.create(schema, location.toString());
        HiveIcebergSerDe serDe = new HiveIcebergSerDe();
        serDe.initialize(conf, properties, new Properties());
        Assert.assertEquals((Object)IcebergObjectInspector.create((Schema)schema), (Object)serDe.getObjectInspector());
    }

    @Test
    public void testDeserialize() {
        HiveIcebergSerDe serDe = new HiveIcebergSerDe();
        Record record = RandomGenericData.generate(schema, 1, 0L).get(0);
        Container container = new Container();
        container.set((Object)record);
        Assert.assertEquals((Object)record, (Object)serDe.deserialize((Writable)container));
    }
}

