/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergSelects
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testScanTable() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> descRows = shell.executeStatement("SELECT first_name, customer_id FROM default.customers ORDER BY customer_id DESC");
        Assert.assertEquals((long)3L, (long)descRows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Trudy", 2L}, (Object[])descRows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Bob", 1L}, (Object[])descRows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", 0L}, (Object[])descRows.get(2));
    }

    @Test
    public void testCBOWithSelectedColumnsNonOverlapJoin() throws IOException {
        shell.setHiveSessionValue("hive.cbo.enable", true);
        this.testTables.createTable(shell, "products", PRODUCT_SCHEMA, this.fileFormat, PRODUCT_RECORDS);
        this.testTables.createTable(shell, "orders", ORDER_SCHEMA, this.fileFormat, ORDER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT o.order_id, o.customer_id, o.total, p.name FROM default.orders o JOIN default.products p ON o.product_id = p.id ORDER BY o.order_id");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{100L, 0L, 11.11, "skirt"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{101L, 0L, 22.22, "tee"}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{102L, 1L, 33.33, "watch"}, (Object[])rows.get(2));
    }

    @Test
    public void testCBOWithSelectedColumnsOverlapJoin() throws IOException {
        shell.setHiveSessionValue("hive.cbo.enable", true);
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTables.createTable(shell, "orders", ORDER_SCHEMA, this.fileFormat, ORDER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT c.first_name, o.order_id FROM default.orders o JOIN default.customers c ON o.customer_id = c.customer_id ORDER BY o.order_id DESC");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Bob", 102L}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", 101L}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Alice", 100L}, (Object[])rows.get(2));
    }

    @Test
    public void testCBOWithSelfJoin() throws IOException {
        shell.setHiveSessionValue("hive.cbo.enable", true);
        this.testTables.createTable(shell, "orders", ORDER_SCHEMA, this.fileFormat, ORDER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT o1.order_id, o1.customer_id, o1.total FROM default.orders o1 JOIN default.orders o2 ON o1.order_id = o2.order_id ORDER BY o1.order_id");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{100L, 0L, 11.11}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{101L, 0L, 22.22}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{102L, 1L, 33.33}, (Object[])rows.get(2));
    }

    @Test
    public void testJoinTablesSupportedTypes() throws IOException {
        for (int i = 0; i < SUPPORTED_TYPES.size(); ++i) {
            Type type = (Type)SUPPORTED_TYPES.get(i);
            if (type == Types.TimestampType.withZone() && this.isVectorized && this.fileFormat == FileFormat.ORC || type == Types.UUIDType.get() && this.fileFormat == FileFormat.PARQUET) continue;
            String tableName = type.typeId().toString().toLowerCase() + "_table_" + i;
            String columnName = type.typeId().toString().toLowerCase() + "_column";
            Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)columnName, (Type)type)});
            List<Record> records = TestHelper.generateRandomRecords(schema, 1, 0L);
            this.testTables.createTable(shell, tableName, schema, this.fileFormat, records);
            List<Object[]> queryResult = shell.executeStatement("select s." + columnName + ", h." + columnName + " from default." + tableName + " s join default." + tableName + " h on h." + columnName + "=s." + columnName);
            Assert.assertEquals((String)("Non matching record count for table " + tableName + " with type " + type), (long)1L, (long)queryResult.size());
        }
    }

    @Test
    public void testSelectDistinctFromTable() throws IOException {
        for (int i = 0; i < SUPPORTED_TYPES.size(); ++i) {
            Type type = (Type)SUPPORTED_TYPES.get(i);
            if (type == Types.TimestampType.withZone() && this.isVectorized && this.fileFormat == FileFormat.ORC || type == Types.UUIDType.get() && this.fileFormat == FileFormat.PARQUET) continue;
            String tableName = type.typeId().toString().toLowerCase() + "_table_" + i;
            String columnName = type.typeId().toString().toLowerCase() + "_column";
            Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)columnName, (Type)type)});
            List<Record> records = TestHelper.generateRandomRecords(schema, 4, 0L);
            int size = records.stream().map(r -> r.getField(columnName)).collect(Collectors.toSet()).size();
            this.testTables.createTable(shell, tableName, schema, this.fileFormat, records);
            List<Object[]> queryResult = shell.executeStatement("select count(distinct(" + columnName + ")) from default." + tableName);
            int distinctIds = ((Long)queryResult.get(0)[0]).intValue();
            Assert.assertEquals((String)tableName, (long)size, (long)distinctIds);
        }
    }

    @Test
    public void testSpecialCharacters() {
        TableIdentifier table = TableIdentifier.of((String[])new String[]{"default", "tar,! ,get"});
        shell.executeStatement(String.format("CREATE TABLE `%s` (id bigint, `dep,! \u662f,t` string) STORED BY ICEBERG STORED AS %s %s %s", table.name(), this.fileFormat, this.testTables.locationForCreateTableSQL(table), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        shell.executeStatement(String.format("INSERT INTO `%s` VALUES (1, 'moon'), (2, 'star')", table.name()));
        List<Object[]> result = shell.executeStatement(String.format("SELECT `dep,! \u662f,t`, id FROM `%s` ORDER BY id", table.name()));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{"moon", 1L}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"star", 2L}, (Object[])result.get(1));
    }

    @Test
    public void testScanTableCaseInsensitive() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA_WITH_UPPERCASE, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])rows.get(2));
        rows = shell.executeStatement("SELECT * FROM default.customers where CustomER_Id < 2 and first_name in ('Alice', 'Bob')");
        Assert.assertEquals((long)2L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])rows.get(1));
    }

    @Test
    public void testMultiColumnPruning() throws IOException {
        shell.setHiveSessionValue("hive.cbo.enable", true);
        Schema schema1 = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"fk", (Type)Types.StringType.get())});
        List<Record> records1 = TestHelper.RecordsBuilder.newInstance(schema1).add("fk1").build();
        this.testTables.createTable(shell, "table1", schema1, this.fileFormat, records1);
        Schema schema2 = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"fk", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"val", (Type)Types.StringType.get())});
        List<Record> records2 = TestHelper.RecordsBuilder.newInstance(schema2).add("fk1", "val").build();
        this.testTables.createTable(shell, "table2", schema2, this.fileFormat, records2);
        shell.setHiveSessionValue("hive.execution.engine", "mr");
        String query = "SELECT t2.val FROM table1 t1 JOIN table2 t2 ON t1.fk = t2.fk";
        List<Object[]> result = shell.executeStatement(query);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{"val"}, (Object[])result.get(0));
    }

    @Test
    public void testVectorizedOrcMultipleSplits() throws Exception {
        Assume.assumeTrue((this.isVectorized && FileFormat.ORC.equals((Object)this.fileFormat) ? 1 : 0) != 0);
        List<Record> records = TestHelper.generateRandomRecords(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, 20000, 0L);
        shell.setHiveSessionValue("orc.stripe.size", "210000");
        this.testTables.createTable(shell, "targettab", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, records);
        shell.setHiveSessionValue("iceberg.mr.split.size", "210000");
        List<Object[]> result = shell.executeStatement("SELECT * FROM targettab ORDER BY last_name");
        Assert.assertEquals((long)20000L, (long)result.size());
    }

    @Test
    public void testHistory() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 1);
        List<Object[]> history = shell.executeStatement("SELECT snapshot_id FROM default.source.history");
        Assert.assertEquals((long)table.history().size(), (long)history.size());
        for (int i = 0; i < table.history().size(); ++i) {
            Assert.assertEquals((Object)((HistoryEntry)table.history().get(i)).snapshotId(), (Object)history.get(i)[0]);
        }
    }
}

