/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergSchemaEvolution
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testDescribeTable() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Object[]> rows = shell.executeStatement("DESCRIBE default.customers");
        Assert.assertEquals((long)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.columns().size(), (long)rows.size());
        for (int i = 0; i < HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.columns().size(); ++i) {
            Types.NestedField field = (Types.NestedField)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA.columns().get(i);
            String comment = field.doc() == null ? "" : field.doc();
            Assert.assertArrayEquals((Object[])new Object[]{field.name(), HiveSchemaUtil.convert((Type)field.type()).getTypeName(), comment}, (Object[])rows.get(i));
        }
    }

    @Test
    public void testAlterChangeColumn() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN last_name family_name string AFTER customer_id");
        List<Object[]> result = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Brown", "Alice"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Green", "Bob"}, (Object[])result.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Pink", "Trudy"}, (Object[])result.get(2));
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN family_name family_name string FIRST");
        result = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{"Brown", 0L, "Alice"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"Green", 1L, "Bob"}, (Object[])result.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Pink", 2L, "Trudy"}, (Object[])result.get(2));
        result = shell.executeStatement("SELECT customer_id, family_name FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Brown"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Green"}, (Object[])result.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Pink"}, (Object[])result.get(2));
    }

    @Test
    public void testColumnReorders() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"c", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"d", (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)"e", (Type)Types.IntegerType.get()), Types.NestedField.required((int)6, (String)"f", (Type)Types.StringType.get())});
        this.testTables.createTable(shell, "customers", schema, this.fileFormat, (List<Record>)ImmutableList.of());
        shell.executeStatement("INSERT INTO customers VALUES (1, 'foo', 'bar', 33, 44, 'baz'), (2, 'foo2', 'bar2', 55, 66, 'baz2')");
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN a a bigint AFTER b");
        List<Object[]> result = shell.executeStatement("SELECT * FROM customers ORDER BY a");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{"foo", 1L, "bar", 33, 44, "baz"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"foo2", 2L, "bar2", 55, 66, "baz2"}, (Object[])result.get(1));
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN b b string AFTER f");
        result = shell.executeStatement("SELECT * FROM customers ORDER BY a");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{1L, "bar", 33, 44, "baz", "foo"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "bar2", 55, 66, "baz2", "foo2"}, (Object[])result.get(1));
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN e e int FIRST");
        result = shell.executeStatement("SELECT * FROM customers ORDER BY a");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{44, 1L, "bar", 33, "baz", "foo"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{66, 2L, "bar2", 55, "baz2", "foo2"}, (Object[])result.get(1));
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN d d int AFTER a");
        result = shell.executeStatement("SELECT * FROM customers ORDER BY a");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertArrayEquals((Object[])new Object[]{44, 1L, 33, "bar", "baz", "foo"}, (Object[])result.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{66, 2L, 55, "bar2", "baz2", "foo2"}, (Object[])result.get(1));
    }

    @Test
    public void testSchemaEvolutionOnVectorizedReads() throws Exception {
        Assume.assumeTrue((String)"Vectorized reads only.", (boolean)this.isVectorized);
        Schema orderSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"order_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"customer_first_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"customer_last_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"quantity", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"price", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"item", (Type)Types.StringType.get())});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(orderSchema).add(1, "Doctor", "Strange", 100, 3, "apple").add(2, "Tony", "Stark", 150, 2, "apple").add(3, "Tony", "Stark", 200, 6, "orange").add(4, "Steve", "Rogers", 100, 8, "banana").add(5, "Doctor", "Strange", 800, 7, "orange").add(6, "Thor", "Odinson", 650, 3, "apple").build();
        this.testTables.createTable(shell, "orders", orderSchema, this.fileFormat, records);
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN customer_first_name customer_first_name string AFTER customer_last_name");
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN quantity quantity int AFTER price");
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN item fruit string");
        List<Object[]> result = shell.executeStatement("SELECT customer_first_name, customer_last_name, SUM(quantity) FROM orders where price >= 3 group by customer_first_name, customer_last_name order by customer_first_name");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 4, "Doctor", "Strange", 900L, "Steve", "Rogers", 100L, "Thor", "Odinson", 650L, "Tony", "Stark", 200L);
        shell.executeStatement("ALTER TABLE orders ADD COLUMNS (nickname string)");
        shell.executeStatement("INSERT INTO orders VALUES (7, 'Romanoff', 'Natasha', 3, 250, 'apple', 'Black Widow')");
        result = shell.executeStatement("SELECT customer_first_name, customer_last_name, nickname, SUM(quantity)  FROM orders where price >= 3 group by customer_first_name, customer_last_name, nickname  order by customer_first_name");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 5, "Doctor", "Strange", null, 900L, "Natasha", "Romanoff", "Black Widow", 250L, "Steve", "Rogers", null, 100L, "Thor", "Odinson", null, 650L, "Tony", "Stark", null, 200L);
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN fruit fruit string AFTER nickname");
        result = shell.executeStatement("SELECT customer_first_name, customer_last_name, nickname, fruit, SUM(quantity)  FROM orders where price >= 3 and fruit < 'o' group by customer_first_name, customer_last_name, nickname, fruit order by customer_first_name");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 4, "Doctor", "Strange", null, "apple", 100L, "Natasha", "Romanoff", "Black Widow", "apple", 250L, "Steve", "Rogers", null, "banana", 100L, "Thor", "Odinson", null, "apple", 650L);
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN nickname nick string");
        result = shell.executeStatement("SELECT customer_first_name, nick, SUM(quantity)  FROM orders where fruit < 'o'and nick IS NOT NULL group by customer_first_name, nick");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 1, "Natasha", "Black Widow", 250L);
        shell.executeStatement("ALTER TABLE orders CHANGE COLUMN order_id order_id int AFTER customer_first_name");
        result = shell.executeStatement("SELECT customer_first_name, nick, SUM(quantity), MIN(order_id)  FROM orders where fruit < 'o'and nick IS NOT NULL group by customer_first_name, nick");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 1, "Natasha", "Black Widow", 250L, 7);
        shell.executeStatement("ALTER TABLE orders REPLACE COLUMNS (customer_last_name string, order_id int, quantity int, nick string, fruit string)");
        result = shell.executeStatement("DESCRIBE orders");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 5, "customer_last_name", "string", "", "order_id", "int", "", "quantity", "int", "", "nick", "string", "", "fruit", "string", "");
        result = shell.executeStatement("SELECT * FROM orders ORDER BY order_id");
        TestHiveIcebergSchemaEvolution.assertQueryResult(result, 7, "Strange", 1, 100, null, "apple", "Stark", 2, 150, null, "apple", "Stark", 3, 200, null, "orange", "Rogers", 4, 100, null, "banana", "Strange", 5, 800, null, "orange", "Odinson", 6, 650, null, "apple", "Romanoff", 7, 250, "Black Widow", "apple");
    }

    private static void assertQueryResult(List<Object[]> result, int expectedCount, Object ... expectedRows) {
        Assert.assertEquals((long)expectedCount, (long)result.size());
        int colCount = expectedRows.length / expectedCount;
        for (int i = 0; i < expectedCount; ++i) {
            Object[] rows = new Object[colCount];
            for (int j = 0; j < colCount; ++j) {
                rows[j] = expectedRows[i * colCount + j];
            }
            Assert.assertArrayEquals((Object[])rows, (Object[])result.get(i));
        }
    }

    @Test
    public void testDropColumnFromIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().deleteColumn("last_name").commit();
        if (this.testTableType != TestTables.TestTableType.HIVE_CATALOG) {
            shell.executeStatement("ALTER TABLE customers UPDATE COLUMNS");
        }
        Schema customerSchemaWithAge = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name")});
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "customers"}));
        List<Record> newCustomerWithAge = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAge).add(3L, "James").add(4L, "Lily").build();
        this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, this.fileFormat, null, newCustomerWithAge);
        TestHelper.RecordsBuilder customersWithAgeBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAge).add(0L, "Alice").add(1L, "Bob").add(2L, "Trudy").add(3L, "James").add(4L, "Lily");
        List<Record> customersWithAge = customersWithAgeBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAge, HiveIcebergTestUtils.valueForRow(customerSchemaWithAge, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values (5L, 'Lily'), (6L, 'Roni')");
        customersWithAgeBuilder.add(5L, "Lily").add(6L, "Roni");
        customersWithAge = customersWithAgeBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAge, HiveIcebergTestUtils.valueForRow(customerSchemaWithAge, rows), 0);
    }

    @Test
    public void testAddColumnToIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().addColumn("age", (Type)Types.LongType.get()).commit();
        if (this.testTableType != TestTables.TestTableType.HIVE_CATALOG) {
            shell.executeStatement("ALTER TABLE customers UPDATE COLUMNS");
        }
        Schema customerSchemaWithAge = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)4, (String)"age", (Type)Types.LongType.get())});
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "customers"}));
        List<Record> newCustomerWithAge = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAge).add(3L, "James", "Red", 34L).add(4L, "Lily", "Blue", null).build();
        this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, this.fileFormat, null, newCustomerWithAge);
        TestHelper.RecordsBuilder customersWithAgeBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAge).add(0L, "Alice", "Brown", null).add(1L, "Bob", "Green", null).add(2L, "Trudy", "Pink", null).add(3L, "James", "Red", 34L).add(4L, "Lily", "Blue", null);
        List<Record> customersWithAge = customersWithAgeBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAge, HiveIcebergTestUtils.valueForRow(customerSchemaWithAge, rows), 0);
        Schema customerSchemaWithAgeOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"age", (Type)Types.LongType.get())});
        TestHelper.RecordsBuilder customerWithAgeOnlyBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAgeOnly).add(0L, null).add(1L, null).add(2L, null).add(3L, 34L).add(4L, null);
        List<Record> customersWithAgeOnly = customerWithAgeOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, age FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAgeOnly, HiveIcebergTestUtils.valueForRow(customerSchemaWithAgeOnly, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values (5L, 'Lily', 'Magenta', NULL), (6L, 'Roni', 'Purple', 23L)");
        customersWithAgeBuilder.add(5L, "Lily", "Magenta", null).add(6L, "Roni", "Purple", 23L);
        customersWithAge = customersWithAgeBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAge, HiveIcebergTestUtils.valueForRow(customerSchemaWithAge, rows), 0);
        customerWithAgeOnlyBuilder.add(5L, null).add(6L, 23L);
        customersWithAgeOnly = customerWithAgeOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, age FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAgeOnly, HiveIcebergTestUtils.valueForRow(customerSchemaWithAgeOnly, rows), 0);
    }

    @Test
    public void testAddRequiredColumnToIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, null);
        icebergTable.updateSchema().allowIncompatibleChanges().addRequiredColumn("age", (Type)Types.LongType.get()).commit();
        if (this.testTableType != TestTables.TestTableType.HIVE_CATALOG) {
            shell.executeStatement("ALTER TABLE customers UPDATE COLUMNS");
        }
        Schema customerSchemaWithAge = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.required((int)4, (String)"age", (Type)Types.LongType.get())});
        shell.executeStatement("INSERT INTO default.customers values (0L, 'Lily', 'Magenta', 28L), (1L, 'Roni', 'Purple', 33L)");
        List<Record> customersWithAge = TestHelper.RecordsBuilder.newInstance(customerSchemaWithAge).add(0L, "Lily", "Magenta", 28L).add(1L, "Roni", "Purple", 33L).build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithAge, HiveIcebergTestUtils.valueForRow(customerSchemaWithAge, rows), 0);
    }

    @Test
    public void testAddColumnIntoStructToIcebergTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"person", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"first_name", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"last_name", (Type)Types.StringType.get())}))});
        List<Record> people = TestHelper.generateRandomRecords(schema, 3, 0L);
        Table icebergTable = this.testTables.createTable(shell, "people", schema, this.fileFormat, people);
        icebergTable.updateSchema().addColumn("person", "age", (Type)Types.LongType.get()).commit();
        Schema schemaWithAge = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"person", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"first_name", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"last_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"age", (Type)Types.LongType.get())}))});
        List<Record> newPeople = TestHelper.generateRandomRecords(schemaWithAge, 2, 10L);
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "people"}));
        this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, this.fileFormat, null, newPeople);
        ArrayList sortedExpected = Lists.newArrayList(people);
        sortedExpected.addAll(newPeople);
        sortedExpected.sort(Comparator.comparingLong(record -> (Long)record.get(0)));
        List<Object[]> rows = shell.executeStatement("SELECT id, person.first_name, person.last_name, person.age FROM default.people order by id");
        Assert.assertEquals((long)sortedExpected.size(), (long)rows.size());
        for (int i = 0; i < sortedExpected.size(); ++i) {
            Object[] row = rows.get(i);
            Long id = (Long)((Record)sortedExpected.get(i)).get(0);
            Record person = (Record)((Record)sortedExpected.get(i)).getField("person");
            String lastName = (String)person.getField("last_name");
            String firstName = (String)person.getField("first_name");
            Long age = null;
            if (person.getField("age") != null) {
                age = (Long)person.getField("age");
            }
            Assert.assertEquals((Object)id, (Object)((Long)row[0]));
            Assert.assertEquals((Object)firstName, (Object)((String)row[1]));
            Assert.assertEquals((Object)lastName, (Object)((String)row[2]));
            Assert.assertEquals((Object)age, (Object)row[3]);
        }
        shell.executeStatement("CREATE TABLE dummy_tbl (id bigint, first_name string, last_name string, age bigint)");
        shell.executeStatement("INSERT INTO dummy_tbl VALUES (1, 'Lily', 'Blue', 34), (2, 'Roni', 'Grey', NULL)");
        shell.executeStatement("INSERT INTO default.people SELECT id, named_struct('first_name', first_name, 'last_name', last_name, 'age', age) from dummy_tbl");
        rows = shell.executeStatement("SELECT id, person.first_name, person.last_name, person.age FROM default.people where id in (1, 2) order by id");
        Assert.assertEquals((long)2L, (long)rows.size());
        Assert.assertEquals((Object)1L, (Object)((Long)rows.get(0)[0]));
        Assert.assertEquals((Object)"Lily", (Object)((String)rows.get(0)[1]));
        Assert.assertEquals((Object)"Blue", (Object)((String)rows.get(0)[2]));
        Assert.assertEquals((Object)34L, (Object)((Long)rows.get(0)[3]));
        Assert.assertEquals((Object)2L, (Object)((Long)rows.get(1)[0]));
        Assert.assertEquals((Object)"Roni", (Object)((String)rows.get(1)[1]));
        Assert.assertEquals((Object)"Grey", (Object)((String)rows.get(1)[2]));
        Assert.assertNull((Object)rows.get(1)[3]);
    }

    @Test
    public void testMakeColumnRequiredInIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().allowIncompatibleChanges().requireColumn("last_name").commit();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values (3L, 'Lily', 'Magenta'), (4L, 'Roni', 'Purple')");
        List<Record> customerRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Alice", "Brown").add(1L, "Bob", "Green").add(2L, "Trudy", "Pink").add(3L, "Lily", "Magenta").add(4L, "Roni", "Purple").build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customerRecords, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
    }

    @Test
    public void testRemoveColumnFromIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().deleteColumn("first_name").commit();
        Schema customerSchemaWithoutFirstName = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name")});
        TestHelper.RecordsBuilder customersWithoutFirstNameBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithoutFirstName).add(0L, "Brown").add(1L, "Green").add(2L, "Pink");
        List<Record> customersWithoutFirstName = customersWithoutFirstNameBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithoutFirstName, HiveIcebergTestUtils.valueForRow(customerSchemaWithoutFirstName, rows), 0);
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Invalid table alias or column reference 'first_name'", () -> shell.executeStatement("SELECT first_name FROM default.customers"));
        shell.executeStatement("INSERT INTO default.customers values (4L, 'Magenta')");
        rows = shell.executeStatement("SELECT * FROM default.customers");
        customersWithoutFirstNameBuilder.add(4L, "Magenta");
        customersWithoutFirstName = customersWithoutFirstNameBuilder.build();
        HiveIcebergTestUtils.validateData(customersWithoutFirstName, HiveIcebergTestUtils.valueForRow(customerSchemaWithoutFirstName, rows), 0);
    }

    @Test
    public void testRemoveAndAddBackColumnFromIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().deleteColumn("first_name").commit();
        icebergTable.updateSchema().addColumn("first_name", (Type)Types.StringType.get(), "This is new first name").commit();
        icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "customers"}));
        Schema customerSchemaWithNewFirstName = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)3, (String)"first_name", (Type)Types.StringType.get(), (String)"This is the newly added first name")});
        List<Record> newCustomersWithNewFirstName = TestHelper.RecordsBuilder.newInstance(customerSchemaWithNewFirstName).add(3L, "Red", "James").build();
        this.testTables.appendIcebergTable(shell.getHiveConf(), icebergTable, this.fileFormat, null, newCustomersWithNewFirstName);
        TestHelper.RecordsBuilder customersWithNewFirstNameBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithNewFirstName).add(0L, "Brown", null).add(1L, "Green", null).add(2L, "Pink", null).add(3L, "Red", "James");
        List<Record> customersWithNewFirstName = customersWithNewFirstNameBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithNewFirstName, HiveIcebergTestUtils.valueForRow(customerSchemaWithNewFirstName, rows), 0);
        Schema customerSchemaWithNewFirstNameOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"first_name", (Type)Types.StringType.get(), (String)"This is the newly added first name")});
        TestHelper.RecordsBuilder customersWithNewFirstNameOnlyBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaWithNewFirstNameOnly).add(0L, null).add(1L, null).add(2L, null).add(3L, "James");
        List<Record> customersWithNewFirstNameOnly = customersWithNewFirstNameOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, first_name FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithNewFirstNameOnly, HiveIcebergTestUtils.valueForRow(customerSchemaWithNewFirstNameOnly, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values (4L, 'Magenta', 'Lily'), (5L, 'Purple', NULL)");
        customersWithNewFirstNameBuilder.add(4L, "Magenta", "Lily").add(5L, "Purple", null);
        customersWithNewFirstName = customersWithNewFirstNameBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithNewFirstName, HiveIcebergTestUtils.valueForRow(customerSchemaWithNewFirstName, rows), 0);
        customersWithNewFirstNameOnlyBuilder.add(4L, "Lily").add(5L, null);
        customersWithNewFirstNameOnly = customersWithNewFirstNameOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, first_name FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithNewFirstNameOnly, HiveIcebergTestUtils.valueForRow(customerSchemaWithNewFirstNameOnly, rows), 0);
    }

    @Test
    public void testRenameColumnInIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().renameColumn("last_name", "family_name").commit();
        if (this.testTableType != TestTables.TestTableType.HIVE_CATALOG) {
            shell.executeStatement("ALTER TABLE customers UPDATE COLUMNS");
        }
        Schema schemaWithFamilyName = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"family_name", (Type)Types.StringType.get(), (String)"This is last name")});
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(schemaWithFamilyName, rows), 0);
        Schema shemaWithFamilyNameOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"family_name", (Type)Types.StringType.get(), (String)"This is family name")});
        TestHelper.RecordsBuilder customersWithFamilyNameOnlyBuilder = TestHelper.RecordsBuilder.newInstance(shemaWithFamilyNameOnly).add(0L, "Brown").add(1L, "Green").add(2L, "Pink");
        List<Record> customersWithFamilyNameOnly = customersWithFamilyNameOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, family_name FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithFamilyNameOnly, HiveIcebergTestUtils.valueForRow(shemaWithFamilyNameOnly, rows), 0);
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Invalid table alias or column reference 'last_name'", () -> shell.executeStatement("SELECT last_name FROM default.customers"));
        shell.executeStatement("INSERT INTO default.customers values (3L, 'Lily', 'Magenta'), (4L, 'Roni', NULL)");
        List<Record> newCustomers = TestHelper.RecordsBuilder.newInstance(schemaWithFamilyName).add(0L, "Alice", "Brown").add(1L, "Bob", "Green").add(2L, "Trudy", "Pink").add(3L, "Lily", "Magenta").add(4L, "Roni", null).build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(newCustomers, HiveIcebergTestUtils.valueForRow(schemaWithFamilyName, rows), 0);
        customersWithFamilyNameOnlyBuilder.add(3L, "Magenta").add(4L, null);
        customersWithFamilyNameOnly = customersWithFamilyNameOnlyBuilder.build();
        rows = shell.executeStatement("SELECT customer_id, family_name FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithFamilyNameOnly, HiveIcebergTestUtils.valueForRow(shemaWithFamilyNameOnly, rows), 0);
    }

    @Test
    public void testMoveLastNameToFirstInIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().moveFirst("last_name").commit();
        Schema customerSchemaLastNameFirst = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)2, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name")});
        TestHelper.RecordsBuilder customersWithLastNameFirstBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaLastNameFirst).add("Brown", 0L, "Alice").add("Green", 1L, "Bob").add("Pink", 2L, "Trudy");
        List<Record> customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
        rows = shell.executeStatement("SELECT customer_id, first_name, last_name FROM default.customers");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values ('Magenta', 3L, 'Lily')");
        customersWithLastNameFirstBuilder.add("Magenta", 3L, "Lily");
        customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
    }

    @Test
    public void testMoveLastNameBeforeCustomerIdInIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().moveBefore("last_name", "customer_id").commit();
        Schema customerSchemaLastNameFirst = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)2, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name")});
        TestHelper.RecordsBuilder customersWithLastNameFirstBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaLastNameFirst).add("Brown", 0L, "Alice").add("Green", 1L, "Bob").add("Pink", 2L, "Trudy");
        List<Record> customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
        rows = shell.executeStatement("SELECT customer_id, first_name, last_name FROM default.customers");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values ('Magenta', 3L, 'Lily')");
        customersWithLastNameFirstBuilder.add("Magenta", 3L, "Lily");
        customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
    }

    @Test
    public void testMoveCustomerIdAfterFirstNameInIcebergTable() throws IOException {
        Table icebergTable = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        icebergTable.updateSchema().moveAfter("customer_id", "first_name").commit();
        Schema customerSchemaLastNameFirst = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)2, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name")});
        TestHelper.RecordsBuilder customersWithLastNameFirstBuilder = TestHelper.RecordsBuilder.newInstance(customerSchemaLastNameFirst).add("Alice", 0L, "Brown").add("Bob", 1L, "Green").add("Trudy", 2L, "Pink");
        List<Record> customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
        rows = shell.executeStatement("SELECT customer_id, first_name, last_name FROM default.customers");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, rows), 0);
        shell.executeStatement("INSERT INTO default.customers values ('Lily', 3L, 'Magenta')");
        customersWithLastNameFirstBuilder.add("Lily", 3L, "Magenta");
        customersWithLastNameFirst = customersWithLastNameFirstBuilder.build();
        rows = shell.executeStatement("SELECT * FROM default.customers");
        HiveIcebergTestUtils.validateData(customersWithLastNameFirst, HiveIcebergTestUtils.valueForRow(customerSchemaLastNameFirst, rows), 1);
    }

    @Test
    public void testUpdateColumnTypeInIcebergTable() throws IOException, TException, InterruptedException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"int_col", (Type)Types.IntegerType.get(), (String)"This is an integer type"), Types.NestedField.optional((int)3, (String)"float_col", (Type)Types.FloatType.get(), (String)"This is a float type"), Types.NestedField.optional((int)4, (String)"decimal_col", (Type)Types.DecimalType.of((int)2, (int)1), (String)"This is a decimal type")});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(0L, 35, Float.valueOf(22.0f), BigDecimal.valueOf(13L, 1)).add(1L, 223344, Float.valueOf(555.22f), BigDecimal.valueOf(22L, 1)).add(2L, -234, Float.valueOf(-342.0f), BigDecimal.valueOf(-12L, 1)).build();
        Table icebergTable = this.testTables.createTable(shell, "types_table", schema, this.fileFormat, records);
        Schema schemaForResultSet = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"int_col", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"float_col", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)4, (String)"decimal_col", (Type)Types.StringType.get())});
        List<Record> expectedResults = TestHelper.RecordsBuilder.newInstance(schema).add(0L, 35, 22.0, "1.3").add(1L, 223344, 555.22, "2.2").add(2L, -234, -342.0, "-1.2").build();
        List<Object[]> rows = shell.executeStatement("SELECT * FROM types_table");
        HiveIcebergTestUtils.validateData(expectedResults, HiveIcebergTestUtils.valueForRow(schemaForResultSet, rows), 0);
        org.apache.hadoop.hive.metastore.api.Table table = shell.metastore().getTable("default", "types_table");
        Assert.assertNotNull((Object)table);
        Assert.assertNotNull((Object)table.getSd());
        List columns = table.getSd().getCols();
        Assert.assertEquals((Object)"id", (Object)((FieldSchema)columns.get(0)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)columns.get(0)).getType());
        Assert.assertEquals((Object)"int_col", (Object)((FieldSchema)columns.get(1)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)columns.get(1)).getType());
        Assert.assertEquals((Object)"float_col", (Object)((FieldSchema)columns.get(2)).getName());
        Assert.assertEquals((Object)"float", (Object)((FieldSchema)columns.get(2)).getType());
        Assert.assertEquals((Object)"decimal_col", (Object)((FieldSchema)columns.get(3)).getName());
        Assert.assertEquals((Object)"decimal(2,1)", (Object)((FieldSchema)columns.get(3)).getType());
        icebergTable.updateSchema().updateColumn("int_col", (Type.PrimitiveType)Types.LongType.get()).updateColumn("float_col", (Type.PrimitiveType)Types.DoubleType.get()).updateColumn("decimal_col", (Type.PrimitiveType)Types.DecimalType.of((int)6, (int)1)).commit();
        schemaForResultSet = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"int_col", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"float_col", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)4, (String)"decimal_col", (Type)Types.StringType.get())});
        expectedResults = TestHelper.RecordsBuilder.newInstance(schema).add(0L, 35L, 22.0, "1.3").add(1L, 223344L, 555.22f, "2.2").add(2L, -234L, -342.0, "-1.2").build();
        rows = shell.executeStatement("SELECT * FROM types_table");
        HiveIcebergTestUtils.validateData(expectedResults, HiveIcebergTestUtils.valueForRow(schemaForResultSet, rows), 0);
        if (TestTables.TestTableType.HIVE_CATALOG.equals((Object)this.testTableType)) {
            table = shell.metastore().getTable("default", "types_table");
            Assert.assertNotNull((Object)table);
            Assert.assertNotNull((Object)table.getSd());
            columns = table.getSd().getCols();
            Assert.assertEquals((Object)"id", (Object)((FieldSchema)columns.get(0)).getName());
            Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)columns.get(0)).getType());
            Assert.assertEquals((Object)"int_col", (Object)((FieldSchema)columns.get(1)).getName());
            Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)columns.get(1)).getType());
            Assert.assertEquals((Object)"float_col", (Object)((FieldSchema)columns.get(2)).getName());
            Assert.assertEquals((Object)"double", (Object)((FieldSchema)columns.get(2)).getType());
            Assert.assertEquals((Object)"decimal_col", (Object)((FieldSchema)columns.get(3)).getName());
            Assert.assertEquals((Object)"decimal(6,1)", (Object)((FieldSchema)columns.get(3)).getType());
        }
        shell.executeStatement("INSERT INTO types_table values (3, 3147483647, 111.333, 12345.5), (4, -3147483648, 55, -2234.5)");
        expectedResults = TestHelper.RecordsBuilder.newInstance(schema).add(3L, 3147483647L, 111.333, "12345.5").add(4L, -3147483648L, 55.0, "-2234.5").build();
        rows = shell.executeStatement("SELECT * FROM types_table where id in(3, 4)");
        HiveIcebergTestUtils.validateData(expectedResults, HiveIcebergTestUtils.valueForRow(schemaForResultSet, rows), 0);
    }

    @Test
    public void testSchemaEvolutionForMigratedTables() {
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE customers (id bigint, first_name string, last_name string) STORED AS %s %s", this.fileFormat, this.testTables.locationForCreateTableSQL(tableIdentifier)));
        shell.executeStatement("INSERT INTO customers VALUES (11, 'Lisa', 'Truman')");
        shell.executeStatement("ALTER TABLE customers SET TBLPROPERTIES ('storage_handler'='org.apache.iceberg.mr.hive.HiveIcebergStorageHandler')");
        AssertHelpers.assertThrows((String)"issuing a replace columns operation on a migrated Iceberg table should throw", IllegalArgumentException.class, (String)"Cannot perform REPLACE COLUMNS operation on a migrated Iceberg table", () -> shell.executeStatement("ALTER TABLE customers REPLACE COLUMNS (id bigint, last_name string)"));
        AssertHelpers.assertThrows((String)"issuing a change column operation on a migrated Iceberg table should throw", IllegalArgumentException.class, (String)"Cannot perform CHANGE COLUMN operation on a migrated Iceberg table", () -> shell.executeStatement("ALTER TABLE customers CHANGE COLUMN id customer_id bigint"));
        shell.executeStatement("ALTER TABLE customers UPDATE COLUMNS");
        shell.executeStatement("ALTER TABLE customers ADD COLUMNS (date_joined timestamp)");
        shell.executeStatement("INSERT INTO customers VALUES (22, 'Mike', 'Bloomfield', from_unixtime(unix_timestamp()))");
        List<Object[]> result = shell.executeStatement("SELECT * FROM customers ORDER BY id");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNull((Object)result.get(0)[3]);
        Assert.assertNotNull((Object)result.get(1)[3]);
    }
}

