/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergRollback
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRollbackToTimestamp() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 3);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK('" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 1) + "')");
        Assert.assertEquals((long)4L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)4L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK('" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 0) + "')");
        Assert.assertEquals((long)3L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)5L, (long)table.history().size());
    }

    @Test
    public void testRollbackToVersion() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 3);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(" + ((HistoryEntry)table.history().get(1)).snapshotId() + ")");
        Assert.assertEquals((long)4L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)4L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(" + ((HistoryEntry)table.history().get(0)).snapshotId() + ")");
        Assert.assertEquals((long)3L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)5L, (long)table.history().size());
    }

    @Test
    public void testRevertRollback() throws IOException, InterruptedException {
        Assume.assumeTrue((String)"Rollback revert is only supported for tables from Hive Catalog", (boolean)this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String metadataLocationBeforeRollback = ((BaseTable)table).operations().current().metadataFileLocation();
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(" + ((HistoryEntry)table.history().get(0)).snapshotId() + ")");
        Assert.assertEquals((long)3L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)3L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " SET TBLPROPERTIES('metadata_location'='" + metadataLocationBeforeRollback + "')");
        Assert.assertEquals((long)4L, (long)shell.executeStatement("SELECT * FROM " + identifier.name()).size());
        table.refresh();
        Assert.assertEquals((long)2L, (long)table.history().size());
    }

    @Test
    public void testInvalidRollbackToTimestamp() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Cannot roll back, no valid snapshot older than", () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK('1970-01-01 00:00:00')"));
    }

    @Test
    public void testInvalidRollbackToVersion() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Cannot roll back to unknown snapshot id", () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(1111)"));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(" + ((HistoryEntry)table.history().get(0)).snapshotId() + ")");
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Cannot roll back to snapshot, not an ancestor of the current state", () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE ROLLBACK(" + ((HistoryEntry)table.history().get(1)).snapshotId() + ")"));
    }

    @Test
    public void testNonIcebergRollback() {
        shell.executeStatement("CREATE TABLE non_ice (id int)");
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"ALTER EXECUTE is not supported for table", () -> shell.executeStatement("ALTER TABLE non_ice EXECUTE ROLLBACK('2022-09-26 00:00:00')"));
    }
}

