/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHiveIcebergRestrictDataFiles
extends HiveIcebergStorageHandlerWithEngineBase {
    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell(Collections.singletonMap(HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.varname, "true"));
    }

    @Test
    public void testRestrictDataFiles() throws IOException, InterruptedException {
        TableIdentifier table1 = TableIdentifier.of((String[])new String[]{"default", "tab1"});
        this.testTables.createTableWithVersions(shell, table1.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        AssertHelpers.assertThrows((String)"Should throw exception since there are files outside the table directory", IllegalArgumentException.class, (String)"The table contains paths which are outside the table location", () -> shell.executeStatement("SELECT * FROM " + table1.name()));
        TableIdentifier table2 = TableIdentifier.of((String[])new String[]{"default", "tab2"});
        this.testTables.createTableWithVersions(shell, table2.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, null, 0);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, table2, false));
        List<Object[]> result = shell.executeStatement("SELECT * FROM " + table2.name());
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result), 0);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, table2, false));
        result = shell.executeStatement("SELECT * FROM " + table2.name());
        HiveIcebergTestUtils.validateData(ListUtils.union(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1), HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result), 0);
    }
}

