/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergPartitions
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testPartitionPruning() throws IOException {
        Schema salesSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"ss_item_sk", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"ss_sold_date_sk", (Type)Types.IntegerType.get())});
        PartitionSpec salesSpec = PartitionSpec.builderFor((Schema)salesSchema).identity("ss_sold_date_sk").build();
        Schema dimSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"d_date_sk", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"d_moy", (Type)Types.IntegerType.get())});
        List<Record> salesRecords = TestHelper.RecordsBuilder.newInstance(salesSchema).add(51, 5).add(61, 6).add(71, 7).add(81, 8).add(91, 9).build();
        List<Record> dimRecords = TestHelper.RecordsBuilder.newInstance(salesSchema).add(1, 10).add(2, 20).add(3, 30).add(4, 40).add(5, 50).build();
        Table salesTable = this.testTables.createTable(shell, "x1_store_sales", salesSchema, salesSpec, this.fileFormat, null);
        PartitionKey partitionKey = new PartitionKey(salesSpec, salesSchema);
        for (Record r : salesRecords) {
            partitionKey.partition((StructLike)r);
            this.testTables.appendIcebergTable(shell.getHiveConf(), salesTable, this.fileFormat, (StructLike)partitionKey, (List<Record>)ImmutableList.of((Object)r));
        }
        this.testTables.createTable(shell, "x1_date_dim", dimSchema, this.fileFormat, dimRecords);
        String query = "select s.ss_item_sk from x1_store_sales s, x1_date_dim d where s.ss_sold_date_sk=d.d_date_sk*2 and d.d_moy=30";
        List<Object[]> rows = shell.executeStatement(query);
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{61}, (Object[])rows.get(0));
        Assert.assertTrue((boolean)shell.executeStatement("explain " + query).stream().filter(a -> ((String)a[0]).contains("Dynamic Partitioning Event Operator")).findAny().isPresent());
    }

    @Test
    public void testPartitionedWrite() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).bucket("customer_id", 3).build();
        List<Record> records = TestHelper.generateRandomRecords(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, 4, 0L);
        Table table = this.testTables.createTable(shell, "partitioned_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
    }

    @Test
    public void testIdentityPartitionedWrite() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        List<Record> records = TestHelper.generateRandomRecords(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, 4, 0L);
        Table table = this.testTables.createTable(shell, "partitioned_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
    }

    @Test
    public void testMultilevelIdentityPartitionedWrite() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").identity("last_name").build();
        List<Record> records = TestHelper.generateRandomRecords(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, 4, 0L);
        Table table = this.testTables.createTable(shell, "partitioned_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
    }

    @Test
    public void testYearTransform() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.DateType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).year("part_field").build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, LocalDate.of(2020, 1, 21)).add(2L, LocalDate.of(2020, 1, 22)).add(3L, LocalDate.of(2019, 1, 21)).build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }

    @Test
    public void testMonthTransform() throws IOException {
        Assume.assumeTrue((String)"ORC/TIMESTAMP_INSTANT is not a supported vectorized type for Hive", (this.isVectorized && this.fileFormat == FileFormat.ORC ? 1 : 0) != 0);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.TimestampType.withZone())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).month("part_field").build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, OffsetDateTime.of(2017, 11, 22, 11, 30, 7, 0, ZoneOffset.ofHours(1))).add(2L, OffsetDateTime.of(2017, 11, 22, 11, 30, 7, 0, ZoneOffset.ofHours(2))).add(3L, OffsetDateTime.of(2017, 11, 23, 11, 30, 7, 0, ZoneOffset.ofHours(3))).build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }

    @Test
    public void testDayTransform() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.TimestampType.withoutZone())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).day("part_field").build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, LocalDateTime.of(2019, 2, 22, 9, 44, 54)).add(2L, LocalDateTime.of(2019, 2, 22, 10, 44, 54)).add(3L, LocalDateTime.of(2019, 2, 23, 9, 44, 54)).build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }

    @Test
    public void testHourTransform() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.TimestampType.withoutZone())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).hour("part_field").build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, LocalDateTime.of(2019, 2, 22, 9, 44, 54)).add(2L, LocalDateTime.of(2019, 2, 22, 10, 44, 54)).add(3L, LocalDateTime.of(2019, 2, 23, 9, 44, 54)).build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }

    @Test
    public void testBucketTransform() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("part_field", 2).build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, "Part1").add(2L, "Part2").add(3L, "Art3").build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }

    @Test
    public void testTruncateTransform() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"part_field", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("part_field", 2).build();
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(1L, "Part1").add(2L, "Part2").add(3L, "Art3").build();
        Table table = this.testTables.createTable(shell, "part_test", schema, spec, this.fileFormat, records);
        HiveIcebergTestUtils.validateData(table, records, 0);
        HiveIcebergTestUtils.validateDataWithSQL(shell, "part_test", records, "id");
    }
}

