/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestHiveIcebergMigration
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testMigrateHiveTableWithPrimitiveTypeColumnsToIceberg() throws TException, InterruptedException {
        shell.setHiveSessionValue("iceberg.mr.schema.auto.conversion", "true");
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "tbl_alltypes"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (a INT, decimal_col DECIMAL(30, 3), tinyint_col TINYINT, boolean_col BOOLEAN, float_col FLOAT, bigint_col BIGINT, double_col DOUBLE, string_col STRING, int_col INT, smallint_col SMALLINT) STORED AS %s %s %s", identifier.name(), this.fileFormat.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES(1, 13.234, 8, false, 0.7896, 543643275, 5462435243, 'wfewjifwejfoewfnvewokfow', 43221, 129 )", identifier.name()));
        this.validateMigration(identifier.name());
    }

    @Test
    public void testMigrateHiveTableWithUnsupportedPrimitiveTypeColumnToIceberg() {
        Assume.assumeTrue((this.fileFormat == FileFormat.ORC && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "tbl_unsupportedtypes"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (char_col CHAR(10)) STORED AS %s %s %s", identifier.name(), this.fileFormat.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Cannot convert hive table to iceberg that", () -> shell.executeStatement(String.format("ALTER TABLE %s Convert to iceberg", identifier.name())));
    }

    @Test
    public void testMigrateHiveTableWithComplexTypeColumnsToIceberg() throws TException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "tbl_complex"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (a int, arrayofprimitives array<string>, arrayofarrays array<array<string>>, arrayofmaps array<map<string, string>>, arrayofstructs array<struct<something:string, someone:string, somewhere:string>>, mapofprimitives map<string, string>, mapofarrays map<string, array<string>>, mapofmaps map<string, map<string, string>>, mapofstructs map<string, struct<something:string, someone:string, somewhere:string>>, structofprimitives struct<something:string, somewhere:string>, structofarrays struct<names:array<string>, birthdays:array<string>>, structofmaps struct<map1:map<string, string>, map2:map<string, string>>) STORED AS %s %s %s", identifier.name(), this.fileFormat.name(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        shell.executeStatement(String.format("INSERT INTO %s VALUES (1, array('a','b','c'), array(array('a'), array('b', 'c')), array(map('a','b'), map('e','f')), array(named_struct('something', 'a', 'someone', 'b', 'somewhere', 'c'), named_struct('something', 'e', 'someone', 'f', 'somewhere', 'g')), map('a', 'b'), map('a', array('b','c')), map('a', map('b','c')), map('a', named_struct('something', 'b', 'someone', 'c', 'somewhere', 'd')), named_struct('something', 'a', 'somewhere', 'b'), named_struct('names', array('a', 'b'), 'birthdays', array('c', 'd', 'e')), named_struct('map1', map('a', 'b'), 'map2', map('c', 'd')) )", identifier.name()));
        this.validateMigration(identifier.name());
    }

    @Test
    public void testMigrateHiveTableToIcebergWithTBLPROPERTIES() throws TException, InterruptedException {
        String tableName = "tbl";
        String createQuery = "CREATE EXTERNAL TABLE " + tableName + " (a int) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL(Collections.singletonMap("random.prop", "random"));
        shell.executeStatement(createQuery);
        shell.executeStatement("INSERT INTO " + tableName + " VALUES (1), (2), (3)");
        org.apache.hadoop.hive.metastore.api.Table hmsTable = this.validateMigration(tableName, "TBLPROPERTIES('external.table.purge'='true')");
        Assert.assertEquals((Object)"true", hmsTable.getParameters().get("external.table.purge"));
        Assert.assertEquals((Object)"random", hmsTable.getParameters().get("random.prop"));
        Table icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", tableName}));
        Assert.assertEquals((Object)"true", icebergTable.properties().get("gc.enabled"));
        AssertHelpers.assertThrows((String)"Should throw exception", IllegalArgumentException.class, (String)"Can not convert table to ICEBERG ,Table is already of that format", () -> shell.executeStatement("ALTER TABLE " + tableName + " CONVERT TO ICEBERG"));
    }

    @Test
    public void testMigrateHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl";
        String createQuery = "CREATE EXTERNAL TABLE " + tableName + " (a int) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of());
        shell.executeStatement(createQuery);
        shell.executeStatement("INSERT INTO " + tableName + " VALUES (1), (2), (3)");
        this.validateMigration(tableName);
    }

    @Test
    public void testMigratePartitionedHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_part";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) PARTITIONED BY (b string) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa') VALUES (1), (2), (3)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='bbb') VALUES (4), (5)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ccc') VALUES (6)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ddd') VALUES (7), (8), (9), (10)");
        this.validateMigration(tableName);
    }

    @Test
    public void testMigratePartitionedBucketedHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_part_bucketed";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) PARTITIONED BY (b string) clustered by (a) INTO 2 BUCKETS STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa') VALUES (1), (2), (3)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='bbb') VALUES (4), (5)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ccc') VALUES (6)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ddd') VALUES (7), (8), (9), (10)");
        this.validateMigration(tableName);
    }

    @Test
    public void testRollbackMigrateHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_rollback";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " VALUES (1), (2), (3)");
        this.validateMigrationRollback(tableName);
    }

    @Test
    public void testRollbackMigratePartitionedHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_rollback";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) PARTITIONED BY (b string) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa') VALUES (1), (2), (3)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='bbb') VALUES (4), (5)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ccc') VALUES (6)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ddd') VALUES (7), (8), (9), (10)");
        this.validateMigrationRollback(tableName);
    }

    @Test
    public void testRollbackMultiPartitionedHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_rollback";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) PARTITIONED BY (b string, c int) STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa', c='111') VALUES (1), (2), (3)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='bbb', c='111') VALUES (4), (5)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa', c='222') VALUES (6)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ccc', c='333') VALUES (7), (8), (9), (10)");
        this.validateMigrationRollback(tableName);
    }

    @Test
    public void testRollbackMigratePartitionedBucketedHiveTableToIceberg() throws TException, InterruptedException {
        String tableName = "tbl_part_bucketed";
        shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) PARTITIONED BY (b string) clustered by (a) INTO 2 BUCKETS STORED AS " + this.fileFormat.name() + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='aaa') VALUES (1), (2), (3)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='bbb') VALUES (4), (5)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ccc') VALUES (6)");
        shell.executeStatement("INSERT INTO " + tableName + " PARTITION (b='ddd') VALUES (7), (8), (9), (10)");
        this.validateMigrationRollback(tableName);
    }

    @Test
    public void testMigrationFailsForUnsupportedSourceFileFormat() {
        Assume.assumeTrue((this.fileFormat == FileFormat.ORC && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        String tableName = "tbl_unsupported";
        ImmutableList formats = ImmutableList.of((Object)"TEXTFILE", (Object)"JSONFILE", (Object)"RCFILE", (Object)"SEQUENCEFILE");
        formats.forEach(format -> {
            shell.executeStatement("CREATE EXTERNAL TABLE " + tableName + " (a int) STORED AS " + format + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
            shell.executeStatement("INSERT INTO " + tableName + " VALUES (1), (2), (3)");
            AssertHelpers.assertThrows((String)("Migrating a " + format + " table to Iceberg should have thrown an exception."), IllegalArgumentException.class, (String)"Cannot convert hive table to iceberg with input format: ", () -> shell.executeStatement("ALTER TABLE " + tableName + " Convert to iceberg"));
            shell.executeStatement("DROP TABLE " + tableName);
        });
    }

    @Test
    public void testMigrationFailsForManagedTable() {
        Assume.assumeTrue((this.fileFormat == FileFormat.ORC && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        String tableName = "tbl_unsupported";
        shell.executeStatement("CREATE MANAGED TABLE " + tableName + " (a int) STORED AS " + this.fileFormat + " " + this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", tableName})) + this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of()));
        shell.executeStatement("INSERT INTO " + tableName + " VALUES (1), (2), (3)");
        AssertHelpers.assertThrows((String)"Migrating a managed table to Iceberg should have thrown an exception.", IllegalArgumentException.class, (String)"Converting non-external, temporary or transactional hive table to iceberg", () -> shell.executeStatement("ALTER TABLE " + tableName + " convert to iceberg"));
    }

    private org.apache.hadoop.hive.metastore.api.Table validateMigration(String tableName) throws TException, InterruptedException {
        return this.validateMigration(tableName, null);
    }

    private org.apache.hadoop.hive.metastore.api.Table validateMigration(String tableName, String tblProperties) throws TException, InterruptedException {
        List<Object[]> originalResult = shell.executeStatement("SELECT * FROM " + tableName + " ORDER BY a");
        String stmt = "ALTER TABLE " + tableName + " CONVERT TO ICEBERG";
        if (tblProperties != null) {
            stmt = stmt + " " + tblProperties;
        }
        shell.executeStatement(stmt);
        List<Object[]> alterResult = shell.executeStatement("SELECT * FROM " + tableName + " ORDER BY a");
        Assert.assertEquals((long)originalResult.size(), (long)alterResult.size());
        for (int i = 0; i < originalResult.size(); ++i) {
            Assert.assertEquals((long)originalResult.get(i).length, (long)alterResult.get(i).length);
            for (int j = 0; j < originalResult.get(i).length; ++j) {
                Assert.assertEquals((Object)String.valueOf(originalResult.get(i)[j]), (Object)String.valueOf(alterResult.get(i)[j]));
            }
        }
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", tableName);
        this.validateSd(hmsTable, "iceberg");
        this.validateTblProps(hmsTable, true);
        this.validatePartitions(tableName);
        return hmsTable;
    }

    private void validatePartitions(String tableName) throws TException, InterruptedException {
        List partitions = (List)shell.metastore().run(client -> client.listPartitionNames("default", tableName, (short)-1));
        Assert.assertTrue((boolean)partitions.isEmpty());
    }

    private void validateMigrationRollback(String tableName) throws TException, InterruptedException {
        List<Object[]> originalResult = shell.executeStatement("SELECT * FROM " + tableName + " ORDER BY a");
        MockedStatic mockedTableUtil = Mockito.mockStatic(HiveTableUtil.class);
        try {
            mockedTableUtil.when(() -> HiveTableUtil.importFiles((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (PartitionSpecProxy)((PartitionSpecProxy)ArgumentMatchers.any(PartitionSpecProxy.class)), (List)ArgumentMatchers.anyList(), (Properties)((Properties)ArgumentMatchers.any(Properties.class)), (Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenThrow(new Throwable[]{new MetaException()});
            try {
                shell.executeStatement("ALTER TABLE " + tableName + " CONVERT TO ICEBERG");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Error occurred during hive table migration to iceberg."));
                org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", tableName);
                this.validateSd(hmsTable, this.fileFormat.name());
                this.validateTblProps(hmsTable, false);
                shell.executeStatement("MSCK REPAIR TABLE " + tableName);
                List<Object[]> alterResult = shell.executeStatement("SELECT * FROM " + tableName + " ORDER BY a");
                Assert.assertEquals((long)originalResult.size(), (long)alterResult.size());
                for (int i = 0; i < originalResult.size(); ++i) {
                    Assert.assertTrue((boolean)Arrays.equals(originalResult.get(i), alterResult.get(i)));
                }
                if (mockedTableUtil != null) {
                    mockedTableUtil.close();
                }
                return;
            }
            Assert.fail((String)"Alter table operations should have thrown an exception.");
        }
        finally {
            if (mockedTableUtil != null) {
                try {
                    mockedTableUtil.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void validateSd(org.apache.hadoop.hive.metastore.api.Table hmsTable, String format) {
        StorageDescriptor sd = hmsTable.getSd();
        Assert.assertTrue((boolean)sd.getSerdeInfo().getSerializationLib().toLowerCase().contains(format.toLowerCase()));
        Assert.assertTrue((boolean)sd.getInputFormat().toLowerCase().contains(format.toLowerCase()));
        Assert.assertTrue((boolean)sd.getOutputFormat().toLowerCase(Locale.ROOT).contains(format.toLowerCase()));
    }

    private void validateTblProps(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean migrationSucceeded) {
        String migratedProp = (String)hmsTable.getParameters().get("MIGRATED_TO_ICEBERG");
        String tableTypeProp = (String)hmsTable.getParameters().get("table_type");
        String nameMappingProp = (String)hmsTable.getParameters().get("schema.name-mapping.default");
        if (migrationSucceeded) {
            Assert.assertTrue((boolean)Boolean.parseBoolean(migratedProp));
            Assert.assertEquals((Object)"iceberg".toUpperCase(), (Object)tableTypeProp);
            Assert.assertTrue((nameMappingProp != null && !nameMappingProp.isEmpty() ? 1 : 0) != 0);
        } else {
            Assert.assertNull((Object)migratedProp);
            Assert.assertNotEquals((Object)"iceberg".toUpperCase(), (Object)tableTypeProp);
            Assert.assertNull((Object)nameMappingProp);
        }
    }
}

