/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergInserts
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testSortedInsert() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "sort_table"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("id", NullOrder.NULLS_FIRST)).desc("data", NullOrder.NULLS_LAST)).build();
        this.testTables.createTable(shell, identifier.name(), schema, order, PartitionSpec.unpartitioned(), this.fileFormat, (List<Record>)ImmutableList.of(), this.formatVersion, (Map<String, String>)ImmutableMap.of());
        shell.executeStatement(String.format("INSERT INTO TABLE %s VALUES (4, 'a'), (1, 'a'), (3, 'a'), (2, 'a'), (null, 'a'), (3, 'b'), (3, null)", identifier.name()));
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(schema).add(null, "a").add(1, "a").add(2, "a").add(3, "b").add(3, "a").add(3, null).add(4, "a").build();
        List<Object[]> result = shell.executeStatement(String.format("SELECT * FROM %s", identifier.name()));
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(schema, result));
    }

    @Test
    public void testSortedAndTransformedInsert() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "sort_table"});
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).asc((Term)Expressions.bucket((String)"customer_id", (int)2), NullOrder.NULLS_FIRST).desc((Term)Expressions.truncate((String)"first_name", (int)4), NullOrder.NULLS_LAST).asc("last_name", NullOrder.NULLS_LAST)).build();
        this.testTables.createTable(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, order, PartitionSpec.unpartitioned(), this.fileFormat, (List<Record>)ImmutableList.of(), this.formatVersion, (Map<String, String>)ImmutableMap.of());
        StringBuilder insertQuery = new StringBuilder().append(String.format("INSERT INTO %s VALUES ", identifier.name()));
        HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2.forEach(record -> insertQuery.append("(").append(record.get(0)).append(",'").append(record.get(1)).append("','").append(record.get(2)).append("'),"));
        insertQuery.setLength(insertQuery.length() - 1);
        shell.executeStatement(insertQuery.toString());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(2L, "Susan", "Morrison").add(1L, "Sharon", "Taylor").add(1L, "Joanna", "Pierce").add(2L, "Joanna", "Silver").add(2L, "Jake", "Donnel").add(2L, "Bob", "Silver").add(3L, "Trudy", "Henderson").add(3L, "Trudy", "Johnson").add(3L, "Blake", "Burr").build();
        List<Object[]> result = shell.executeStatement(String.format("SELECT * FROM %s", identifier.name()));
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result));
    }

    @Test
    public void testSortedAndTransformedInsertIntoPartitionedTable() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "tbl_bucketed"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c", (Type)Types.IntegerType.get())});
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).desc("c", NullOrder.NULLS_FIRST)).asc((Term)Expressions.truncate((String)"b", (int)1))).build();
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)schema).bucket("b", 2).build();
        this.testTables.createTable(shell, identifier.name(), schema, order, partitionSpec, this.fileFormat, (List<Record>)ImmutableList.of(), this.formatVersion, (Map<String, String>)ImmutableMap.of());
        shell.executeStatement(String.format("INSERT INTO %s VALUES (1, 'EUR', 10), (5, 'HUF', 30), (2, 'EUR', 10), (8, 'PLN', 20), (6, 'USD', null)", identifier.name()));
        List<Object[]> result = shell.executeStatement(String.format("SELECT * FROM %s", identifier.name()));
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(schema).add(1, "EUR", 10).add(2, "EUR", 10).add(6, "USD", null).add(5, "HUF", 30).add(8, "PLN", 20).build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(schema, result));
    }

    @Test
    public void testInsert() throws IOException {
        Table table = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, (List<Record>)ImmutableList.of());
        StringBuilder query = new StringBuilder().append("INSERT INTO customers VALUES ");
        HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.forEach(record -> query.append("(").append(record.get(0)).append(",'").append(record.get(1)).append("','").append(record.get(2)).append("'),"));
        query.setLength(query.length() - 1);
        shell.executeStatement(query.toString());
        HiveIcebergTestUtils.validateData(table, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 0);
    }

    @Test
    public void testInsertIntoORCFile() throws IOException {
        Assume.assumeTrue((String)"Testing the create table ... stored as ORCFILE syntax is enough for a single scenario.", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.fileFormat == FileFormat.ORC ? 1 : 0) != 0);
        shell.executeStatement("CREATE TABLE t2(c0 DOUBLE , c1 DOUBLE , c2 DECIMAL) STORED BY ICEBERG STORED AS ORCFILE");
        shell.executeStatement("INSERT INTO t2(c1, c0) VALUES(0.1803113419993464, 0.9381388537256228)");
        List<Object[]> results = shell.executeStatement("SELECT * FROM t2");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)0.9381388537256228, (Object)results.get(0)[0]);
        Assert.assertEquals((Object)0.1803113419993464, (Object)results.get(0)[1]);
        Assert.assertEquals(null, (Object)results.get(0)[2]);
    }

    @Test
    public void testStoredByIcebergInTextFile() {
        Assume.assumeTrue((String)"Testing the create table ... stored as TEXTFILE syntax is enough for a single scenario.", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.fileFormat == FileFormat.ORC ? 1 : 0) != 0);
        AssertHelpers.assertThrows((String)"Create table should not work with textfile", IllegalArgumentException.class, (String)"Unsupported fileformat", () -> shell.executeStatement("CREATE TABLE IF NOT EXISTS t2(c0 DOUBLE , c1 DOUBLE , c2 DECIMAL) STORED BY ICEBERG STORED AS TEXTFILE"));
    }

    @Test
    public void testInsertSupportedTypes() throws IOException {
        for (int i = 0; i < SUPPORTED_TYPES.size(); ++i) {
            Type type = (Type)SUPPORTED_TYPES.get(i);
            if (type == Types.UUIDType.get() && this.fileFormat == FileFormat.PARQUET || type == Types.BinaryType.get() || type.equals(Types.FixedType.ofLength((int)5))) continue;
            String columnName = type.typeId().toString().toLowerCase() + "_column";
            Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)columnName, (Type)type)});
            List<Record> expected = TestHelper.generateRandomRecords(schema, 5, 0L);
            Table table = this.testTables.createTable(shell, type.typeId().toString().toLowerCase() + "_table_" + i, schema, PartitionSpec.unpartitioned(), this.fileFormat, expected);
            HiveIcebergTestUtils.validateData(table, expected, 0);
        }
    }

    @Test
    public void testInsertFromSelect() throws IOException {
        Table table = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("INSERT INTO customers SELECT * FROM customers");
        ArrayList records = Lists.newArrayList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        records.addAll(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        HiveIcebergTestUtils.validateData(table, (List<Record>)records, 0);
    }

    @Test
    public void testInsertOverwriteNonPartitionedTable() throws IOException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, (List<Record>)ImmutableList.of());
        this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("INSERT OVERWRITE TABLE target SELECT * FROM source");
        HiveIcebergTestUtils.validateData(table, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 0);
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Mike", "Taylor").add(1L, "Christy", "Hubert").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, true));
        HiveIcebergTestUtils.validateData(table, newRecords, 0);
        shell.executeStatement("INSERT OVERWRITE TABLE target SELECT * FROM source WHERE FALSE");
        HiveIcebergTestUtils.validateData(table, (List<Record>)ImmutableList.of(), 0);
    }

    @Test
    public void testInsertOverwritePartitionedTable() throws IOException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, (List<Record>)ImmutableList.of());
        ArrayList expected = Lists.newArrayList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        expected.add(TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(8L, "Sue", "Green").build().get(0));
        shell.executeStatement(this.testTables.getInsertQuery(expected, target, true));
        HiveIcebergTestUtils.validateData(table, (List<Record>)expected, 0);
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Mike", "Brown").add(1L, "Christy", "Green").add(3L, "Bill", "Purple").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, true));
        expected = Lists.newArrayList(newRecords);
        expected.add(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(2));
        HiveIcebergTestUtils.validateData(table, (List<Record>)expected, 0);
        shell.executeStatement("INSERT OVERWRITE TABLE target SELECT * FROM target WHERE FALSE");
        HiveIcebergTestUtils.validateData(table, (List<Record>)expected, 0);
    }

    @Test
    public void testInsertOverwriteBucketPartitionedTableThrowsError() {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).bucket("last_name", 16).identity("customer_id").build();
        this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, (List<Record>)ImmutableList.of());
        AssertHelpers.assertThrows((String)"IOW should not work on bucket partitioned table", IllegalArgumentException.class, (String)"Cannot perform insert overwrite query on bucket partitioned Iceberg table", () -> shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, target, true)));
    }

    @Test
    public void testInsertOverwriteWithPartitionEvolutionThrowsError() throws IOException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("ALTER TABLE target SET PARTITION SPEC(TRUNCATE(2, last_name))");
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Mike", "Taylor").add(1L, "Christy", "Hubert").build();
        AssertHelpers.assertThrows((String)"IOW should not work on tables with partition evolution", IllegalArgumentException.class, (String)"Cannot perform insert overwrite query on Iceberg table where partition evolution happened.", () -> shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, true)));
    }

    @Test
    public void testInsertFromSelectWithOrderBy() throws IOException {
        Table table = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("INSERT INTO customers SELECT * FROM customers ORDER BY customer_id");
        ArrayList records = Lists.newArrayList(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        records.addAll(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        HiveIcebergTestUtils.validateData(table, (List<Record>)records, 0);
    }

    @Test
    public void testInsertFromSelectWithProjection() throws IOException {
        Table table = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, (List<Record>)ImmutableList.of());
        this.testTables.createTable(shell, "orders", ORDER_SCHEMA, this.fileFormat, ORDER_RECORDS);
        shell.executeStatement("INSERT INTO customers (customer_id, last_name) SELECT distinct(customer_id), 'test' FROM orders");
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, null, "test").add(1L, null, "test").build();
        HiveIcebergTestUtils.validateData(table, expected, 0);
    }

    @Test
    public void testInsertUsingSourceTableWithSharedColumnsNames() throws IOException {
        List<Record> records = HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS;
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        this.testTables.createTable(shell, "source_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, records);
        Table table = this.testTables.createTable(shell, "target_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, (List<Record>)ImmutableList.of());
        shell.executeStatement("INSERT INTO target_customers SELECT customer_id, 'Sam', last_name FROM source_customers");
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)records.size());
        records.forEach(r -> {
            Record copy = r.copy();
            copy.setField("first_name", (Object)"Sam");
            expected.add(copy);
        });
        HiveIcebergTestUtils.validateData(table, (List<Record>)expected, 0);
    }

    @Test
    public void testInsertFromJoiningTwoIcebergTables() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").build();
        this.testTables.createTable(shell, "source_customers_1", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTables.createTable(shell, "source_customers_2", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        Table table = this.testTables.createTable(shell, "target_customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, (List<Record>)ImmutableList.of());
        shell.executeStatement("INSERT INTO target_customers SELECT a.customer_id, b.first_name, a.last_name FROM source_customers_1 a JOIN source_customers_2 b ON a.last_name = b.last_name");
        HiveIcebergTestUtils.validateData(table, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 0);
    }

    @Test
    public void testMultiTableInsert() throws IOException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        Schema target1Schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get())});
        Schema target2Schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"last_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"customer_id", (Type)Types.LongType.get())});
        List<Record> target1Records = TestHelper.RecordsBuilder.newInstance(target1Schema).add(0L, "Alice").add(1L, "Bob").add(2L, "Trudy").build();
        List<Record> target2Records = TestHelper.RecordsBuilder.newInstance(target2Schema).add("Brown", 0L).add("Green", 1L).add("Pink", 2L).build();
        Table target1 = this.testTables.createTable(shell, "target1", target1Schema, this.fileFormat, (List<Record>)ImmutableList.of());
        Table target2 = this.testTables.createTable(shell, "target2", target2Schema, this.fileFormat, (List<Record>)ImmutableList.of());
        shell.executeStatement("FROM customers INSERT INTO target1 SELECT customer_id, first_name INSERT INTO target2 SELECT last_name, customer_id");
        HiveIcebergTestUtils.validateData(target1, target1Records, 0);
        HiveIcebergTestUtils.validateData(target2, target2Records, 1);
        this.testTables.truncateIcebergTable(target1);
        this.testTables.truncateIcebergTable(target2);
        shell.executeStatement("FROM customers INSERT INTO target1 SELECT customer_id, first_name ORDER BY first_name INSERT INTO target2 SELECT last_name, customer_id ORDER BY last_name");
        HiveIcebergTestUtils.validateData(target1, target1Records, 0);
        HiveIcebergTestUtils.validateData(target2, target2Records, 1);
    }

    @Test
    public void testStructMapWithNull() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"mapofstructs", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"something", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"someone", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"somewhere", (Type)Types.StringType.get())})))});
        List<Record> records = TestHelper.RecordsBuilder.newInstance(schema).add(0L, ImmutableMap.of()).build();
        this.testTables.createTable(shell, "mapwithnull", schema, this.fileFormat, records);
        List<Object[]> results = shell.executeStatement("select mapofstructs['context'].someone FROM mapwithnull");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertNull((Object)results.get(0)[0]);
    }

    @Test
    public void testWriteWithDefaultWriteFormat() {
        Assume.assumeTrue((String)"Testing the default file format is enough for a single scenario.", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.fileFormat == FileFormat.ORC ? 1 : 0) != 0);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE %s (id bigint, name string) STORED BY '%s' %s %s", identifier, HiveIcebergStorageHandler.class.getName(), this.testTables.locationForCreateTableSQL(identifier), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of())));
        shell.executeStatement(String.format("INSERT INTO %s VALUES (10, 'Linda')", identifier));
        List<Object[]> results = shell.executeStatement(String.format("SELECT * FROM %s", identifier));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)10L, (Object)results.get(0)[0]);
        Assert.assertEquals((Object)"Linda", (Object)results.get(0)[1]);
    }

    @Test
    public void testInsertEmptyResultSet() throws IOException {
        Table source = this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, (List<Record>)ImmutableList.of());
        Table target = this.testTables.createTable(shell, "target", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, (List<Record>)ImmutableList.of());
        shell.executeStatement("INSERT INTO target SELECT * FROM source");
        HiveIcebergTestUtils.validateData(target, (List<Record>)ImmutableList.of(), 0);
        this.testTables.appendIcebergTable(shell.getHiveConf(), source, this.fileFormat, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement("INSERT INTO target SELECT * FROM source WHERE first_name = 'Nobody'");
        HiveIcebergTestUtils.validateData(target, (List<Record>)ImmutableList.of(), 0);
    }

    @Test
    public void testInsertOverwriteOnEmptyV1Table() throws IOException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "ABC", "DBAK").add(1L, "XYZ", "RDBS").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, false));
        shell.executeStatement("ALTER TABLE target SET PARTITION SPEC(TRUNCATE(2, last_name))");
        newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(2L, "Mike", "Taylor").add(3L, "Christy", "Hubert").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, false));
        shell.executeStatement("TRUNCATE TABLE target");
        newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Mike", "Taylor").add(3L, "ABC", "DBAK").add(4L, "APL", "DBAM").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, true));
        HiveIcebergTestUtils.validateData(table, newRecords, 0);
    }

    @Test
    public void testInsertOverwriteOnEmptyV2Table() throws IOException {
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        ImmutableMap opTypes = ImmutableMap.of((Object)"write.delete.mode", (Object)"merge-on-read", (Object)"write.merge.mode", (Object)"merge-on-read", (Object)"write.update.mode", (Object)"merge-on-read");
        Table table = this.testTables.createTable(shell, target.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2, (Map<String, String>)opTypes);
        List<Record> newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(3L, "ABC", "DBAK").add(4L, "XYZ", "RDBS").add(5L, "CBO", "HIVE").add(6L, "HADOOP", "HDFS").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, false));
        shell.executeStatement("update target set first_name='WXYZ' where customer_id=1");
        shell.executeStatement("delete from target where customer_id%2=0");
        shell.executeStatement("ALTER TABLE target SET PARTITION SPEC(TRUNCATE(2, last_name))");
        newRecords = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(7L, "Mike", "Taylor").add(8L, "Christy", "Hubert").add(9L, "RDBMS", "Talk").add(10L, "Notification", "Hub").add(11L, "Vector", "HDFS").build();
        shell.executeStatement(this.testTables.getInsertQuery(newRecords, target, false));
        shell.executeStatement("update target set first_name='RDBMSV2' where customer_id=9");
        shell.executeStatement("delete from target where customer_id%2=0 AND customer_id>6");
        Table icebergTable = this.testTables.loadTable(target);
        Assert.assertNotEquals((Object)"0", icebergTable.currentSnapshot().summary().get("total-delete-files"));
        long preTruncateSnapshotId = icebergTable.currentSnapshot().snapshotId();
        List<Object[]> result = shell.executeStatement(String.format("SELECT * FROM %s order by customer_id", target.name()));
        shell.executeStatement("TRUNCATE TABLE target");
        shell.executeStatement("INSERT OVERWRITE TABLE target select * from target FOR SYSTEM_VERSION AS OF " + preTruncateSnapshotId);
        HiveIcebergTestUtils.validateData(table, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, result), 0);
        icebergTable = this.testTables.loadTable(target);
        Assert.assertEquals((Object)"0", icebergTable.currentSnapshot().summary().get("total-delete-files"));
    }
}

