/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveIcebergFilterFactory {
    @Test
    public void testEqualsOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("salary", PredicateLeaf.Type.LONG, (Object)3000L).end().build();
        UnboundPredicate expected = Expressions.equal((String)"salary", (Object)3000L);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testEqualsOperandRewrite() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("float", PredicateLeaf.Type.FLOAT, (Object)Double.NaN).end().build();
        UnboundPredicate expected = Expressions.isNaN((String)"float");
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testNotEqualsOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startNot().equals("salary", PredicateLeaf.Type.LONG, (Object)3000L).end().build();
        Not expected = (Not)Expressions.not((Expression)Expressions.equal((String)"salary", (Object)3000L));
        Not actual = (Not)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        UnboundPredicate childExpressionActual = (UnboundPredicate)actual.child();
        UnboundPredicate childExpressionExpected = Expressions.equal((String)"salary", (Object)3000L);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.child().op(), (Object)expected.child().op());
        Assert.assertEquals((Object)childExpressionActual.ref().name(), (Object)childExpressionExpected.ref().name());
        Assert.assertEquals((Object)childExpressionActual.literal(), (Object)childExpressionExpected.literal());
    }

    @Test
    public void testLessThanOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().lessThan("salary", PredicateLeaf.Type.LONG, (Object)3000L).end().build();
        UnboundPredicate expected = Expressions.lessThan((String)"salary", (Object)3000L);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.literal(), (Object)expected.literal());
        Assert.assertEquals((Object)actual.ref().name(), (Object)expected.ref().name());
    }

    @Test
    public void testLessThanEqualsOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().lessThanEquals("salary", PredicateLeaf.Type.LONG, (Object)3000L).end().build();
        UnboundPredicate expected = Expressions.lessThanOrEqual((String)"salary", (Object)3000L);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testInOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().in("salary", PredicateLeaf.Type.LONG, new Object[]{3000L, 4000L}).end().build();
        UnboundPredicate expected = Expressions.in((String)"salary", (Object[])new Long[]{3000L, 4000L});
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.literals(), (Object)expected.literals());
        Assert.assertEquals((Object)actual.ref().name(), (Object)expected.ref().name());
    }

    @Test
    public void testBetweenOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().between("salary", PredicateLeaf.Type.LONG, (Object)3000L, (Object)4000L).end().build();
        And expected = (And)Expressions.and((Expression)Expressions.greaterThanOrEqual((String)"salary", (Object)3000L), (Expression)Expressions.lessThanOrEqual((String)"salary", (Object)3000L));
        And actual = (And)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.left().op(), (Object)expected.left().op());
        Assert.assertEquals((Object)actual.right().op(), (Object)expected.right().op());
    }

    @Test
    public void testIsNullOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().isNull("salary", PredicateLeaf.Type.LONG).end().build();
        UnboundPredicate expected = Expressions.isNull((String)"salary");
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.ref().name(), (Object)expected.ref().name());
    }

    @Test
    public void testAndOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("salary", PredicateLeaf.Type.LONG, (Object)3000L).equals("salary", PredicateLeaf.Type.LONG, (Object)4000L).end().build();
        And expected = (And)Expressions.and((Expression)Expressions.equal((String)"salary", (Object)3000L), (Expression)Expressions.equal((String)"salary", (Object)4000L));
        And actual = (And)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.left().op(), (Object)expected.left().op());
        Assert.assertEquals((Object)actual.right().op(), (Object)expected.right().op());
    }

    @Test
    public void testOrOperand() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startOr().equals("salary", PredicateLeaf.Type.LONG, (Object)3000L).equals("salary", PredicateLeaf.Type.LONG, (Object)4000L).end().build();
        Or expected = (Or)Expressions.or((Expression)Expressions.equal((String)"salary", (Object)3000L), (Expression)Expressions.equal((String)"salary", (Object)4000L));
        Or actual = (Or)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        Assert.assertEquals((Object)actual.op(), (Object)expected.op());
        Assert.assertEquals((Object)actual.left().op(), (Object)expected.left().op());
        Assert.assertEquals((Object)actual.right().op(), (Object)expected.right().op());
    }

    @Test
    public void testStringType() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("string", PredicateLeaf.Type.STRING, (Object)"Joe").end().build();
        UnboundPredicate expected = Expressions.equal((String)"string", (Object)"Joe");
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testFloatType() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("float", PredicateLeaf.Type.FLOAT, (Object)1200.0).end().build();
        UnboundPredicate expected = Expressions.equal((String)"float", (Object)1200.0);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testBooleanType() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("boolean", PredicateLeaf.Type.BOOLEAN, (Object)true).end().build();
        UnboundPredicate expected = Expressions.equal((String)"boolean", (Object)true);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testDateType() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        Date gmtDate = Date.valueOf(LocalDate.of(2015, 11, 12));
        SearchArgument arg = builder.startAnd().equals("date", PredicateLeaf.Type.DATE, (Object)gmtDate).end().build();
        UnboundPredicate expected = Expressions.equal((String)"date", (Object)Literal.of((CharSequence)"2015-11-12").to((Type)Types.DateType.get()).value());
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testTimestampType() {
        Literal timestampLiteral = Literal.of((CharSequence)"2012-10-02T05:16:17.123456").to((Type)Types.TimestampType.withoutZone());
        long timestampMicros = (Long)timestampLiteral.value();
        Timestamp ts = Timestamp.from(DateTimeUtil.timestampFromMicros((long)timestampMicros).toInstant(ZoneOffset.UTC));
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("timestamp", PredicateLeaf.Type.TIMESTAMP, (Object)ts).end().build();
        UnboundPredicate expected = Expressions.equal((String)"timestamp", (Object)timestampMicros);
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    @Test
    public void testDecimalType() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument arg = builder.startAnd().equals("decimal", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("20.12")).end().build();
        UnboundPredicate expected = Expressions.equal((String)"decimal", (Object)new BigDecimal("20.12"));
        UnboundPredicate actual = (UnboundPredicate)HiveIcebergFilterFactory.generateFilterExpression((SearchArgument)arg);
        this.assertPredicatesMatch(expected, actual);
    }

    private void assertPredicatesMatch(UnboundPredicate expected, UnboundPredicate actual) {
        Assert.assertEquals((Object)expected.op(), (Object)actual.op());
        Assert.assertEquals((Object)expected.literal(), (Object)actual.literal());
        Assert.assertEquals((Object)expected.ref().name(), (Object)actual.ref().name());
    }
}

