/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergExpireSnapshots
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testExpireSnapshotsWithTimestamp() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 5);
        Assert.assertEquals((long)5L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS('" + HiveIcebergTestUtils.timestampAfterSnapshot(table, 2) + "')");
        table.refresh();
        Assert.assertEquals((long)2L, (long)table.history().size());
    }

    @Test
    public void testExpireSnapshotsWithSnapshotId() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 10);
        Assert.assertEquals((long)10L, (long)IterableUtils.size((Iterable)table.snapshots()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS('" + ((HistoryEntry)table.history().get(2)).snapshotId() + "')");
        table.refresh();
        Assert.assertEquals((long)9L, (long)IterableUtils.size((Iterable)table.snapshots()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS('" + ((HistoryEntry)table.history().get(3)).snapshotId() + "," + ((HistoryEntry)table.history().get(4)).snapshotId() + "')");
        table.refresh();
        Assert.assertEquals((long)7L, (long)IterableUtils.size((Iterable)table.snapshots()));
    }

    @Test
    public void testExpireSnapshotsWithTimestampRange() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 10);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000000");
        String fromTime = simpleDateFormat.format(new Date(((HistoryEntry)table.history().get(5)).timestampMillis()));
        String toTime = simpleDateFormat.format(new Date(((HistoryEntry)table.history().get(8)).timestampMillis()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS BETWEEN '" + fromTime + "' AND '" + toTime + "'");
        table.refresh();
        Assert.assertEquals((long)6L, (long)IterableUtils.size((Iterable)table.snapshots()));
    }

    @Test
    public void testExpireSnapshotsWithRetainLast() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 10);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS RETAIN LAST 5");
        table.refresh();
        Assert.assertEquals((long)10L, (long)IterableUtils.size((Iterable)table.snapshots()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " SET TBLPROPERTIES('history.expire.max-snapshot-age-ms'='1')");
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS RETAIN LAST 5");
        table.refresh();
        Assert.assertEquals((long)5L, (long)IterableUtils.size((Iterable)table.snapshots()));
    }

    @Test
    public void testExpireSnapshotsWithDefaultParams() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 10);
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS RETAIN LAST 5");
        table.refresh();
        Assert.assertEquals((long)10L, (long)IterableUtils.size((Iterable)table.snapshots()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " SET TBLPROPERTIES('history.expire.max-snapshot-age-ms'='1','history.expire.min-snapshots-to-keep'='3')");
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS");
        table.refresh();
        Assert.assertEquals((long)3L, (long)IterableUtils.size((Iterable)table.snapshots()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " SET TBLPROPERTIES('history.expire.min-snapshots-to-keep'='2')");
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS");
        table.refresh();
        Assert.assertEquals((long)2L, (long)IterableUtils.size((Iterable)table.snapshots()));
    }

    @Test
    public void testExpireSnapshotsWithFunction() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 5);
        Assert.assertEquals((long)5L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS(DATE('1985-10-10'))");
        table.refresh();
        Assert.assertEquals((long)5L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS(TIMESTAMP('1987-10-10 10:15:23.386'))");
        table.refresh();
        Assert.assertEquals((long)5L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS(CURRENT_DATE + 5)");
        table.refresh();
        Assert.assertEquals((long)1L, (long)table.history().size());
        this.testTables.appendIcebergTable(shell.getHiveConf(), table, this.fileFormat, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        table.refresh();
        Assert.assertEquals((long)2L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS(CURRENT_TIMESTAMP)");
        table.refresh();
        Assert.assertEquals((long)1L, (long)table.history().size());
        this.testTables.appendIcebergTable(shell.getHiveConf(), table, this.fileFormat, null, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        table.refresh();
        Assert.assertEquals((long)2L, (long)table.history().size());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000000");
        String toTime = simpleDateFormat.format(new Date(((HistoryEntry)table.history().get(0)).timestampMillis()));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS BETWEEN (CURRENT_DATE - 1) AND '" + toTime + "'");
        table.refresh();
        Assert.assertEquals((long)1L, (long)IterableUtils.size((Iterable)table.snapshots()));
        AssertHelpers.assertThrows((String)"Invalid timestamp expression", IllegalArgumentException.class, () -> shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE EXPIRE_SNAPSHOTS BETWEEN (RAND()) AND '" + toTime + "'"));
    }

    @Test
    public void testDeleteOrphanFiles() throws IOException, InterruptedException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "source"});
        Table table = this.testTables.createTableWithVersions(shell, identifier.name(), HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 5);
        Assert.assertEquals((long)5L, (long)table.history().size());
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + identifier.name());
        List<Record> originalRecords = HiveIcebergTestUtils.valueForRow(table.schema(), rows);
        Path orphanDataFile = new Path(table.location(), "data/dataFile");
        Path orphanMetadataFile = new Path(table.location(), "metadata/metafile");
        FileSystem fs = orphanDataFile.getFileSystem(shell.getHiveConf());
        fs.create(orphanDataFile).close();
        fs.create(orphanMetadataFile).close();
        int numDataFiles = RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "data"), true)).size();
        int numMetadataFiles = RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "metadata"), true)).size();
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE DELETE ORPHAN-FILES");
        Assert.assertEquals((long)numDataFiles, (long)RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "data"), true)).size());
        Assert.assertEquals((long)numMetadataFiles, (long)RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "metadata"), true)).size());
        Assert.assertTrue((boolean)fs.exists(orphanDataFile));
        Assert.assertTrue((boolean)fs.exists(orphanDataFile));
        long time = System.currentTimeMillis() + 1000L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000000");
        String timeStamp = simpleDateFormat.format(new Date(time));
        shell.executeStatement("ALTER TABLE " + identifier.name() + " EXECUTE DELETE ORPHAN-FILES OLDER THAN ('" + timeStamp + "')");
        Assert.assertEquals((long)(numDataFiles - 1), (long)RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "data"), true)).size());
        Assert.assertEquals((long)(numMetadataFiles - 1), (long)RemoteIterators.toList((RemoteIterator)fs.listFiles(new Path(table.location(), "metadata"), true)).size());
        Assert.assertFalse((boolean)fs.exists(orphanDataFile));
        Assert.assertFalse((boolean)fs.exists(orphanDataFile));
        table.refresh();
        rows = shell.executeStatement("SELECT * FROM " + identifier.name());
        List<Record> records = HiveIcebergTestUtils.valueForRow(table.schema(), rows);
        HiveIcebergTestUtils.validateData(originalRecords, records, 0);
    }
}

