/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveIcebergComplexTypeWrites
extends HiveIcebergStorageHandlerWithEngineBase {
    @Test
    public void testWriteArrayOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"arrayofprimitives", (Type)Types.ListType.ofRequired((int)3, (Type)Types.StringType.get()))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteArrayOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"arrayofarrays", (Type)Types.ListType.ofRequired((int)3, (Type)Types.ListType.ofRequired((int)4, (Type)Types.StringType.get())))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 3, 1L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteArrayOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"arrayofmaps", (Type)Types.ListType.ofRequired((int)3, (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StringType.get())))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 1L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteArrayOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"arrayofstructs", (Type)Types.ListType.ofRequired((int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"something", (Type)Types.StringType.get()), Types.NestedField.required((int)5, (String)"someone", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"somewhere", (Type)Types.StringType.get())})))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteMapOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"mapofprimitives", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteMapOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"mapofarrays", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.ListType.ofRequired((int)5, (Type)Types.StringType.get())))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteMapOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"mapofmaps", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.MapType.ofRequired((int)5, (int)6, (Type)Types.StringType.get(), (Type)Types.StringType.get())))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteMapOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"mapofstructs", (Type)Types.MapType.ofRequired((int)3, (int)4, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"something", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"someone", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"somewhere", (Type)Types.StringType.get())})))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteStructOfPrimitivesInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"structofprimitives", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"key", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"value", (Type)Types.StringType.get())}))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteStructOfArraysInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"structofarrays", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"names", (Type)Types.ListType.ofRequired((int)4, (Type)Types.StringType.get())), Types.NestedField.required((int)5, (String)"birthdays", (Type)Types.ListType.ofRequired((int)6, (Type)Types.StringType.get()))}))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 1L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteStructOfMapsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"structofmaps", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"map1", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StringType.get())), Types.NestedField.required((int)6, (String)"map2", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.StringType.get()))}))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    @Test
    public void testWriteStructOfStructsInTable() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"structofstructs", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"key", (Type)Types.StringType.get()), Types.NestedField.required((int)5, (String)"value", (Type)Types.StringType.get())}))}))});
        List<Record> records = TestHelper.generateRandomRecords(schema, 5, 0L);
        this.testComplexTypeWrite(schema, records);
    }

    private void testComplexTypeWrite(Schema schema, List<Record> records) throws IOException {
        String tableName = "complex_table";
        Table table = this.testTables.createTable(shell, "complex_table", schema, this.fileFormat, (List<Record>)ImmutableList.of());
        String dummyTableName = "dummy";
        shell.executeStatement("CREATE TABLE default." + dummyTableName + "(a int)");
        shell.executeStatement("INSERT INTO TABLE default." + dummyTableName + " VALUES(1)");
        records.forEach(r -> shell.executeStatement(this.insertQueryForComplexType(tableName, dummyTableName, schema, (Record)r)));
        HiveIcebergTestUtils.validateData(table, records, 0);
    }

    private String insertQueryForComplexType(String tableName, String dummyTableName, Schema schema, Record record) {
        StringBuilder query = new StringBuilder("INSERT INTO TABLE ").append(tableName).append(" SELECT ").append(record.get(0)).append(", ");
        Type type = ((Types.NestedField)schema.asStruct().fields().get(1)).type();
        query.append((CharSequence)this.buildComplexTypeInnerQuery(record.get(1), type));
        query.setLength(query.length() - 1);
        query.append(" FROM ").append(dummyTableName).append(" LIMIT 1");
        return query.toString();
    }

    private StringBuilder buildComplexTypeInnerQuery(Object field, Type type) {
        StringBuilder query = new StringBuilder();
        if (type instanceof Types.ListType) {
            query.append("array(");
            List elements = (List)field;
            Assert.assertFalse((String)"Hive can not handle empty array() inserts", (boolean)elements.isEmpty());
            Type innerType = ((Types.NestedField)((Types.ListType)type).fields().get(0)).type();
            if (!elements.isEmpty()) {
                elements.forEach(e -> query.append((CharSequence)this.buildComplexTypeInnerQuery(e, innerType)));
                query.setLength(query.length() - 1);
            }
            query.append("),");
        } else if (type instanceof Types.MapType) {
            query.append("map(");
            Map entries = (Map)field;
            Type keyType = ((Types.NestedField)((Types.MapType)type).fields().get(0)).type();
            Type valueType = ((Types.NestedField)((Types.MapType)type).fields().get(1)).type();
            if (!entries.isEmpty()) {
                entries.entrySet().forEach(e -> query.append((CharSequence)this.buildComplexTypeInnerQuery(e.getKey(), keyType).append((CharSequence)this.buildComplexTypeInnerQuery(e.getValue(), valueType))));
                query.setLength(query.length() - 1);
            }
            query.append("),");
        } else if (type instanceof Types.StructType) {
            query.append("named_struct(");
            ((GenericRecord)field).struct().fields().forEach(f -> query.append((CharSequence)this.buildComplexTypeInnerQuery(f.name(), (Type)Types.StringType.get())).append((CharSequence)this.buildComplexTypeInnerQuery(((GenericRecord)field).getField(f.name()), f.type())));
            query.setLength(query.length() - 1);
            query.append("),");
        } else if (type instanceof Types.StringType) {
            if (field != null) {
                query.append("'").append(field).append("',");
            }
        } else {
            throw new RuntimeException("Unsupported type in complex query build.");
        }
        return query;
    }
}

