/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergCTAS
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((String)"CTAS target table must be a HiveCatalog table. For other catalog types, the target Iceberg table would be created successfully but the table will not be registered in HMS. This means that even though the CTAS query succeeds, the new table wouldn't be immediately queryable from Hive, since HMS does not know about it.", (this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.isVectorized && this.formatVersion == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCTASFromHiveTable() {
        shell.executeStatement("CREATE TABLE source (id bigint, name string) PARTITIONED BY (dept string) STORED AS ORC");
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, TableIdentifier.of((String[])new String[]{"default", "source"}), false));
        shell.executeStatement(String.format("CREATE TABLE target STORED BY ICEBERG %s %s AS SELECT * FROM source", this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "target"})), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"write.format.default", (Object)this.fileFormat.toString()))));
        List<Object[]> objects = shell.executeStatement("SELECT * FROM target ORDER BY id");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testCTASPartitionedFromHiveTable() throws TException, InterruptedException {
        shell.executeStatement("CREATE TABLE source (id bigint, name string) PARTITIONED BY (dept string) STORED AS ORC");
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, TableIdentifier.of((String[])new String[]{"default", "source"}), false));
        shell.executeStatement(String.format("CREATE TABLE target PARTITIONED BY (dept, name) STORED BY ICEBERG %s AS SELECT * FROM source", this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"write.format.default", (Object)this.fileFormat.toString()))));
        List<Object[]> objects = shell.executeStatement("SELECT id, name, dept FROM target ORDER BY id");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "target");
        Assert.assertEquals((long)3L, (long)hmsTable.getSd().getColsSize());
        Assert.assertTrue((boolean)hmsTable.getPartitionKeys().isEmpty());
        Assert.assertEquals((Object)this.fileFormat.toString().toLowerCase(), hmsTable.getParameters().get("write.format.default"));
        Table table = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "target"}));
        Assert.assertEquals((long)2L, (long)table.spec().fields().size());
        Assert.assertEquals((Object)"dept", (Object)((PartitionField)table.spec().fields().get(0)).name());
        Assert.assertEquals((Object)"name", (Object)((PartitionField)table.spec().fields().get(1)).name());
    }

    @Test
    public void testCTASTblPropsAndLocationClause() throws Exception {
        shell.executeStatement("CREATE TABLE source (id bigint, name string) PARTITIONED BY (dept string) STORED AS ORC");
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, TableIdentifier.of((String[])new String[]{"default", "source"}), false));
        String location = this.temp.newFolder().toURI().toString();
        shell.executeStatement(String.format("CREATE TABLE target PARTITIONED BY (dept, name) STORED BY ICEBERG STORED AS %s LOCATION '%s' TBLPROPERTIES ('customKey'='customValue') AS SELECT * FROM source", this.fileFormat.toString(), location));
        List<Object[]> objects = shell.executeStatement("SELECT id, name, dept FROM target ORDER BY id");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
        org.apache.hadoop.hive.metastore.api.Table tbl = shell.metastore().getTable("default", "target");
        Assert.assertEquals((Object)location, (Object)(tbl.getSd().getLocation() + "/"));
        Assert.assertEquals((Object)"customValue", tbl.getParameters().get("customKey"));
        Assert.assertNull(tbl.getParameters().get("columns"));
        Assert.assertNull(tbl.getParameters().get("partition.columns"));
    }

    @Test
    public void testCTASPartitionedBySpec() throws TException, InterruptedException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"year_field", (Type)Types.DateType.get()), Types.NestedField.optional((int)3, (String)"month_field", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"day_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)5, (String)"hour_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)6, (String)"truncate_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"bucket_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"identity_field", (Type)Types.StringType.get())});
        List<Record> records = TestHelper.generateRandomRecords(schema, 10, 0L);
        shell.executeStatement("CREATE TABLE source (id bigint, year_field date, month_field timestamp, day_field timestamp, hour_field timestamp, truncate_field string, bucket_field string, identity_field string)");
        shell.executeStatement(this.testTables.getInsertQuery(records, TableIdentifier.of((String[])new String[]{"default", "source"}), false));
        shell.executeStatement(String.format("CREATE TABLE target PARTITIONED BY SPEC (year(year_field), month(month_field), day(day_field), hour(hour_field), truncate(2, truncate_field), bucket(2, bucket_field), identity_field) STORED BY ICEBERG %s AS SELECT * FROM source", this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"write.format.default", (Object)this.fileFormat.toString()))));
        records.sort(Comparator.comparingLong(record -> (Long)record.get(0)));
        HiveIcebergTestUtils.validateDataWithSQL(shell, "default.target", records, "id");
        org.apache.hadoop.hive.metastore.api.Table hmsTable = shell.metastore().getTable("default", "target");
        Assert.assertEquals((long)8L, (long)hmsTable.getSd().getColsSize());
        Assert.assertTrue((boolean)hmsTable.getPartitionKeys().isEmpty());
        Assert.assertEquals((Object)this.fileFormat.toString().toLowerCase(), hmsTable.getParameters().get("write.format.default"));
        Table table = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "target"}));
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).year("year_field").month("month_field").day("day_field").hour("hour_field").truncate("truncate_field", 2).bucket("bucket_field", 2).identity("identity_field").build();
        Assert.assertEquals((Object)PartitionSpecParser.toJson((PartitionSpec)spec), (Object)PartitionSpecParser.toJson((PartitionSpec)table.spec()));
    }

    @Test
    public void testCTASFailureRollback() throws IOException {
        String[] partitioningSchemes;
        shell.setHiveSessionValue("hive.tez.mapreduce.output.committer.class", "org.apache.NotExistingClass");
        TableIdentifier target = TableIdentifier.of((String[])new String[]{"default", "target"});
        this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        for (String partitioning : partitioningSchemes = new String[]{"", "PARTITIONED BY (last_name)", "PARTITIONED BY (customer_id, last_name)"}) {
            AssertHelpers.assertThrows((String)"Should fail while loading non-existent output committer class.", IllegalArgumentException.class, (String)"org.apache.NotExistingClass", () -> shell.executeStatement(String.format("CREATE TABLE target %s STORED BY ICEBERG AS SELECT * FROM source", partitioning)));
            Assert.assertThrows(NoSuchTableException.class, () -> this.testTables.loadTable(target));
        }
    }

    @Test
    public void testCTASFollowedByTruncate() throws IOException {
        this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        shell.executeStatement(String.format("CREATE EXTERNAL TABLE target STORED BY ICEBERG STORED AS %s %s AS SELECT * FROM source", this.fileFormat, this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "target"}))));
        List<Object[]> objects = shell.executeStatement("SELECT * FROM target ORDER BY customer_id");
        HiveIcebergTestUtils.validateData(HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
        shell.executeStatement("TRUNCATE TABLE target");
        objects = shell.executeStatement("SELECT * FROM target");
        Assert.assertTrue((boolean)objects.isEmpty());
    }

    @Test
    public void testCTASUnsupportedTypeWithoutAutoConversion() {
        ImmutableMap notSupportedTypes = ImmutableMap.of((Object)"TINYINT", (Object)Types.IntegerType.get(), (Object)"SMALLINT", (Object)Types.IntegerType.get(), (Object)"VARCHAR(1)", (Object)Types.StringType.get(), (Object)"CHAR(1)", (Object)Types.StringType.get());
        for (String notSupportedType : notSupportedTypes.keySet()) {
            shell.executeStatement(String.format("CREATE TABLE source (s %s) STORED AS ORC", notSupportedType));
            AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Unsupported Hive type ", () -> shell.executeStatement(String.format("CREATE TABLE target STORED BY ICEBERG %s %s AS SELECT * FROM source", this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "target"})), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"write.format.default", (Object)this.fileFormat.toString())))));
            shell.executeStatement("DROP TABLE source");
        }
    }

    @Test
    public void testCTASUnsupportedTypeWithAutoConversion() {
        ImmutableMap notSupportedTypes = ImmutableMap.of((Object)"TINYINT", (Object)Types.IntegerType.get(), (Object)"SMALLINT", (Object)Types.IntegerType.get(), (Object)"VARCHAR(1)", (Object)Types.StringType.get(), (Object)"CHAR(1)", (Object)Types.StringType.get());
        shell.setHiveSessionValue("iceberg.mr.schema.auto.conversion", "true");
        for (String notSupportedType : notSupportedTypes.keySet()) {
            shell.executeStatement(String.format("CREATE TABLE source (s %s) STORED AS ORC", notSupportedType));
            shell.executeStatement(String.format("CREATE TABLE target STORED BY ICEBERG %s %s AS SELECT * FROM source", this.testTables.locationForCreateTableSQL(TableIdentifier.of((String[])new String[]{"default", "target"})), this.testTables.propertiesForCreateTableSQL((Map<String, String>)ImmutableMap.of((Object)"write.format.default", (Object)this.fileFormat.toString()))));
            Table icebergTable = this.testTables.loadTable(TableIdentifier.of((String[])new String[]{"default", "target"}));
            Assert.assertEquals(notSupportedTypes.get(notSupportedType), (Object)((Types.NestedField)icebergTable.schema().columns().get(0)).type());
            shell.executeStatement("DROP TABLE source");
            shell.executeStatement("DROP TABLE target");
        }
    }

    @Test
    public void testCTASForAllColumnTypes() {
        shell.setHiveSessionValue("iceberg.mr.schema.auto.conversion", "true");
        String sourceCreate = "CREATE EXTERNAL TABLE source (timestamp_col_1 TIMESTAMP, decimal3003_col_2 DECIMAL(30, 3), tinyint_col_3 TINYINT, decimal0101_col_4 DECIMAL(1, 1), boolean_col_5 BOOLEAN, float_col_6 FLOAT, bigint_col_7 BIGINT, varchar0098_col_8 VARCHAR(98), timestamp_col_9 TIMESTAMP, bigint_col_10 BIGINT, decimal0903_col_11 DECIMAL(9, 3), timestamp_col_12 TIMESTAMP, timestamp_col_13 TIMESTAMP, float_col_14 FLOAT, char0254_col_15 CHAR(254), double_col_16 DOUBLE, timestamp_col_17 TIMESTAMP, boolean_col_18 BOOLEAN, decimal2608_col_19 DECIMAL(26, 8), varchar0216_col_20 VARCHAR(216), string_col_21 STRING, bigint_col_22 BIGINT, boolean_col_23 BOOLEAN, timestamp_col_24 TIMESTAMP, boolean_col_25 BOOLEAN, decimal2016_col_26 DECIMAL(20, 16), string_col_27 STRING, decimal0202_col_28 DECIMAL(2, 2), float_col_29 FLOAT, decimal2020_col_30 DECIMAL(20, 20), boolean_col_31 BOOLEAN, double_col_32 DOUBLE, varchar0148_col_33 VARCHAR(148), decimal2121_col_34 DECIMAL(21, 21), tinyint_col_35 TINYINT, boolean_col_36 BOOLEAN, boolean_col_37 BOOLEAN, string_col_38 STRING, decimal3420_col_39 DECIMAL(34, 20), timestamp_col_40 TIMESTAMP, decimal1408_col_41 DECIMAL(14, 8), string_col_42 STRING, decimal0902_col_43 DECIMAL(9, 2), varchar0204_col_44 VARCHAR(204), boolean_col_45 BOOLEAN, timestamp_col_46 TIMESTAMP, boolean_col_47 BOOLEAN, bigint_col_48 BIGINT, boolean_col_49 BOOLEAN, smallint_col_50 SMALLINT, decimal0704_col_51 DECIMAL(7, 4), timestamp_col_52 TIMESTAMP, boolean_col_53 BOOLEAN, timestamp_col_54 TIMESTAMP, int_col_55 INT, decimal0505_col_56 DECIMAL(5, 5), char0155_col_57 CHAR(155), boolean_col_58 BOOLEAN, bigint_col_59 BIGINT, boolean_col_60 BOOLEAN, boolean_col_61 BOOLEAN, char0249_col_62 CHAR(249), boolean_col_63 BOOLEAN, timestamp_col_64 TIMESTAMP, decimal1309_col_65 DECIMAL(13, 9), int_col_66 INT, float_col_67 FLOAT, timestamp_col_68 TIMESTAMP, timestamp_col_69 TIMESTAMP, boolean_col_70 BOOLEAN, timestamp_col_71 TIMESTAMP, double_col_72 DOUBLE, boolean_col_73 BOOLEAN, char0222_col_74 CHAR(222), float_col_75 FLOAT, string_col_76 STRING, decimal2612_col_77 DECIMAL(26, 12), timestamp_col_78 TIMESTAMP, char0128_col_79 CHAR(128), timestamp_col_80 TIMESTAMP, double_col_81 DOUBLE, timestamp_col_82 TIMESTAMP, float_col_83 FLOAT, decimal2622_col_84 DECIMAL(26, 22), double_col_85 DOUBLE, float_col_86 FLOAT, decimal0907_col_87 DECIMAL(9, 7)) ROW FORMAT DELIMITED FIELDS TERMINATED BY '\u0001'";
        shell.executeStatement(sourceCreate);
        String ctas = "CREATE TABLE target STORED BY ICEBERG STORED AS orc AS SELECT * FROM source";
        shell.executeStatement(ctas);
    }

    @Test
    public void testCTASAndCTLTWithAuth() {
        shell.setHiveSessionValue("hive.security.authorization.enabled", true);
        shell.setHiveSessionValue("hive.security.authorization.manager", "org.apache.iceberg.mr.hive.CustomTestHiveAuthorizerFactory");
        shell.setHiveSessionValue("hive.security.authorization.tables.on.storagehandlers", true);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", "customers"});
        String query = String.format("CREATE EXTERNAL TABLE customers (customer_id BIGINT,first_name STRING, last_name STRING,primary key (customer_id, first_name) disable novalidate) STORED BY ICEBERG %s TBLPROPERTIES ('%s'='%s')", this.testTables.locationForCreateTableSQL(identifier), "iceberg.catalog", this.testTables.catalogName());
        shell.executeStatement(query);
        shell.executeStatement("create table target_ctas stored by iceberg stored as orc as select * from customers");
        shell.executeStatement("create table target_ctlt like customers stored by iceberg");
    }
}

