/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.base.Throwables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergCRUD
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
    }

    @Test
    public void testReadAndWriteFormatV2UnpartitionedWithEqDelete() throws IOException {
        Assume.assumeTrue((String)"Reading V2 tables with eq delete files are only supported currently in non-vectorized mode", (!this.isVectorized && this.formatVersion == 2 ? 1 : 0) != 0);
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        List<Record> toDelete = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Bob", null).build();
        DeleteFile deleteFile = HiveIcebergTestUtils.createEqualityDeleteFile(tbl, "dummyPath", (List<String>)ImmutableList.of((Object)"customer_id", (Object)"first_name"), this.fileFormat, toDelete);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])objects.get(1));
    }

    @Test
    public void testReadAndWriteFormatV2Partitioned_EqDelete_AllColumnsSupplied() throws IOException {
        Assume.assumeTrue((String)"Reading V2 tables with eq delete files are only supported currently in non-vectorized mode", (!this.isVectorized && this.formatVersion == 2 ? 1 : 0) != 0);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        shell.executeStatement("insert into customers values (1, 'Bob', 'Hoover')");
        List<Record> toDelete = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Bob", null).build();
        DeleteFile deleteFile = HiveIcebergTestUtils.createEqualityDeleteFile(tbl, "dummyPath", (List<String>)ImmutableList.of((Object)"customer_id", (Object)"first_name"), this.fileFormat, toDelete);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])objects.get(1));
    }

    @Test
    public void testReadAndWriteFormatV2Partitioned_EqDelete_OnlyEqColumnsSupplied() throws IOException {
        Assume.assumeTrue((String)"Reading V2 tables with eq delete files are only supported currently in non-vectorized mode", (!this.isVectorized && this.formatVersion == 2 ? 1 : 0) != 0);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        shell.executeStatement("insert into customers values (1, 'Bob', 'Hoover')");
        Schema shorterSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"name", (Type)Types.StringType.get())});
        List<Record> toDelete = TestHelper.RecordsBuilder.newInstance(shorterSchema).add(1L, "Bob").build();
        DeleteFile deleteFile = HiveIcebergTestUtils.createEqualityDeleteFile(tbl, "dummyPath", (List<String>)ImmutableList.of((Object)"customer_id", (Object)"first_name"), this.fileFormat, toDelete);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])objects.get(1));
    }

    @Test
    public void testReadAndWriteFormatV2Unpartitioned_PosDelete() throws IOException {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        DataFile dataFile = (DataFile)StreamSupport.stream(tbl.currentSnapshot().addedDataFiles(tbl.io()).spliterator(), false).findFirst().orElseThrow(() -> new RuntimeException("Did not find any data files for test table"));
        ImmutableList deletes = ImmutableList.of(TestHiveIcebergCRUD.positionDelete(dataFile.path(), 2L, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS.get(2)));
        DeleteFile deleteFile = HiveIcebergTestUtils.createPositionalDeleteFile(tbl, "dummyPath", this.fileFormat, null, (List<PositionDelete<Record>>)deletes);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id");
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])objects.get(1));
    }

    @Test
    public void testReadAndWriteFormatV2Partitioned_PosDelete_RowNotSupplied() throws IOException {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        shell.executeStatement("insert into customers values (0, 'Laura', 'Yellow'), (0, 'John', 'Green'), (0, 'Blake', 'Blue')");
        tbl.refresh();
        DataFile dataFile = StreamSupport.stream(tbl.currentSnapshot().addedDataFiles(tbl.io()).spliterator(), false).filter(file -> (Long)file.partition().get(0, Long.class) == 0L).filter(file -> file.recordCount() == 3L).findAny().orElseThrow(() -> new RuntimeException("Did not find the desired data file in the test table"));
        ImmutableList deletes = ImmutableList.of(TestHiveIcebergCRUD.positionDelete(dataFile.path(), 0L, null), TestHiveIcebergCRUD.positionDelete(dataFile.path(), 2L, null));
        DeleteFile deleteFile = HiveIcebergTestUtils.createPositionalDeleteFile(tbl, "dummyPath", this.fileFormat, (Map<String, Object>)ImmutableMap.of((Object)"customer_id", (Object)0L), (List<PositionDelete<Record>>)deletes);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, first_name");
        Assert.assertEquals((long)4L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{0L, "John", "Green"}, (Object[])objects.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])objects.get(2));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])objects.get(3));
    }

    @Test
    public void testReadAndWriteFormatV2Partitioned_PosDelete_RowSupplied() throws IOException {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("customer_id").build();
        Table tbl = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        shell.executeStatement("insert into customers values (0, 'Laura', 'Yellow'), (0, 'John', 'Green'), (0, 'Blake', 'Blue')");
        tbl.refresh();
        DataFile dataFile = StreamSupport.stream(tbl.currentSnapshot().addedDataFiles(tbl.io()).spliterator(), false).filter(file -> (Long)file.partition().get(0, Long.class) == 0L).filter(file -> file.recordCount() == 3L).findAny().orElseThrow(() -> new RuntimeException("Did not find the desired data file in the test table"));
        List<Record> rowsToDel = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(0L, "Laura", "Yellow").add(0L, "Blake", "Blue").build();
        ImmutableList deletes = ImmutableList.of(TestHiveIcebergCRUD.positionDelete(dataFile.path(), 0L, rowsToDel.get(0)), TestHiveIcebergCRUD.positionDelete(dataFile.path(), 2L, rowsToDel.get(1)));
        DeleteFile deleteFile = HiveIcebergTestUtils.createPositionalDeleteFile(tbl, "dummyPath", this.fileFormat, (Map<String, Object>)ImmutableMap.of((Object)"customer_id", (Object)0L), (List<PositionDelete<Record>>)deletes);
        tbl.newRowDelta().addDeletes(deleteFile).commit();
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, first_name");
        Assert.assertEquals((long)4L, (long)objects.size());
        Assert.assertArrayEquals((Object[])new Object[]{0L, "Alice", "Brown"}, (Object[])objects.get(0));
        Assert.assertArrayEquals((Object[])new Object[]{0L, "John", "Green"}, (Object[])objects.get(1));
        Assert.assertArrayEquals((Object[])new Object[]{1L, "Bob", "Green"}, (Object[])objects.get(2));
        Assert.assertArrayEquals((Object[])new Object[]{2L, "Trudy", "Pink"}, (Object[])objects.get(3));
    }

    @Test
    public void testDeleteStatementUnpartitioned() throws TException, InterruptedException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        if (this.formatVersion == 2) {
            Assert.assertEquals((Object)"merge-on-read", shell.metastore().getTable("default", "customers").getParameters().get("write.delete.mode"));
        }
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("DELETE FROM customers WHERE customer_id=3 or first_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name");
        Assert.assertEquals((long)6L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Sharon", "Taylor").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testDeleteStatementPartitioned() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("DELETE FROM customers WHERE customer_id=3 or first_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name");
        Assert.assertEquals((long)6L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Sharon", "Taylor").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testDeleteStatementWithOtherTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        this.testTables.createTable(shell, "other", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, this.formatVersion);
        shell.executeStatement("DELETE FROM customers WHERE customer_id in (select t1.customer_id from customers t1 join other t2 on t1.customer_id = t2.customer_id) or first_name in (select first_name from customers where first_name = 'Bob')");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name");
        Assert.assertEquals((long)5L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Sharon", "Taylor").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Joanna", "Silver").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testDeleteStatementWithPartitionAndSchemaEvolution() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("ALTER TABLE customers SET PARTITION SPEC (bucket(64, last_name))");
        shell.executeStatement("ALTER TABLE customers ADD COLUMNS (department string)");
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN first_name given_name string first");
        shell.executeStatement("INSERT INTO customers VALUES ('Natalie', 20, 'Bloom', 'Finance'), ('Joanna', 22, 'Huberman', 'Operations')");
        shell.executeStatement("DELETE FROM customers WHERE customer_id=3 or given_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name");
        Assert.assertEquals((long)7L, (long)objects.size());
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"given_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)4, (String)"department", (Type)Types.StringType.get())});
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(newSchema).add("Sharon", 1L, "Taylor", null).add("Jake", 2L, "Donnel", null).add("Susan", 2L, "Morrison", null).add("Bob", 2L, "Silver", null).add("Laci", 4L, "Zold", null).add("Peti", 5L, "Rozsaszin", null).add("Natalie", 20L, "Bloom", "Finance").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(newSchema, objects), 0);
    }

    @Test
    public void testDeleteForSupportedTypes() throws IOException {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        for (int i = 0; i < SUPPORTED_TYPES.size(); ++i) {
            Type type = (Type)SUPPORTED_TYPES.get(i);
            if (type == Types.UUIDType.get() && (this.fileFormat == FileFormat.PARQUET || this.fileFormat == FileFormat.ORC && this.isVectorized) || type == Types.TimeType.get() && this.fileFormat == FileFormat.PARQUET && this.isVectorized || type == Types.BinaryType.get() || type.equals(Types.FixedType.ofLength((int)5))) continue;
            String tableName = type.typeId().toString().toLowerCase() + "_table_" + i;
            String columnName = type.typeId().toString().toLowerCase() + "_column";
            Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)columnName, (Type)type)});
            List<Record> records = TestHelper.generateRandomRecords(schema, 1, 0L);
            Table table = this.testTables.createTable(shell, tableName, schema, PartitionSpec.unpartitioned(), this.fileFormat, records, this.formatVersion);
            shell.executeStatement("DELETE FROM " + tableName);
            HiveIcebergTestUtils.validateData(table, (List<Record>)ImmutableList.of(), 0);
        }
    }

    @Test
    public void testUpdateStatementUnpartitioned() throws TException, InterruptedException {
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        if (this.formatVersion == 2) {
            Assert.assertEquals((Object)"merge-on-read", shell.metastore().getTable("default", "customers").getParameters().get("write.update.mode"));
        }
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
        Assert.assertEquals((long)12L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Changed").add(1L, "Sharon", "Taylor").add(2L, "Joanna", "Changed").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(3L, "Blake", "Changed").add(3L, "Marci", "Changed").add(3L, "Trudy", "Changed").add(3L, "Trudy", "Changed").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testUpdateStatementPartitioned() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
        Assert.assertEquals((long)12L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Changed").add(1L, "Sharon", "Taylor").add(2L, "Joanna", "Changed").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(3L, "Blake", "Changed").add(3L, "Marci", "Changed").add(3L, "Trudy", "Changed").add(3L, "Trudy", "Changed").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testUpdateStatementWithOtherTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        this.testTables.createTable(shell, "other", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, this.formatVersion);
        shell.executeStatement("UPDATE customers SET last_name='Changed' WHERE customer_id in (select t1.customer_id from customers t1 join other t2 on t1.customer_id = t2.customer_id) or first_name in (select first_name from customers where first_name = 'Bob')");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, last_name");
        Assert.assertEquals((long)9L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Sharon", "Taylor").add(2L, "Bob", "Changed").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Joanna", "Silver").add(3L, "Blake", "Changed").add(3L, "Trudy", "Changed").add(3L, "Trudy", "Changed").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testUpdateStatementWithPartitionAndSchemaEvolution() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        shell.executeStatement("ALTER TABLE customers SET PARTITION SPEC (bucket(64, last_name))");
        shell.executeStatement("ALTER TABLE customers ADD COLUMNS (department string)");
        shell.executeStatement("ALTER TABLE customers CHANGE COLUMN first_name given_name string first");
        shell.executeStatement("INSERT INTO customers VALUES ('Natalie', 20, 'Bloom', 'Finance'), ('Joanna', 22, 'Huberman', 'Operations')");
        shell.executeStatement("UPDATE customers set last_name='Changed' WHERE customer_id=3 or given_name='Joanna'");
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, given_name");
        Assert.assertEquals((long)14L, (long)objects.size());
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"given_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name"), Types.NestedField.optional((int)4, (String)"department", (Type)Types.StringType.get())});
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(newSchema).add("Joanna", 1L, "Changed", null).add("Sharon", 1L, "Taylor", null).add("Joanna", 2L, "Changed", null).add("Jake", 2L, "Donnel", null).add("Susan", 2L, "Morrison", null).add("Bob", 2L, "Silver", null).add("Blake", 3L, "Changed", null).add("Marci", 3L, "Changed", null).add("Trudy", 3L, "Changed", null).add("Trudy", 3L, "Changed", null).add("Laci", 4L, "Zold", null).add("Peti", 5L, "Rozsaszin", null).add("Natalie", 20L, "Bloom", "Finance").add("Joanna", 22L, "Changed", "Operations").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(newSchema, objects), 0);
    }

    @Test
    public void testUpdateForSupportedTypes() throws IOException {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        for (int i = 0; i < SUPPORTED_TYPES.size(); ++i) {
            Type type = (Type)SUPPORTED_TYPES.get(i);
            if (type == Types.UUIDType.get() && (this.fileFormat == FileFormat.PARQUET || this.fileFormat == FileFormat.ORC && this.isVectorized) || type == Types.TimeType.get() && this.fileFormat == FileFormat.PARQUET && this.isVectorized || type == Types.BinaryType.get() || type.equals(Types.FixedType.ofLength((int)5))) continue;
            String tableName = type.typeId().toString().toLowerCase() + "_table_" + i;
            String columnName = type.typeId().toString().toLowerCase() + "_column";
            Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)columnName, (Type)type)});
            List<Record> originalRecords = TestHelper.generateRandomRecords(schema, 1, 0L);
            Table table = this.testTables.createTable(shell, tableName, schema, PartitionSpec.unpartitioned(), this.fileFormat, originalRecords, this.formatVersion);
            List<Record> newRecords = TestHelper.generateRandomRecords(schema, 1, 3L);
            shell.executeStatement(this.testTables.getUpdateQuery(tableName, newRecords.get(0)));
            HiveIcebergTestUtils.validateData(table, newRecords, 0);
        }
    }

    @Test
    public void testConcurrent2Deletes() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        String sql = "DELETE FROM customers WHERE customer_id=3 or first_name='Joanna'";
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(sql);
                shell.closeSession();
            });
        }
        catch (Throwable ex) {
            Assert.assertEquals((long)1L, (long)this.formatVersion.intValue());
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.assertTrue((boolean)(cause instanceof ValidationException));
            Assert.assertTrue((boolean)cause.getMessage().startsWith("Found conflicting files"));
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM customers");
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test
    public void testConcurrent2Updates() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        String sql = "UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'";
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(sql);
                shell.closeSession();
            });
        }
        catch (Throwable ex) {
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.assertTrue((boolean)(cause instanceof ValidationException));
            Assert.assertTrue((boolean)cause.getMessage().matches("^Found.*conflicting.*files(.*)"));
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM customers WHERE last_name='Changed'");
        Assert.assertEquals((long)5L, (long)res.size());
    }

    @Test
    public void testConcurrentUpdateAndDelete() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
        this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, this.formatVersion);
        String[] sql = new String[]{"DELETE FROM customers WHERE customer_id=3 or first_name='Joanna'", "UPDATE customers SET last_name='Changed' WHERE customer_id=3 or first_name='Joanna'"};
        boolean deleteFirst = false;
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(sql[i]);
                shell.closeSession();
            });
        }
        catch (Throwable ex) {
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.assertTrue((boolean)(cause instanceof ValidationException));
            Assert.assertTrue((boolean)cause.getMessage().matches("^Found.*conflicting.*files(.*)"));
            deleteFirst = cause.getMessage().contains("conflicting delete");
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM customers WHERE last_name='Changed'");
        Assert.assertEquals((long)(deleteFirst ? 0L : 5L), (long)res.size());
    }

    @Test
    public void testConcurrent2MergeInserts() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1);
        this.testTables.createTable(shell, "target", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, this.formatVersion);
        String sql = "MERGE INTO target t USING source s on t.customer_id = s.customer_id WHEN Not MATCHED THEN INSERT values (s.customer_id, s.first_name, s.last_name)";
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(sql);
                shell.closeSession();
            });
        }
        catch (Throwable ex) {
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.assertTrue((boolean)(cause instanceof ValidationException));
            Assert.assertTrue((boolean)cause.getMessage().startsWith("Found conflicting files"));
        }
        List<Object[]> res = shell.executeStatement("SELECT * FROM target");
        Assert.assertEquals((long)6L, (long)res.size());
    }

    @Test
    public void testMultiInsert() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG ? 1 : 0) != 0);
        this.testTables.createTable(shell, "source", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS);
        this.testTables.createTable(shell, "alice", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, null, this.formatVersion);
        this.testTables.createTable(shell, "green", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, PartitionSpec.unpartitioned(), this.fileFormat, null, this.formatVersion);
        String sql = "FROM source INSERT INTO alice   SELECT * WHERE first_name='Alice'INSERT INTO green   SELECT * WHERE last_name='Green'";
        shell.executeStatement(sql);
        List<Object[]> res = shell.executeStatement("SELECT * FROM alice");
        Assert.assertEquals((long)1L, (long)res.size());
        res = shell.executeStatement("SELECT * FROM green");
        Assert.assertEquals((long)1L, (long)res.size());
    }

    private static <T> PositionDelete<T> positionDelete(CharSequence path, long pos, T row) {
        PositionDelete positionDelete = PositionDelete.create();
        return positionDelete.set(path, pos, row);
    }
}

