/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestHiveIcebergBranchOperation
extends HiveIcebergStorageHandlerWithEngineBase {
    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET && this.isVectorized && this.testTableType == TestTables.TestTableType.HIVE_CATALOG && this.formatVersion == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBranchWithDefaultConfig() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s", branchName));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
        try {
            shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s", branchName));
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Ref test_branch_1 already exists"));
        }
    }

    @Test
    public void testCreateBranchWithSnapshotId() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR SYSTEM_VERSION AS OF %d", branchName, snapshotId));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchWithTimeStamp() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR SYSTEM_TIME AS OF '%s'", branchName, HiveIcebergTestUtils.timestampAfterSnapshot(table, 0)));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
    }

    @Test
    public void testCreateBranchWithMaxRefAge() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        long maxRefAge = 5L;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s RETAIN %d DAYS", branchName, maxRefAge));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchWithMinSnapshotsToKeep() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        Integer minSnapshotsToKeep = 2;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s WITH SNAPSHOT RETENTION %d SNAPSHOTS", branchName, minSnapshotsToKeep));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchWithMinSnapshotsToKeepAndMaxSnapshotAge() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s WITH SNAPSHOT RETENTION %d SNAPSHOTS %d DAYS", branchName, minSnapshotsToKeep, maxSnapshotAge));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchWithAllCustomConfig() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        long maxRefAge = 5L;
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR SYSTEM_VERSION AS OF %d RETAIN %d DAYS WITH SNAPSHOT RETENTION %d SNAPSHOTS %d days", branchName, snapshotId, maxRefAge, minSnapshotsToKeep, maxSnapshotAge));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)snapshotId, (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchWithNonIcebergTable() {
        shell.executeStatement("create table nonice_tbl (id int, name string)");
        String branchName = "test_branch_1";
        try {
            shell.executeStatement(String.format("ALTER TABLE nonice_tbl CREATE BRANCH %s", branchName));
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Not an iceberg table"));
        }
    }

    @Test
    public void testDropBranch() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_branch_1";
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s", branchName));
        table.refresh();
        Assert.assertNotNull(table.refs().get(branchName));
        shell.executeStatement(String.format("ALTER TABLE customers DROP BRANCH IF EXISTS %s", branchName));
        table.refresh();
        Assert.assertNull(table.refs().get(branchName));
    }

    @Test
    public void testCreateBranchFromTag() throws IOException, InterruptedException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName1 = "test_branch_1";
        String tagName = "test_tag";
        String branchName2 = "test_branch_2";
        String nonExistTag = "test_non_exist_tag";
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s", tagName));
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR TAG AS OF %s", branchName1, tagName));
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName1);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR TAG AS OF %s", branchName2, nonExistTag))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("does not exist");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR TAG AS OF %s", branchName2, branchName1))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("does not exist");
    }

    @Test
    public void testCreateBranchWithNonLowerCase() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        String branchName = "test_Branch_1";
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE BRANCH %s FOR SYSTEM_VERSION AS OF %d", branchName, snapshotId));
        shell.executeStatement(String.format("SELECT * FROM default.customers.branch_%s", branchName));
    }

    @Test
    public void testCreateOrReplaceBranchWithTag() throws InterruptedException, IOException {
        Table table = this.testTables.createTableWithVersions(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, HiveIcebergStorageHandlerTestUtils.CUSTOMER_RECORDS, 2);
        Long snapshotId = ((HistoryEntry)table.history().get(0)).snapshotId();
        shell.executeStatement(String.format("ALTER TABLE customers CREATE TAG %s FOR SYSTEM_VERSION AS OF %d", "test1", snapshotId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("ALTER TABLE customers CREATE OR REPLACE BRANCH test1")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot complete replace branch operation on test1, as it exists as Tag");
    }

    @Test
    public void testCreateOrReplaceBranchWithEmptyTable() throws IOException {
        Table table = this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, this.fileFormat, null, 2);
        Assert.assertEquals((long)0L, (long)table.history().size());
        shell.executeStatement("ALTER TABLE customers CREATE BRANCH test1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> shell.executeStatement("ALTER TABLE customers CREATE OR REPLACE BRANCH test1")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(" Cannot complete replace branch operation on test1, main has no snapshot");
    }
}

